/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.AbstractModuleExtractor;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.DisjointSet;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxiomBasedModuleExtractor
extends AbstractModuleExtractor {
    public static final Logger log = Logger.getLogger(AxiomBasedModuleExtractor.class.getName());
    private boolean optimizeForSharedModules = true;

    public AxiomBasedModuleExtractor() {
    }

    public AxiomBasedModuleExtractor(LocalityClass localityClass) {
        super((LocalityEvaluator)new SyntacticLocalityEvaluator(localityClass));
    }

    public AxiomBasedModuleExtractor(LocalityEvaluator localityEvaluator) {
        super(localityEvaluator);
    }

    private OWLEntity extractModuleSignature(OWLEntity entity, Set<OWLEntity> stackElements, List<OWLEntity> currentCycle, Set<OWLEntity> module) {
        assert (!this.modules.containsKey((Object)entity)) : "po already contained entity";
        assert (currentCycle.isEmpty()) : "non-empty current cycle passed into function";
        HashSet<OWLEntity> myCycle = new HashSet<OWLEntity>();
        if (entity != null) {
            module.add(entity);
            myCycle.add(entity);
            stackElements.add(entity);
            this.modules.put((Object)entity, module);
        }
        int oldSize = -1;
        HashSet<Object> previousModule = new HashSet();
        while (module.size() != oldSize) {
            oldSize = module.size();
            ArrayList<OWLEntity> newMembers = new ArrayList<OWLEntity>();
            Set addedEntities = SetUtils.difference(module, previousModule);
            previousModule = new HashSet<OWLEntity>(module);
            HashSet<OWLAxiom> testLocal = new HashSet<OWLAxiom>();
            for (OWLEntity e : addedEntities) {
                for (OWLAxiom a : this.getAxioms(e)) {
                    if (!testLocal.add(a) || this.isLocal(a, module)) continue;
                    for (OWLEntity ent : this.getSignature(a)) {
                        if (!module.add(ent)) continue;
                        newMembers.add(ent);
                    }
                }
            }
            for (OWLEntity member : newMembers) {
                if (myCycle.contains(member)) continue;
                if (!this.modules.containsKey((Object)member)) {
                    HashSet<OWLEntity> memberMod = new HashSet<OWLEntity>();
                    ArrayList<OWLEntity> memberCycle = new ArrayList<OWLEntity>();
                    OWLEntity root = this.extractModuleSignature(member, stackElements, memberCycle, memberMod);
                    module.addAll(memberMod);
                    if (root.equals(member)) {
                        assert (!stackElements.contains(member)) : "Recursive call did not cleanup stack";
                        continue;
                    }
                    myCycle.addAll(memberCycle);
                    if (myCycle.contains(root)) {
                        stackElements.addAll(memberCycle);
                        continue;
                    }
                    currentCycle.addAll(myCycle);
                    return root;
                }
                if (stackElements.contains(member)) {
                    currentCycle.addAll(myCycle);
                    return member;
                }
                module.addAll((Collection)this.modules.get((Object)member));
            }
            for (OWLEntity e : myCycle) {
                this.modules.put((Object)e, module);
            }
        }
        stackElements.removeAll(myCycle);
        return entity;
    }

    private void extractModuleSignature(OWLEntity entity, DisjointSet<OWLEntity> modEqCls, ArrayList<OWLEntity> stack, Set<OWLEntity> stackElements) {
        assert (!stack.contains(entity)) : "stack contained entity already";
        assert (!this.modules.containsKey((Object)entity)) : "po already contained entity";
        HashSet<OWLEntity> module = new HashSet<OWLEntity>();
        if (entity != null) {
            stack.add(entity);
            stackElements.add(entity);
            modEqCls.add((Object)entity);
            module.add(entity);
            this.modules.put((Object)entity, module);
        }
        int oldSize = -1;
        HashSet previousModule = new HashSet();
        while (module.size() != oldSize) {
            oldSize = module.size();
            ArrayList<OWLEntity> newMembers = new ArrayList<OWLEntity>();
            Set addedEntities = SetUtils.difference(module, previousModule);
            previousModule = new HashSet(module);
            HashSet<OWLAxiom> testLocal = new HashSet<OWLAxiom>();
            for (OWLEntity e : addedEntities) {
                for (OWLAxiom a : this.getAxioms(e)) {
                    if (!testLocal.add(a) || this.isLocal(a, module)) continue;
                    for (OWLEntity ent : this.getSignature(a)) {
                        if (!module.add(ent)) continue;
                        newMembers.add(ent);
                    }
                }
            }
            for (OWLEntity member : newMembers) {
                if (member.equals(entity)) continue;
                if (!this.modules.containsKey((Object)member)) {
                    this.extractModuleSignature(member, modEqCls, stack, stackElements);
                }
                if (stackElements.contains(member)) {
                    assert (stack.contains(member)) : "node was supposed to be on the stack";
                    boolean foundMember = false;
                    int i = stack.size() - 1;
                    while (!foundMember) {
                        OWLEntity next = stack.get(i);
                        modEqCls.union((Object)member, (Object)next);
                        foundMember = next.equals(member);
                        --i;
                    }
                    continue;
                }
                module.addAll((Collection)this.modules.get((Object)member));
            }
        }
        for (OWLEntity other : modEqCls.elements()) {
            if (!modEqCls.isSame((Object)entity, (Object)other)) continue;
            ((Set)this.modules.get((Object)other)).addAll(module);
        }
        stack.remove(stack.size() - 1);
        stackElements.remove(entity);
    }

    @Override
    protected void extractModuleSignatures(Set<? extends OWLEntity> entities) {
        log.fine("Extract module for " + entities);
        ConsoleProgressMonitor monitor = new ConsoleProgressMonitor();
        monitor.setProgressTitle("Extracting");
        monitor.setProgressLength(entities.size());
        monitor.taskStarted();
        HashSet nonLocalModule = new HashSet();
        for (OWLAxiom oWLAxiom : this.getAxioms()) {
            if (this.isLocal(oWLAxiom, Collections.<OWLEntity>emptySet())) continue;
            nonLocalModule.addAll(OntologyUtils.getSignature((OWLAxiom)oWLAxiom));
        }
        for (OWLEntity oWLEntity : entities) {
            monitor.incrementProgress();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Class: " + oWLEntity);
            }
            if (this.modules.containsKey((Object)oWLEntity)) continue;
            if (this.optimizeForSharedModules) {
                this.extractModuleSignature(oWLEntity, new HashSet<OWLEntity>(), new ArrayList<OWLEntity>(), new HashSet<OWLEntity>(nonLocalModule));
                continue;
            }
            this.extractModuleSignature(oWLEntity, (DisjointSet<OWLEntity>)new DisjointSet(), new ArrayList<OWLEntity>(), new HashSet<OWLEntity>(nonLocalModule));
        }
        monitor.taskFinished();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.modules.toString());
        }
    }

    @Override
    public Set<OWLAxiom> extractModule(Set<? extends OWLEntity> signature) {
        if (this.isChanged()) {
            this.resetModules();
        }
        HashSet<OWLEntity> module = new HashSet<OWLEntity>(signature);
        for (OWLAxiom axiom : this.getAxioms()) {
            if (this.isLocal(axiom, Collections.<OWLEntity>emptySet())) continue;
            module.addAll(OntologyUtils.getSignature((OWLAxiom)axiom));
        }
        if (!this.entityAxioms.isEmpty()) {
            if (this.optimizeForSharedModules) {
                this.extractModuleSignature(null, new HashSet<OWLEntity>(), new ArrayList<OWLEntity>(), module);
            } else {
                this.extractModuleSignature(null, (DisjointSet<OWLEntity>)new DisjointSet(), new ArrayList<OWLEntity>(), module);
            }
        }
        return this.getModuleAxioms(module);
    }

    public boolean isOptimizeForSharedModules() {
        return this.optimizeForSharedModules;
    }

    public void setOptimizeForSharedModules(boolean optimizeForSharedModules) {
        this.optimizeForSharedModules = optimizeForSharedModules;
    }
}

