/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class EquivalentToComplementPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return "A named concept is equivalent to some complement";
    }

    public boolean isFixable() {
        return true;
    }

    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set owlDescs = axiom.getClassExpressions();
        if (owlDescs.size() != 2) {
            return;
        }
        OWLClass namedClass = null;
        OWLClassExpression complementOf = null;
        for (OWLClassExpression owlDesc : owlDescs) {
            if (!owlDesc.isAnonymous()) {
                namedClass = owlDesc.asOWLClass();
                continue;
            }
            if (!(owlDesc instanceof OWLObjectComplementOf)) continue;
            complementOf = owlDesc;
        }
        if (namedClass != null && complementOf != null) {
            Lint lint = this.makeLint();
            lint.addParticipatingClass(namedClass);
            lint.addParticipatingAxiom((OWLClassAxiom)axiom);
            OWLSubClassOfAxiom newAxiom = OWL.subClassOf((OWLClassExpression)namedClass, (OWLClassExpression)complementOf);
            LintFixer fixer = new LintFixer((OWLAxiom)axiom, (OWLAxiom)newAxiom);
            lint.setLintFixer(fixer);
            this.setLint(lint);
        }
    }
}

