/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class AbstractTripleHandler {
    private OWLRDFConsumer consumer;
    private ClassExpressionMatcher classExpressionMatcher = new ClassExpressionMatcher();
    private DataRangeMatcher dataRangeMatcher = new DataRangeMatcher();
    private IndividualMatcher individualMatcher = new IndividualMatcher();

    public AbstractTripleHandler(OWLRDFConsumer consumer) {
        this.consumer = consumer;
    }

    public OWLRDFConsumer getConsumer() {
        return this.consumer;
    }

    protected Set<OWLAnnotation> getPendingAnnotations() {
        return this.consumer.getPendingAnnotations();
    }

    protected void consumeTriple(IRI subject, IRI predicate, IRI object) {
        this.consumer.consumeTriple(subject, predicate, object);
    }

    protected void consumeTriple(IRI subject, IRI predicate, OWLLiteral object) {
        this.consumer.consumeTriple(subject, predicate, object);
    }

    protected boolean isStrict() {
        return this.consumer.getConfiguration().isStrict();
    }

    protected boolean isObjectPropertyOnly(IRI iri) {
        return this.consumer.isObjectPropertyOnly(iri);
    }

    protected boolean isDataPropertyOnly(IRI iri) {
        return this.consumer.isDataPropertyOnly(iri);
    }

    protected boolean isAnnotationPropertyOnly(IRI iri) {
        return this.consumer.isAnnotationPropertyOnly(iri);
    }

    protected boolean isAnnotationPropertyStrict(IRI iri) {
        return this.consumer.isAnnotationPropertyOnly(iri);
    }

    protected boolean isAnnotationPropertyLax(IRI iri) {
        return this.consumer.isAnnotationProperty(iri);
    }

    protected void addAxiom(OWLAxiom axiom) {
        this.consumer.addAxiom(axiom);
    }

    protected OWLDataFactory getDataFactory() {
        return this.consumer.getDataFactory();
    }

    protected OWLClassExpression translateClassExpression(IRI IRI2) {
        return this.consumer.translateClassExpression(IRI2);
    }

    protected OWLObjectPropertyExpression translateObjectProperty(IRI IRI2) {
        return this.consumer.translateObjectPropertyExpression(IRI2);
    }

    protected OWLDataPropertyExpression translateDataProperty(IRI IRI2) {
        return this.consumer.translateDataPropertyExpression(IRI2);
    }

    protected OWLDataRange translateDataRange(IRI IRI2) {
        return this.consumer.translateDataRange(IRI2);
    }

    protected OWLIndividual translateIndividual(IRI IRI2) {
        return this.consumer.translateIndividual(IRI2);
    }

    protected boolean isAnonymous(IRI node) {
        return this.consumer.isAnonymousNode(node);
    }

    protected boolean isResourcePresent(IRI mainNode, OWLRDFVocabulary predicate) {
        return this.consumer.getResourceObject(mainNode, predicate, false) != null;
    }

    protected boolean isLiteralPresent(IRI mainNode, OWLRDFVocabulary predicate) {
        return this.consumer.getLiteralObject(mainNode, predicate, false) != null;
    }

    protected boolean isRestrictionStrict(IRI node) {
        return this.consumer.isRestriction(node);
    }

    protected boolean isRestrictionLax(IRI node) {
        return this.consumer.isRestriction(node);
    }

    protected boolean isNonNegativeIntegerStrict(IRI mainNode, OWLRDFVocabulary predicate) {
        OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, false);
        if (literal == null) {
            return false;
        }
        OWLDatatype datatype = literal.getDatatype();
        OWL2Datatype nni = OWL2Datatype.XSD_NON_NEGATIVE_INTEGER;
        return datatype.getIRI().equals(nni.getIRI()) && nni.isInLexicalSpace(literal.getLiteral());
    }

    protected boolean isNonNegativeIntegerLax(IRI mainNode, OWLRDFVocabulary predicate) {
        OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, false);
        if (literal == null) {
            return false;
        }
        return OWL2Datatype.XSD_INTEGER.isInLexicalSpace(literal.getLiteral().trim());
    }

    protected int translateInteger(IRI mainNode, OWLRDFVocabulary predicate) {
        OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, true);
        if (literal == null) {
            return 0;
        }
        try {
            return Integer.parseInt(literal.getLiteral().trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected boolean isClassExpressionStrict(IRI node) {
        return this.consumer.isClassExpression(node) && !this.consumer.isDataRange(node);
    }

    protected boolean isClassExpressionStrict(IRI mainNode, OWLRDFVocabulary predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.isClassExpressionStrict(object);
    }

    protected boolean isClassExpressionLax(IRI mainNode) {
        return this.consumer.isClassExpression(mainNode) || this.consumer.isParsedAllTriples() && !this.consumer.isDataRange(mainNode);
    }

    protected boolean isClassExpressionLax(IRI mainNode, OWLRDFVocabulary predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.isClassExpressionLax(object);
    }

    protected boolean isObjectPropertyStrict(IRI node) {
        return this.consumer.isObjectPropertyOnly(node);
    }

    protected boolean isObjectPropertyStrict(IRI mainNode, OWLRDFVocabulary predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.isObjectPropertyStrict(object);
    }

    protected boolean isObjectPropertyLax(IRI node) {
        return this.consumer.isObjectProperty(node);
    }

    protected boolean isObjectPropertyLax(IRI mainNode, OWLRDFVocabulary predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.isObjectPropertyLax(object);
    }

    protected boolean isDataPropertyStrict(IRI node) {
        return this.consumer.isDataPropertyOnly(node);
    }

    protected boolean isDataPropertyStrict(IRI mainNode, OWLRDFVocabulary predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.isDataPropertyStrict(object);
    }

    protected boolean isDataPropertyLax(IRI node) {
        return this.consumer.isDataProperty(node);
    }

    protected boolean isDataPropertyLax(IRI mainNode, OWLRDFVocabulary predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.isDataPropertyLax(object);
    }

    protected boolean isDataRangeStrict(IRI node) {
        return this.consumer.isDataRange(node) && !this.consumer.isClassExpression(node);
    }

    protected boolean isDataRangeStrict(IRI mainNode, OWLRDFVocabulary predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return this.isDataRangeStrict(object);
    }

    protected boolean isDataRangeLax(IRI node) {
        return this.consumer.isDataRange(node);
    }

    protected boolean isDataRangeLax(IRI mainNode, OWLRDFVocabulary predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.isDataRangeLax(mainNode);
    }

    protected boolean isClassExpressionListStrict(IRI mainNode, int minSize) {
        return this.isResourceListStrict(mainNode, this.classExpressionMatcher, minSize);
    }

    protected boolean isDataRangeListStrict(IRI mainNode, int minSize) {
        return this.isResourceListStrict(mainNode, this.dataRangeMatcher, minSize);
    }

    protected boolean isIndividualListStrict(IRI mainNode, int minSize) {
        return this.isResourceListStrict(mainNode, this.individualMatcher, minSize);
    }

    protected boolean isResourceListStrict(IRI mainNode, TypeMatcher typeMatcher, int minSize) {
        if (mainNode == null) {
            return false;
        }
        IRI currentListNode = mainNode;
        HashSet<IRI> visitedListNodes = new HashSet<IRI>();
        int size = 0;
        IRI firstObject;
        while ((firstObject = this.consumer.getResourceObject(currentListNode, OWLRDFVocabulary.RDF_FIRST, false)) != null) {
            if (!typeMatcher.isTypeStrict(firstObject)) {
                return false;
            }
            ++size;
            IRI restObject = this.consumer.getResourceObject(currentListNode, OWLRDFVocabulary.RDF_REST, false);
            if (visitedListNodes.contains(restObject)) {
                return false;
            }
            if (restObject == null) {
                return false;
            }
            if (restObject.equals(OWLRDFVocabulary.RDF_NIL.getIRI())) {
                return size >= minSize;
            }
            visitedListNodes.add(restObject);
            currentListNode = restObject;
        }
        return false;
    }

    private class IndividualMatcher
    implements TypeMatcher {
        @Override
        public boolean isTypeStrict(IRI node) {
            return true;
        }
    }

    private class DataRangeMatcher
    implements TypeMatcher {
        @Override
        public boolean isTypeStrict(IRI node) {
            return AbstractTripleHandler.this.isDataRangeStrict(node);
        }
    }

    private class ClassExpressionMatcher
    implements TypeMatcher {
        @Override
        public boolean isTypeStrict(IRI node) {
            return AbstractTripleHandler.this.isClassExpressionStrict(node);
        }
    }

    private static interface TypeMatcher {
        public boolean isTypeStrict(IRI var1);
    }
}

