/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class CreateValuePartition
extends AbstractCompositeOntologyChange {
    private List<OWLOntologyChange> changes;
    private final OWLOntology targetOntology;
    private final Set<OWLClass> valuePartionClasses;
    private final OWLClass valuePartitionClass;
    private final OWLObjectProperty valuePartitionProperty;

    public CreateValuePartition(OWLDataFactory dataFactory, OWLClass valuePartitionClass, Set<OWLClass> valuePartionClasses, OWLObjectProperty valuePartitionProperty, OWLOntology targetOntology) {
        super(dataFactory);
        this.targetOntology = targetOntology;
        this.valuePartionClasses = valuePartionClasses;
        this.valuePartitionClass = valuePartitionClass;
        this.valuePartitionProperty = valuePartitionProperty;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        for (OWLClassExpression oWLClassExpression : this.valuePartionClasses) {
            this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLSubClassOfAxiom(oWLClassExpression, this.valuePartitionClass)));
        }
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(this.valuePartionClasses)));
        OWLObjectUnionOf union = this.getDataFactory().getOWLObjectUnionOf(this.valuePartionClasses);
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLSubClassOfAxiom(this.valuePartitionClass, union)));
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLFunctionalObjectPropertyAxiom(this.valuePartitionProperty)));
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLObjectPropertyRangeAxiom(this.valuePartitionProperty, this.valuePartitionClass)));
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

