/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.semanticweb.owlapi.io.IOProperties;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.xml.sax.InputSource;

public abstract class AbstractOWLParser
implements OWLParser {
    private static final Logger logger = Logger.getLogger(AbstractOWLParser.class.getName());
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final Pattern CONTENT_DISPOSITION_FILE_NAME_PATTERN = Pattern.compile(".*filename=\"([^\\s;]*)\".*");
    private static final int CONTENT_DISPOSITION_FILE_NAME_PATTERN_GROUP = 1;
    private static final Pattern ZIP_ENTRY_ONTOLOGY_NAME_PATTERN = Pattern.compile(".*owl|rdf|xml|mos");
    private OWLOntologyManager owlOntologyManager;

    protected AbstractOWLParser() {
    }

    @Override
    @Deprecated
    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) {
        this.owlOntologyManager = owlOntologyManager;
    }

    @Deprecated
    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    protected String getRequestTypes() {
        return "application/rdf+xml, application/xml; q=0.5, text/xml; q=0.3, */*; q=0.2";
    }

    protected InputStream getInputStream(IRI documentIRI) throws IOException {
        String requestType = this.getRequestTypes();
        URLConnection conn = documentIRI.toURI().toURL().openConnection();
        conn.addRequestProperty("Accept", requestType);
        if (IOProperties.getInstance().isConnectionAcceptHTTPCompression()) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        conn.setConnectTimeout(IOProperties.getInstance().getConnectionTimeout());
        String contentEncoding = conn.getContentEncoding();
        InputStream is = this.getInputStreamFromContentEncoding(conn, contentEncoding);
        if (this.isZipName(documentIRI, conn)) {
            ZipEntry nextEntry;
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = zis.getNextEntry();
            while (!this.couldBeOntology(entry) && (nextEntry = zis.getNextEntry()) != null) {
                entry = nextEntry;
            }
            is = new BufferedInputStream(zis);
        }
        return is;
    }

    private boolean couldBeOntology(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        Matcher matcher = ZIP_ENTRY_ONTOLOGY_NAME_PATTERN.matcher(name);
        return matcher.matches();
    }

    private InputStream getInputStreamFromContentEncoding(URLConnection conn, String contentEncoding) throws IOException {
        BufferedInputStream is;
        if ("gzip".equals(contentEncoding)) {
            logger.fine("URL connection input stream is compressed using gzip");
            is = new BufferedInputStream(new GZIPInputStream(conn.getInputStream()));
        } else if ("deflate".equals(contentEncoding)) {
            logger.fine("URL connection input stream is compressed using deflate");
            is = new BufferedInputStream(new InflaterInputStream(conn.getInputStream(), new Inflater(true)));
        } else {
            is = new BufferedInputStream(conn.getInputStream());
        }
        return is;
    }

    private boolean isZipName(IRI documentIRI, URLConnection connection) {
        if (this.isZipFileName(documentIRI.toString())) {
            return true;
        }
        String fileName = this.getFileNameFromContentDisposition(connection);
        return fileName != null && this.isZipFileName(fileName);
    }

    private String getFileNameFromContentDisposition(URLConnection connection) {
        Matcher matcher;
        String contentDispositionHeaderValue = connection.getHeaderField(CONTENT_DISPOSITION_HEADER);
        if (contentDispositionHeaderValue != null && (matcher = CONTENT_DISPOSITION_FILE_NAME_PATTERN.matcher(contentDispositionHeaderValue)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean isZipFileName(String fileName) {
        return fileName.toLowerCase(Locale.getDefault()).endsWith(ZIP_FILE_EXTENSION);
    }

    protected InputSource getInputSource(OWLOntologyDocumentSource documentSource) throws IOException {
        InputSource is = documentSource.isReaderAvailable() ? new InputSource(documentSource.getReader()) : (documentSource.isInputStreamAvailable() ? new InputSource(documentSource.getInputStream()) : new InputSource(this.getInputStream(documentSource.getDocumentIRI())));
        is.setSystemId(documentSource.getDocumentIRI().toString());
        return is;
    }

    @Override
    public OWLOntologyFormat parse(IRI documentIRI, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(new IRIDocumentSource(documentIRI), ontology);
    }
}

