/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.syntax;

import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RDFParserException
extends SAXException {
    private static final long serialVersionUID = 30402L;
    protected String m_publicId;
    protected String m_systemId;
    protected int m_lineNumber;
    protected int m_columnNumber;

    public RDFParserException(String message) {
        this(message, null, null, -1, -1);
    }

    public RDFParserException(String message, Locator locator) {
        this(message, locator.getPublicId(), locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
    }

    public RDFParserException(String message, String publicId, String systemId, int lineNumber, int columnNumber) {
        super((lineNumber != -1 || columnNumber != -1 ? "[line=" + lineNumber + ":" + "column=" + columnNumber + "] " : "") + message);
        this.m_publicId = publicId;
        this.m_systemId = systemId;
        this.m_lineNumber = lineNumber;
        this.m_columnNumber = columnNumber;
    }

    public String getPublicId() {
        return this.m_publicId;
    }

    public String getSystemId() {
        return this.m_systemId;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }
}

