/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.LinkedHashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

public class SWRLVariableExtractor
implements SWRLObjectVisitor {
    private final Set<SWRLVariable> variables = new LinkedHashSet<SWRLVariable>();

    public Set<SWRLVariable> getVariables() {
        return new LinkedHashSet<SWRLVariable>(this.variables);
    }

    public void reset() {
        this.variables.clear();
    }

    @Override
    public void visit(SWRLRule node) {
        for (SWRLAtom atom : node.getBody()) {
            atom.accept(this);
        }
        for (SWRLAtom atom : node.getHead()) {
            atom.accept(this);
        }
    }

    @Override
    public void visit(SWRLClassAtom node) {
        ((SWRLIArgument)node.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        ((SWRLDArgument)node.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        for (SWRLObject sWRLObject : node.getArguments()) {
            sWRLObject.accept(this);
        }
    }

    @Override
    public void visit(SWRLVariable node) {
        this.variables.add(node);
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
    }
}

