/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.lang.ref.WeakReference;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.WeakCache;
import org.semanticweb.owlapi.util.WeakIndexCache;
import uk.ac.manchester.cs.owl.owlapi.InternalsNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplDouble;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplFloat;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplInteger;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends InternalsNoCache {
    private static final long serialVersionUID = 30402L;
    private final BuildableWeakIndexCache<OWLClass> classesByURI;
    private final BuildableWeakIndexCache<OWLObjectProperty> objectPropertiesByURI;
    private final BuildableWeakIndexCache<OWLDataProperty> dataPropertiesByURI;
    private final BuildableWeakIndexCache<OWLDatatype> datatypesByURI;
    private final BuildableWeakIndexCache<OWLNamedIndividual> individualsByURI;
    private final BuildableWeakIndexCache<OWLAnnotationProperty> annotationPropertiesByURI;
    private final WeakIndexCache<Integer, OWLLiteral> intCache = new WeakIndexCache();
    private final WeakIndexCache<Double, OWLLiteral> doubleCache = new WeakIndexCache();
    private final WeakIndexCache<Float, OWLLiteral> floatCache = new WeakIndexCache();
    private final WeakIndexCache<String, OWLLiteral> stringCache = new WeakIndexCache();
    private final WeakCache<OWLLiteral> litCache = new WeakCache();

    protected <V extends OWLEntity> BuildableWeakIndexCache<V> buildCache(OWLDataFactory f) {
        return new BuildableWeakIndexCache(f);
    }

    public OWLDataFactoryInternalsImpl(OWLDataFactory f, boolean useCompression) {
        super(f, useCompression);
        this.classesByURI = this.buildCache(f);
        this.objectPropertiesByURI = this.buildCache(f);
        this.dataPropertiesByURI = this.buildCache(f);
        this.datatypesByURI = this.buildCache(f);
        this.individualsByURI = this.buildCache(f);
        this.annotationPropertiesByURI = this.buildCache(f);
    }

    @Override
    public OWLLiteral getOWLLiteral(float value) {
        return this.floatCache.cache(Float.valueOf(value), super.getOWLLiteral(value));
    }

    @Override
    public OWLLiteral getOWLLiteral(String value) {
        return this.stringCache.cache(value, super.getOWLLiteral(value));
    }

    @Override
    public OWLLiteral getOWLLiteral(int value) {
        return this.intCache.cache(value, super.getOWLLiteral(value));
    }

    @Override
    public OWLLiteral getOWLLiteral(double value) {
        return this.doubleCache.cache(value, super.getOWLLiteral(value));
    }

    @Override
    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        OWLLiteral literal = super.getOWLLiteral(lexicalValue, datatype);
        if (datatype.isBoolean()) {
            return literal;
        }
        if (literal instanceof OWLLiteralImplFloat) {
            return this.floatCache.cache(Float.valueOf(((OWLLiteralImplFloat)literal).parseFloat()), literal);
        }
        if (literal instanceof OWLLiteralImplDouble) {
            return this.doubleCache.cache(((OWLLiteralImplDouble)literal).parseDouble(), literal);
        }
        if (literal instanceof OWLLiteralImplInteger) {
            return this.intCache.cache(((OWLLiteralImplInteger)literal).parseInteger(), literal);
        }
        if (datatype.isString()) {
            return this.stringCache.cache(literal.getLiteral(), literal);
        }
        return this.litCache.cache(literal);
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return this.classesByURI.cache(iri, Buildable.OWLCLASS);
    }

    @Override
    public void purge() {
        this.litCache.clear();
        this.classesByURI.clear();
        this.objectPropertiesByURI.clear();
        this.dataPropertiesByURI.clear();
        this.datatypesByURI.clear();
        this.individualsByURI.clear();
        this.annotationPropertiesByURI.clear();
        this.intCache.clear();
        this.doubleCache.clear();
        this.floatCache.clear();
        this.stringCache.clear();
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.objectPropertiesByURI.cache(iri, Buildable.OWLOBJECTPROPERTY);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.dataPropertiesByURI.cache(iri, Buildable.OWLDATAPROPERTY);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return this.individualsByURI.cache(iri, Buildable.OWLNAMEDINDIVIDUAL);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return this.datatypesByURI.cache(iri, Buildable.OWLDATATYPE);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return this.annotationPropertiesByURI.cache(iri, Buildable.OWLANNOTATIONPROPERTY);
    }

    protected static enum Buildable {
        OWLCLASS{

            OWLClass build(IRI iri) {
                return new OWLClassImpl(iri);
            }
        }
        ,
        OWLOBJECTPROPERTY{

            OWLObjectProperty build(IRI iri) {
                return new OWLObjectPropertyImpl(iri);
            }
        }
        ,
        OWLDATAPROPERTY{

            OWLDataProperty build(IRI iri) {
                return new OWLDataPropertyImpl(iri);
            }
        }
        ,
        OWLNAMEDINDIVIDUAL{

            OWLNamedIndividual build(IRI iri) {
                return new OWLNamedIndividualImpl(iri);
            }
        }
        ,
        OWLDATATYPE{

            OWLDatatype build(IRI iri) {
                return new OWLDatatypeImpl(iri);
            }
        }
        ,
        OWLANNOTATIONPROPERTY{

            OWLAnnotationProperty build(IRI iri) {
                return new OWLAnnotationPropertyImpl(iri);
            }
        };


        abstract <K extends OWLEntity> K build(IRI var1);
    }

    protected class BuildableWeakIndexCache<V extends OWLEntity>
    extends WeakIndexCache<IRI, V> {
        private static final long serialVersionUID = 30402L;
        protected final OWLDataFactory f;

        public BuildableWeakIndexCache(OWLDataFactory f) {
            this.f = f;
        }

        @Override
        public V cache(IRI s, Buildable v) {
            OWLEntity toReturn;
            WeakReference w = (WeakReference)this.prefixCache.get(s);
            if (w != null && (toReturn = (OWLEntity)w.get()) != null) {
                return (V)toReturn;
            }
            Object value = v.build(s);
            this.prefixCache.put(s, new WeakReference(value));
            return (V)value;
        }
    }
}

