/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousClassExpressionImpl;

public class OWLObjectOneOfImpl
extends OWLAnonymousClassExpressionImpl
implements OWLObjectOneOf {
    private static final long serialVersionUID = 30402L;
    private final Set<OWLIndividual> values;

    public OWLObjectOneOfImpl(Set<? extends OWLIndividual> values) {
        this.values = new HashSet<OWLIndividual>(values);
    }

    @Override
    public ClassExpressionType getClassExpressionType() {
        return ClassExpressionType.OBJECT_ONE_OF;
    }

    @Override
    public Set<OWLIndividual> getIndividuals() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.values);
    }

    @Override
    public boolean isClassExpressionLiteral() {
        return false;
    }

    @Override
    public OWLClassExpression asObjectUnionOf() {
        if (this.values.size() == 1) {
            return this;
        }
        HashSet<OWLObjectOneOf> ops = new HashSet<OWLObjectOneOf>();
        for (OWLIndividual ind : this.values) {
            ops.add(OWLObjectOneOfImpl.getOWLDataFactory().getOWLObjectOneOf(ind));
        }
        return OWLObjectOneOfImpl.getOWLDataFactory().getOWLObjectUnionOf(ops);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLObjectOneOf)) {
                return false;
            }
            return ((OWLObjectOneOf)obj).getIndividuals().equals(this.values);
        }
        return false;
    }

    @Override
    public void accept(OWLClassExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLClassExpressionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLObjectOneOfImpl.compareSets(this.values, ((OWLObjectOneOf)object).getIndividuals());
    }
}

