/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.EntailmentQueryVisitor;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntailmentChecker
implements OWLAxiomVisitor {
    public static Logger log = Logger.getLogger(EntailmentChecker.class.getName());
    public static final Set<AxiomType<?>> UNSUPPORTED_ENTAILMENT = Collections.unmodifiableSet(new HashSet<AxiomType>(Arrays.asList(AxiomType.DISJOINT_UNION, AxiomType.DATATYPE_DEFINITION, AxiomType.HAS_KEY, AxiomType.SUB_PROPERTY_CHAIN_OF, AxiomType.SWRL_RULE)));
    private PelletReasoner reasoner;
    private KnowledgeBase kb;
    private boolean isDeferred = false;
    private boolean isEntailed = false;
    private EntailmentQueryVisitor queryVisitor;

    public EntailmentChecker(PelletReasoner reasoner) {
        this.reasoner = reasoner;
        this.kb = reasoner.getKB();
        this.queryVisitor = new EntailmentQueryVisitor(reasoner);
    }

    private void deferAxiom(OWLIndividualAxiom axiom) {
        this.isDeferred = true;
        axiom.accept((OWLAxiomVisitor)this.queryVisitor);
    }

    private boolean isEntailed(OWLAxiom axiom) {
        this.isDeferred = false;
        this.isEntailed = false;
        axiom.accept((OWLAxiomVisitor)this);
        return this.isDeferred || this.isEntailed;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        if (!axioms.isEmpty()) {
            this.queryVisitor.reset();
            for (OWLAxiom oWLAxiom : axioms) {
                if (this.isEntailed(oWLAxiom)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Axiom not entailed: (" + oWLAxiom + ")");
                }
                return false;
            }
            return this.queryVisitor.isEntailed();
        }
        log.warning("Empty ontologies are entailed by any premise document!");
        return true;
    }

    public Set<OWLAxiom> findNonEntailments(Set<? extends OWLAxiom> axioms, boolean findAll) {
        HashSet<OWLAxiom> nonEntailments = new HashSet<OWLAxiom>();
        if (axioms.isEmpty()) {
            log.warning("Empty ontologies are entailed by any premise document!");
        } else {
            HashSet<OWLAxiom> deferredAxioms = new HashSet<OWLAxiom>();
            this.queryVisitor.reset();
            for (OWLAxiom oWLAxiom : axioms) {
                if (!this.isEntailed(oWLAxiom)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Axiom not entailed: (" + oWLAxiom + ")");
                    }
                    nonEntailments.add(oWLAxiom);
                    if (!findAll) continue;
                    break;
                }
                if (!this.isDeferred) continue;
                deferredAxioms.add(oWLAxiom);
            }
            if ((findAll || nonEntailments.isEmpty()) && !this.queryVisitor.isEntailed()) {
                nonEntailments.addAll(deferredAxioms);
            }
        }
        return nonEntailments;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.isEntailed = this.kb.isSubClassOf(this.reasoner.term((OWLObject)axiom.getSubClass()), this.reasoner.term((OWLObject)axiom.getSuperClass()));
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        OWLIndividual o = (OWLIndividual)axiom.getObject();
        if (s.isAnonymous() || o.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        OWLDataFactory factory = this.reasoner.getManager().getOWLDataFactory();
        OWLObjectHasValue hasValue = factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), o);
        OWLObjectComplementOf doesNotHaveValue = factory.getOWLObjectComplementOf((OWLClassExpression)hasValue);
        this.isEntailed = this.kb.isType(this.reasoner.term((OWLObject)s), this.reasoner.term((OWLObject)doesNotHaveValue));
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.isEntailed = this.kb.isAsymmetricProperty(this.reasoner.term((OWLObject)axiom.getProperty()));
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.kb.isReflexiveProperty(this.reasoner.term((OWLObject)axiom.getProperty()));
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        int i;
        this.isEntailed = true;
        int n = axiom.getClassExpressions().size();
        ATermAppl[] terms = new ATermAppl[n];
        Iterator expIter = axiom.getClassExpressions().iterator();
        for (i = 0; i < n; ++i) {
            terms[i] = this.reasoner.term((OWLObject)expIter.next());
        }
        for (i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.kb.isDisjoint(terms[i], terms[j])) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.isEntailed = this.kb.hasDomain(this.reasoner.term((OWLObject)axiom.getProperty()), this.reasoner.term((OWLObject)axiom.getDomain()));
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.isEntailed = this.kb.hasDomain(this.reasoner.term((OWLObject)axiom.getProperty()), this.reasoner.term((OWLObject)axiom.getDomain()));
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getProperties().iterator();
        if (i.hasNext()) {
            OWLObjectPropertyExpression head = (OWLObjectPropertyExpression)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLObjectPropertyExpression next = (OWLObjectPropertyExpression)i.next();
                this.isEntailed = this.kb.isEquivalentProperty(this.reasoner.term((OWLObject)head), this.reasoner.term((OWLObject)next));
            }
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        if (s.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        OWLDataFactory factory = this.reasoner.getManager().getOWLDataFactory();
        OWLDataHasValue hasValue = factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
        OWLObjectComplementOf doesNotHaveValue = factory.getOWLObjectComplementOf((OWLClassExpression)hasValue);
        this.isEntailed = this.kb.isType(this.reasoner.term((OWLObject)s), this.reasoner.term((OWLObject)doesNotHaveValue));
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.isEntailed = true;
        for (OWLIndividual ind : axiom.getIndividuals()) {
            if (!ind.isAnonymous()) continue;
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        ArrayList list = new ArrayList(axiom.getIndividuals());
        for (int i = 0; i < list.size() - 1; ++i) {
            OWLIndividual head = (OWLIndividual)list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                OWLIndividual next = (OWLIndividual)list.get(j);
                if (this.kb.isDifferentFrom(this.reasoner.term((OWLObject)head), this.reasoner.term((OWLObject)next))) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.isEntailed = true;
        int n = axiom.getProperties().size();
        OWLDataProperty[] properties = axiom.getProperties().toArray(new OWLDataProperty[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.kb.isDisjointProperty(this.reasoner.term((OWLObject)properties[i]), this.reasoner.term((OWLObject)properties[j]))) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.isEntailed = true;
        int n = axiom.getProperties().size();
        OWLObjectPropertyExpression[] properties = axiom.getProperties().toArray(new OWLObjectPropertyExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.kb.isDisjointProperty(this.reasoner.term((OWLObject)properties[i]), this.reasoner.term((OWLObject)properties[j]))) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.isEntailed = this.kb.hasRange(this.reasoner.term((OWLObject)axiom.getProperty()), this.reasoner.term((OWLObject)axiom.getRange()));
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        OWLIndividual o = (OWLIndividual)axiom.getObject();
        if (s.isAnonymous() || o.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        this.isEntailed = this.kb.hasPropertyValue(this.reasoner.term((OWLObject)s), this.reasoner.term((OWLObject)axiom.getProperty()), this.reasoner.term((OWLObject)o));
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.isEntailed = this.kb.isFunctionalProperty(this.reasoner.term((OWLObject)axiom.getProperty()));
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.isEntailed = this.kb.isSubPropertyOf(this.reasoner.term((OWLObject)axiom.getSubProperty()), this.reasoner.term((OWLObject)axiom.getSuperProperty()));
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(axiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(axiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring declaration " + axiom);
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.isEntailed = this.kb.isSymmetricProperty(this.reasoner.term((OWLObject)axiom.getProperty()));
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.isEntailed = this.kb.hasRange(this.reasoner.term((OWLObject)axiom.getProperty()), this.reasoner.term((OWLObject)axiom.getRange()));
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.isEntailed = this.kb.isFunctionalProperty(this.reasoner.term((OWLObject)axiom.getProperty()));
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getProperties().iterator();
        if (i.hasNext()) {
            OWLDataProperty first = (OWLDataProperty)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLDataProperty next = (OWLDataProperty)i.next();
                this.isEntailed = this.kb.isEquivalentProperty(this.reasoner.term((OWLObject)first), this.reasoner.term((OWLObject)next));
            }
        }
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        OWLIndividual ind = axiom.getIndividual();
        OWLClassExpression c = axiom.getClassExpression();
        if (ind.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        this.isEntailed = this.kb.isType(this.reasoner.term((OWLObject)ind), this.reasoner.term((OWLObject)c));
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getClassExpressions().iterator();
        if (i.hasNext()) {
            OWLClassExpression first = (OWLClassExpression)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLClassExpression next = (OWLClassExpression)i.next();
                this.isEntailed = this.kb.isEquivalentClass(this.reasoner.term((OWLObject)first), this.reasoner.term((OWLObject)next));
            }
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        if (s.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        this.isEntailed = this.kb.hasPropertyValue(this.reasoner.term((OWLObject)s), this.reasoner.term((OWLObject)axiom.getProperty()), this.reasoner.term((OWLObject)axiom.getObject()));
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.kb.isTransitiveProperty(this.reasoner.term((OWLObject)axiom.getProperty()));
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.kb.isIrreflexiveProperty(this.reasoner.term((OWLObject)axiom.getProperty()));
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.isEntailed = this.kb.isSubPropertyOf(this.reasoner.term((OWLObject)axiom.getSubProperty()), this.reasoner.term((OWLObject)axiom.getSuperProperty()));
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.isEntailed = this.kb.isInverseFunctionalProperty(this.reasoner.term((OWLObject)axiom.getProperty()));
    }

    public void visit(OWLHasKeyAxiom axiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(axiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        for (OWLIndividual ind : axiom.getIndividuals()) {
            if (!ind.isAnonymous()) continue;
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        this.isEntailed = true;
        Iterator i = axiom.getIndividuals().iterator();
        if (i.hasNext()) {
            OWLIndividual first = (OWLIndividual)i.next();
            while (i.hasNext()) {
                OWLIndividual next = (OWLIndividual)i.next();
                if (this.kb.isSameAs(this.reasoner.term((OWLObject)first), this.reasoner.term((OWLObject)next))) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(axiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.isEntailed = this.kb.isInverse(this.reasoner.term((OWLObject)axiom.getFirstProperty()), this.reasoner.term((OWLObject)axiom.getSecondProperty()));
    }

    public void visit(SWRLRule rule) {
        assert (UNSUPPORTED_ENTAILMENT.contains(rule.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + rule);
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation assertion axiom " + axiom);
        }
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation property domain " + axiom);
        }
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation property range " + axiom);
        }
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring sub annotation property axiom " + axiom);
        }
    }
}

