/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.taxonomy.printer.TreeTaxonomyPrinter;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassTreePrinter
extends TreeTaxonomyPrinter<OWLClass>
implements TaxonomyPrinter<OWLClass> {
    private QNameProvider qnames = new QNameProvider();

    protected void printNode(Set<OWLClass> set) {
        super.printNode(set);
        Set<OWLNamedIndividual> instances = OWLClassTreePrinter.getDirectInstances((Taxonomy<OWLClass>)this.taxonomy, set.iterator().next());
        if (instances.size() > 0) {
            this.out.print(" - (");
            boolean printed = false;
            Iterator<OWLNamedIndividual> ins = instances.iterator();
            int k = 0;
            while (ins.hasNext()) {
                OWLNamedIndividual x = ins.next();
                if (printed) {
                    this.out.print(", ");
                } else {
                    printed = true;
                }
                this.printURI(this.out, x);
                ++k;
            }
            this.out.print(")");
        }
    }

    protected void printURI(PrintWriter out, OWLClass c) {
        this.printIRI(out, c.getIRI());
    }

    private void printURI(PrintWriter out, OWLNamedIndividual i) {
        this.printIRI(out, i.getIRI());
    }

    private void printIRI(PrintWriter out, IRI iri) {
        out.print(this.qnames.shortForm(iri.toString()));
    }

    public static Set<OWLNamedIndividual> getDirectInstances(Taxonomy<OWLClass> t, OWLClass c) {
        Set instances = (Set)t.getDatum((Object)c, TaxonomyUtils.INSTANCES_KEY);
        if (instances == null) {
            if (t.contains((Object)c)) {
                return Collections.emptySet();
            }
            throw new RuntimeException(c + " is an unknown class!");
        }
        return Collections.unmodifiableSet(instances);
    }
}

