/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlexpr;

import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprBase;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;

public class SqlColumn
extends SqlExprBase {
    SqlTable table;
    String columnName;

    public SqlColumn(SqlTable sqlTable, String colName) {
        this.table = sqlTable;
        this.columnName = colName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public SqlTable getTable() {
        return this.table;
    }

    public String getFullColumnName() {
        if (this.getTable() != null) {
            return this.getTable().getAliasName() + "." + this.columnName;
        }
        return this.columnName;
    }

    public int hashCode() {
        return this.table.hashCode() ^ this.columnName.hashCode() << 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SqlColumn)) {
            return false;
        }
        SqlColumn col = (SqlColumn)other;
        return this.table.equals(col.getTable()) && this.columnName.equals(col.getColumnName());
    }

    @Override
    public boolean isColumn() {
        return true;
    }

    public String asString() {
        return this.getFullColumnName();
    }

    @Override
    public void visit(SqlExprVisitor visitor) {
        visitor.visit(this);
    }
}

