/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.compiler.QueryCompilerFactory;
import com.hp.hpl.jena.sdb.core.sqlnode.GenerateSQL;
import com.hp.hpl.jena.sdb.layout2.StoreBase;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.SQLBridgeFactory;
import com.hp.hpl.jena.sdb.store.StoreFormatter;
import com.hp.hpl.jena.sdb.store.StoreLoader;
import com.hp.hpl.jena.sdb.util.H2Utils;
import com.hp.hpl.jena.sdb.util.StoreUtils;

public abstract class StoreBaseH2
extends StoreBase {
    protected boolean currentlyOpen = true;

    public StoreBaseH2(SDBConnection connection, StoreDesc desc, StoreFormatter formatter, StoreLoader loader, QueryCompilerFactory compilerF, SQLBridgeFactory sqlBridgeF, TableDescTriples tripleTableDesc, TableDescQuads quadTableDesc, TableDescNodes nodeTableDesc) {
        super(connection, desc, formatter, loader, compilerF, sqlBridgeF, new GenerateSQL(), tripleTableDesc, quadTableDesc, nodeTableDesc);
    }

    @Override
    public void close() {
        if (this.currentlyOpen) {
            super.close();
            H2Utils.shutdown(this.getConnection());
        }
        this.currentlyOpen = false;
        super.close();
    }

    public static void close(Store store) {
        if (StoreUtils.isH2(store)) {
            ((StoreBaseH2)store).close();
        }
    }

    public static void checkpoint(Store store) {
        if (StoreUtils.isH2(store)) {
            ((StoreBaseH2)store).checkpoint();
        }
    }

    public void checkpoint() {
        if (this.currentlyOpen) {
            H2Utils.checkpoint(this.getConnection());
        }
    }
}

