/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlConstant;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sdb.sql.RS;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.store.TableDesc;
import com.hp.hpl.jena.sdb.store.TupleLoaderBase;
import com.hp.hpl.jena.sdb.util.StrUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TupleLoaderOne
extends TupleLoaderBase {
    private static Logger log = LoggerFactory.getLogger(TupleLoaderOne.class);

    public TupleLoaderOne(SDBConnection connection) {
        super(connection);
    }

    public TupleLoaderOne(SDBConnection connection, TableDesc tableDesc) {
        super(connection, tableDesc);
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void finish() {
        super.finish();
    }

    @Override
    public void load(Node ... row) {
        if (row.length != this.getTableWidth()) {
            String fmt = "TupleLoaderOne(%s) Expected row length: %d but got %d";
            String msg = String.format(fmt, this.getTableName(), this.getTableWidth(), row.length);
            throw new SDBInternalError(msg);
        }
        String[] vals = this.prepareNodes(row);
        if (!this.entryExists(vals)) {
            this.loadRow(vals);
        }
    }

    protected String[] prepareNodes(Node[] row) {
        String[] vals = new String[this.getTableWidth()];
        for (int i = 0; i < this.getTableWidth(); ++i) {
            vals[i] = this.ensureNode(row[i]).asSqlString();
        }
        return vals;
    }

    protected boolean entryExists(String[] vals) {
        boolean bl;
        ResultSetJDBC rs;
        block5: {
            String rowValues = this.whereRow(vals);
            String selectTemplate = "SELECT count(*) FROM %s WHERE %s\n";
            String sqlStmt = String.format(selectTemplate, this.getTableName(), rowValues);
            rs = null;
            rs = this.connection().execQuery(sqlStmt);
            rs.get().next();
            int count = rs.get().getInt(1);
            if (count <= 0) break block5;
            log.debug("Duplicate tuple detected: count=" + count + " :: " + vals);
            boolean bl2 = true;
            RS.close(rs);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException ex) {
            try {
                throw new SDBExceptionSQL(ex);
            }
            catch (Throwable throwable) {
                RS.close(rs);
                throw throwable;
            }
        }
        RS.close(rs);
        return bl;
    }

    protected void loadRow(String[] vals) {
        String insertTemplate = "INSERT INTO %s VALUES\n  (%s)";
        String sqlStmt = String.format(insertTemplate, this.getTableName(), StrUtils.sqlList(vals));
        this.exec(sqlStmt);
    }

    @Override
    public void unload(Node ... row) {
        String[] vals = new String[this.getTableWidth()];
        for (int i = 0; i < this.getTableWidth(); ++i) {
            vals[i] = this.refNode(row[i]).asSqlString();
        }
        String rowValues = this.whereRow(vals);
        String deleteTemplate = "DELETE FROM %s WHERE %s";
        String sqlStmt = String.format(deleteTemplate, this.getTableName(), rowValues);
        this.exec(sqlStmt);
    }

    protected void exec(String sqlStmt) {
        try {
            this.connection().exec(sqlStmt);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    private SqlConstant ensureNode(Node node) {
        try {
            return this.insertNode(node);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("PatternTableLoader.prepareNode", ex);
        }
    }

    private SqlConstant refNode(Node node) {
        try {
            return this.getRefForNode(node);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("PatternTableLoader.getRefForNode", ex);
        }
    }

    private String whereRow(String[] vals) {
        ArrayList<String> rowValues = new ArrayList<String>(this.getTableWidth());
        for (int i = 0; i < this.getTableWidth(); ++i) {
            String x = this.getTableDesc().getColNames().get(i) + "=" + vals[i];
            rowValues.add(x);
        }
        return org.apache.jena.atlas.lib.StrUtils.strjoin((String)" AND ", rowValues);
    }

    public abstract SqlConstant getRefForNode(Node var1) throws SQLException;

    public abstract SqlConstant insertNode(Node var1) throws SQLException;
}

