/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private Set<AlphaNode> dirtyAlphas;
    private List<Pair<Integer, Collection<AlphaNode>>> dirtyHistory;
    private Set<Fact> inferredFacts;
    private Set<Fact> matchingFacts;
    public Compiler rete;

    public Interpreter(ABox abox) {
        this.rete = new Compiler(this, abox);
        this.dirtyAlphas = new HashSet<AlphaNode>();
        this.dirtyHistory = new ArrayList<Pair<Integer, Collection<AlphaNode>>>();
        this.inferredFacts = new HashSet<Fact>();
        this.matchingFacts = new HashSet<Fact>();
    }

    public boolean addFact(Fact f) {
        return this.addFact(f, true);
    }

    private boolean addFact(Fact f, boolean initial) {
        if (this.knowFact(f)) {
            return false;
        }
        if (!initial) {
            f = new Fact(this.copyDS(f.getDependencySet()), f.getElements());
            this.inferredFacts.add(f);
        }
        boolean matched = false;
        for (AlphaNode a : this.rete.alphaIndex.match(f)) {
            a.add(f);
            matched = true;
            this.dirtyAlphas.add(a);
        }
        if (matched) {
            this.matchingFacts.add(f);
        }
        return matched;
    }

    private DependencySet copyDS(DependencySet ds) {
        ds = ds.copy(this.rete.abox.getBranch());
        return ds;
    }

    public boolean isDirty() {
        return !this.dirtyAlphas.isEmpty();
    }

    private boolean knowFact(Fact f) {
        return this.matchingFacts.contains(f) || this.inferredFacts != null && this.inferredFacts.contains(f);
    }

    private void processBetaNodes(List<BetaNode> dirtyBetas) {
        while (!dirtyBetas.isEmpty()) {
            List<Fact> inferences;
            BetaNode betaNode = dirtyBetas.remove(0);
            if (!betaNode.isDirty() || (inferences = betaNode.join()) == null || inferences.size() <= 0) continue;
            if (betaNode.rule != null) {
                List<TermTuple> termTuples = betaNode.rule.rhs;
                if (termTuples.isEmpty()) {
                    termTuples = Collections.singletonList(new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[0]));
                }
                for (TermTuple triple : termTuples) {
                    Set<Fact> results = betaNode.matchingFacts(triple, inferences);
                    for (Fact result : results) {
                        this.addFact(result, false);
                    }
                }
                continue;
            }
            for (BetaNode child : betaNode.getBetas()) {
                child.markDirty();
                dirtyBetas.add(child);
            }
        }
    }

    public boolean removeMentions(ATermAppl t) {
        boolean changed = false;
        Iterator<Fact> iter = this.matchingFacts.iterator();
        block0: while (iter.hasNext()) {
            Fact fact = iter.next();
            for (ATermAppl element : fact.getElements()) {
                if (!element.equals(t)) continue;
                iter.remove();
                changed = true;
                for (AlphaNode a : this.rete.alphaIndex.match(fact)) {
                    if (!a.remove(fact)) {
                        throw new InternalReasonerException("Could not remove fact");
                    }
                    this.dirtyAlphas.add(a);
                }
                continue block0;
            }
        }
        return changed;
    }

    public void reset() {
        this.rete.alphaIndex.reset();
        this.dirtyAlphas.clear();
        this.dirtyHistory.clear();
        this.inferredFacts.clear();
        this.matchingFacts.clear();
    }

    public boolean restore(int branch) {
        Fact fact;
        boolean changed = false;
        Iterator<Pair<Integer, Collection<AlphaNode>>> setIter = this.dirtyHistory.iterator();
        while (setIter.hasNext()) {
            Pair<Integer, Collection<AlphaNode>> pair = setIter.next();
            if ((Integer)pair.first <= branch) break;
            for (AlphaNode a : (Collection)pair.second) {
                a.markDirty();
                this.dirtyAlphas.add(a);
                changed = true;
            }
            setIter.remove();
        }
        Iterator<Fact> factIter = this.matchingFacts.iterator();
        while (factIter.hasNext()) {
            fact = factIter.next();
            if (fact.getDependencySet().getBranch() <= branch) continue;
            factIter.remove();
            for (AlphaNode a : this.rete.alphaIndex.match(fact)) {
                if (!a.remove(fact)) {
                    throw new InternalReasonerException("Couldn't remove fact: " + fact);
                }
                this.dirtyAlphas.add(a);
                changed = true;
            }
        }
        factIter = this.inferredFacts.iterator();
        while (factIter.hasNext()) {
            fact = factIter.next();
            if (fact.getDependencySet().getBranch() <= branch) continue;
            factIter.remove();
        }
        return changed;
    }

    public Set<Fact> run() {
        ArrayList<AlphaNode> savedDirties = new ArrayList<AlphaNode>(this.dirtyAlphas);
        this.dirtyHistory.add(0, (Pair<Integer, Collection<AlphaNode>>)new Pair((Object)this.rete.abox.getBranch(), savedDirties));
        ArrayList<Fact> oldInferred = new ArrayList<Fact>(this.inferredFacts);
        while (this.isDirty()) {
            ArrayList<BetaNode> dirtyBetas = new ArrayList<BetaNode>();
            for (AlphaNode alphaNode : this.dirtyAlphas) {
                dirtyBetas.addAll(alphaNode.getBetas());
            }
            this.dirtyAlphas.clear();
            this.processBetaNodes(dirtyBetas);
        }
        return SetUtils.difference(this.inferredFacts, oldInferred);
    }
}

