/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LiteralIterator
implements Iterator<ResultBinding> {
    private int[] indices;
    private ResultBinding binding;
    private Set<ATermAppl> litVars;
    private List<List<ATermAppl>> litVarBindings = new ArrayList<List<ATermAppl>>();
    private boolean more = true;

    public LiteralIterator(Query q, ResultBinding binding) {
        KnowledgeBase kb = q.getKB();
        this.binding = binding;
        this.litVars = q.getDistVarsForType(Query.VarType.LITERAL);
        this.indices = new int[this.litVars.size()];
        int index = 0;
        for (ATermAppl litVar : this.litVars) {
            ArrayList foundLiterals = new ArrayList();
            boolean first = true;
            for (QueryAtom atom : q.findAtoms(QueryPredicate.PropertyValue, null, null, litVar)) {
                ATermAppl subject = atom.getArguments().get(0);
                ATermAppl predicate = atom.getArguments().get(1);
                if (ATermUtils.isVar((ATermAppl)subject)) {
                    subject = binding.getValue(subject);
                }
                this.litVarBindings.add(index, new ArrayList());
                List act = kb.getDataPropertyValues(predicate, subject);
                if (first) {
                    foundLiterals.addAll(act);
                    continue;
                }
                foundLiterals.retainAll(act);
                first = false;
            }
            if (foundLiterals.size() > 0) {
                this.litVarBindings.get(index++).addAll(foundLiterals);
                continue;
            }
            this.more = false;
        }
    }

    private boolean incIndex(int index) {
        if (this.indices[index] + 1 >= this.litVarBindings.get(index).size()) {
            if (index == this.indices.length - 1) {
                return false;
            }
            this.indices[index] = 0;
            return this.incIndex(index + 1);
        }
        int n = index;
        this.indices[n] = this.indices[n] + 1;
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal from this iterator is not supported.");
    }

    @Override
    public boolean hasNext() {
        return this.more;
    }

    @Override
    public ResultBinding next() {
        if (!this.more) {
            return null;
        }
        ResultBinding next = this.binding.duplicate();
        int index = 0;
        for (ATermAppl o1 : this.litVars) {
            ATermAppl o2 = this.litVarBindings.get(index).get(this.indices[index++]);
            next.setValue(o1, o2);
        }
        this.more = this.incIndex(0);
        return next;
    }
}

