/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotKnownQueryAtom
implements QueryAtom {
    private List<QueryAtom> atoms;
    private boolean isGround;
    private List<ATermAppl> args;

    public NotKnownQueryAtom(QueryAtom atom) {
        this(Collections.singletonList(atom));
    }

    public NotKnownQueryAtom(List<QueryAtom> atoms) {
        this.atoms = Collections.unmodifiableList(atoms);
        this.isGround = true;
        this.args = new ArrayList<ATermAppl>();
        for (QueryAtom atom : atoms) {
            this.args.addAll(atom.getArguments());
            if (!this.isGround || atom.isGround()) continue;
            this.isGround = false;
        }
    }

    @Override
    public QueryAtom apply(ResultBinding binding) {
        ArrayList<QueryAtom> newAtoms;
        if (this.atoms.size() == 1) {
            newAtoms = Collections.singletonList(this.atoms.get(0).apply(binding));
        } else {
            newAtoms = new ArrayList();
            for (QueryAtom atom : this.atoms) {
                newAtoms.add(atom.apply(binding));
            }
        }
        return new NotKnownQueryAtom(newAtoms);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NotKnownQueryAtom)) {
            return false;
        }
        return this.atoms.equals(((NotKnownQueryAtom)obj).atoms);
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this.args;
    }

    public List<QueryAtom> getAtoms() {
        return this.atoms;
    }

    @Override
    public QueryPredicate getPredicate() {
        return QueryPredicate.NotKnown;
    }

    public int hashCode() {
        return 17 * this.atoms.hashCode();
    }

    @Override
    public boolean isGround() {
        return this.isGround;
    }

    public String toString() {
        return "NotKnown" + this.atoms;
    }
}

