/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class TransformDistinctToReduced
extends TransformCopy {
    public Op transform1(OpDistinct opDistinct, Op subOp) {
        OpProject opProject;
        if (subOp instanceof OpProject && (opProject = (OpProject)subOp).getSubOp() instanceof OpOrder) {
            OpOrder opOrder = (OpOrder)opProject.getSubOp();
            HashSet<Var> projectVars = new HashSet<Var>(opProject.getVars());
            if (this.isSafe(projectVars, opOrder)) {
                return OpReduced.create(subOp);
            }
        }
        return super.transform(opDistinct, subOp);
    }

    @Override
    public Op transform(OpDistinct opDistinct, Op subOp) {
        OpProject opProject;
        OpOrder opOrder = null;
        Set<Var> projectVars = null;
        if (subOp instanceof OpOrder) {
            opOrder = (OpOrder)subOp;
            projectVars = OpVars.visibleVars(subOp);
        } else if (subOp instanceof OpProject && (opProject = (OpProject)subOp).getSubOp() instanceof OpOrder) {
            projectVars = new HashSet<Var>(opProject.getVars());
            opOrder = (OpOrder)opProject.getSubOp();
        }
        if (projectVars == null) {
            return super.transform(opDistinct, subOp);
        }
        if (this.isSafe(projectVars, opOrder)) {
            return OpReduced.create(subOp);
        }
        return super.transform(opDistinct, subOp);
    }

    protected boolean isSafe(Set<Var> projectVars, OpOrder opOrder) {
        HashSet<Var> seenVars = new HashSet<Var>();
        boolean ok = true;
        for (SortCondition cond : opOrder.getConditions()) {
            if (!this.isValidSortCondition(cond, projectVars, seenVars)) {
                ok = false;
                break;
            }
            if (seenVars.size() != projectVars.size()) continue;
            return true;
        }
        return seenVars.size() == projectVars.size();
    }

    private boolean isValidSortCondition(SortCondition cond, Collection<Var> projectVars, Set<Var> seenVars) {
        if (cond.getExpression().isVariable()) {
            if (projectVars.contains((Object)cond.getExpression().asVar())) {
                seenVars.add(cond.getExpression().asVar());
                return true;
            }
            return false;
        }
        for (Var v : cond.getExpression().getVarsMentioned()) {
            if (!projectVars.contains((Object)v)) {
                return false;
            }
            seenVars.add(v);
        }
        return true;
    }
}

