/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io;

import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonNull;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.json.JsonVisitor;
import org.apache.jena.atlas.json.io.JSWriter;

public class JsonWriter
implements JsonVisitor {
    IndentedWriter out;
    private static String ArrayStart = "[ ";
    private static String ArrayFinish = "]";
    private static String ArraySep = ",";
    private static String ObjectStart = "{";
    private static String ObjectFinish = "}";
    private static String ObjectSep = " ,";
    private static String ObjectPairSep = " : ";
    private static String SPC = " ";
    private static int maxCompactObject = 1;
    private static int maxCompactArray = 1;

    public JsonWriter() {
        this(IndentedWriter.stdout);
    }

    @Deprecated
    public JsonWriter(OutputStream ps) {
        this(new IndentedWriter(ps));
    }

    public JsonWriter(IndentedWriter ps) {
        this.out = ps;
    }

    public void startOutput() {
    }

    public void finishOutput() {
        this.out.flush();
    }

    @Override
    public void visit(JsonObject jsonObject) {
        boolean first = true;
        Set<String> x = jsonObject.keySet();
        this.out.print(ObjectStart);
        if (x.size() == 0) {
            this.out.print(SPC);
            this.out.print(ObjectFinish);
            return;
        }
        this.out.incIndent();
        if (JsonWriter.isJsonObjectCompact(jsonObject)) {
            this.writeObjectCompact(jsonObject, x);
        } else {
            this.writeObjectLong(jsonObject, x);
        }
        this.out.decIndent();
        this.out.print(ObjectFinish);
    }

    private static boolean isJsonObjectCompact(JsonObject jsonObject) {
        Set<String> x = jsonObject.keySet();
        if (x.size() == 0) {
            return true;
        }
        if (x.size() > maxCompactObject) {
            return false;
        }
        for (String k : x) {
            if (JsonWriter.isCompactValue(jsonObject.get(k))) continue;
            return false;
        }
        return true;
    }

    private void writeObjectCompact(JsonObject jsonObject, Set<String> x) {
        TreeSet<String> y = new TreeSet<String>(x);
        boolean first = true;
        for (String k : y) {
            if (!first) {
                this.out.print(ObjectSep);
            }
            first = false;
            JSWriter.outputQuotedString(this.out, k);
            this.out.print(ObjectPairSep);
            this.out.incIndent();
            jsonObject.get(k).visit(this);
            this.out.decIndent();
        }
        this.out.print(SPC);
    }

    private void writeObjectLong(JsonObject jsonObject, Set<String> x) {
        TreeSet<String> y = new TreeSet<String>(x);
        boolean first = true;
        for (String k : y) {
            if (!first) {
                this.out.print(ObjectSep);
                this.out.println();
            }
            first = false;
            JSWriter.outputQuotedString(this.out, k);
            this.out.print(ObjectPairSep);
            this.out.incIndent();
            jsonObject.get(k).visit(this);
            this.out.decIndent();
        }
        this.out.println();
    }

    private static boolean isCompactValue(JsonValue v) {
        if (v.isPrimitive()) {
            return true;
        }
        if (v.isArray()) {
            JsonArray a = v.getAsArray();
            if (a.size() == 0) {
                return true;
            }
            if (a.size() > 1) {
                return false;
            }
            return a.get(0).isPrimitive();
        }
        if (v.isObject()) {
            JsonObject obj = v.getAsObject();
            Set<String> x = obj.keySet();
            if (x.size() == 0) {
                return true;
            }
            if (x.size() > 1) {
                return false;
            }
            String k = obj.keys().iterator().next();
            return obj.get(k).isPrimitive();
        }
        return false;
    }

    @Override
    public void visit(JsonArray jsonArray) {
        if (jsonArray.size() == 0) {
            this.out.print(ArrayStart);
            this.out.incIndent();
            this.out.print(ArrayFinish);
            this.out.decIndent();
            return;
        }
        if (this.isJsonArrayCompact(jsonArray)) {
            this.writeArrayCompact(jsonArray);
        } else {
            this.writeArrayLong(jsonArray);
        }
    }

    private boolean isJsonArrayCompact(JsonArray jsonArray) {
        if (jsonArray.size() > maxCompactArray) {
            return false;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (jsonArray.get(i).isPrimitive()) continue;
            return false;
        }
        return true;
    }

    private void writeArrayCompact(JsonArray jsonArray) {
        this.out.print(ArrayStart);
        this.out.incIndent();
        boolean first = true;
        for (JsonValue elt : jsonArray) {
            if (!first) {
                this.out.print(ArraySep);
                this.out.print(SPC);
            }
            first = false;
            elt.visit(this);
        }
        this.out.print(SPC);
        this.out.decIndent();
        this.out.print(ArrayFinish);
    }

    private void writeArrayLong(JsonArray jsonArray) {
        this.out.print(ArrayStart);
        this.out.incIndent();
        this.out.ensureStartOfLine();
        boolean first = true;
        for (JsonValue elt : jsonArray) {
            if (!first) {
                this.out.print(SPC);
                this.out.print(ArraySep);
                this.out.println();
            }
            first = false;
            elt.visit(this);
        }
        this.out.decIndent();
        this.out.ensureStartOfLine();
        this.out.print(ArrayFinish);
    }

    @Override
    public void visit(JsonString jsonString) {
        JSWriter.outputQuotedString(this.out, jsonString.value());
    }

    @Override
    public void visit(JsonNumber jsonNumber) {
        this.out.print(jsonNumber.value().toString());
    }

    @Override
    public void visit(JsonBoolean jsonBoolean) {
        String x = jsonBoolean.value() ? "true" : "false";
        this.out.print(x);
    }

    @Override
    public void visit(JsonNull jsonNull) {
        this.out.print("null");
    }
}

