/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.test.AbstractExplanationTest;
import com.clarkparsia.explanation.test.JenaExplanationTest;
import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.GlassBoxExplanation;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.owlapi.explanation.io.ConciseExplanationRenderer;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class OWLAPIExplanationTest
extends AbstractExplanationTest {
    private static final Logger log = Logger.getLogger(JenaExplanationTest.class.getName());
    private PelletReasoner reasoner;
    private boolean useGlassBox;
    private SatisfiabilityConverter converter;
    private ConciseExplanationRenderer renderer;
    private HSTExplanationGenerator expGen;
    private int axiomCount = 0;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{true, false});
        parameters.add(new Object[]{true, true});
        parameters.add(new Object[]{false, false});
        parameters.add(new Object[]{false, true});
        return parameters;
    }

    public OWLAPIExplanationTest(boolean useGlassBox, boolean classify) {
        super(classify);
        this.useGlassBox = useGlassBox;
    }

    @BeforeClass
    public static void beforeClass() {
        GlassBoxExplanation.setup();
    }

    @Override
    @After
    public void after() {
        super.after();
        if (this.expGen != null) {
            if (this.useGlassBox) {
                GlassBoxExplanation gbe = (GlassBoxExplanation)this.expGen.getSingleExplanationGenerator();
                gbe.dispose();
                this.reasoner.dispose();
            } else {
                BlackBoxExplanation bbe = (BlackBoxExplanation)this.expGen.getSingleExplanationGenerator();
                bbe.dispose();
                this.reasoner.getManager().removeOntologyChangeListener((OWLOntologyChangeListener)bbe.getDefinitionTracker());
            }
        }
    }

    @Override
    public void setupGenerators(Collection<OWLAxiom> ontologyAxioms) throws Exception {
        Assert.assertTrue((!this.useGlassBox || PelletOptions.USE_TRACING ? 1 : 0) != 0);
        this.converter = new SatisfiabilityConverter(OWL.factory);
        this.renderer = new ConciseExplanationRenderer();
        OWLOntology ontology = OWL.Ontology(ontologyAxioms);
        PelletReasonerFactory reasonerFactory = PelletReasonerFactory.getInstance();
        this.reasoner = reasonerFactory.createReasoner(ontology);
        Object singleExpGen = this.useGlassBox ? new GlassBoxExplanation(this.reasoner) : new BlackBoxExplanation(ontology, (OWLReasonerFactory)reasonerFactory, (OWLReasoner)this.reasoner){

            protected boolean isFirstExplanation() {
                return false;
            }
        };
        this.expGen = new HSTExplanationGenerator((TransactionAwareSingleExpGen)singleExpGen);
        KnowledgeBase kb = this.reasoner.getKB();
        if (this.classify) {
            kb.setDoExplanation(true);
            kb.ensureConsistency();
            kb.setDoExplanation(false);
            kb.realize();
        }
    }

    @Override
    public void testInconsistencyExplanations(int max, OWLAxiom[] ... explanations) throws Exception {
        Assume.assumeTrue((boolean)this.useGlassBox);
        super.testInconsistencyExplanations(max, explanations);
    }

    @Override
    public void testExplanations(OWLAxiom axiom, int max, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        OWLClassExpression unsatClass = this.converter.convert(axiom);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Axiom " + ++this.axiomCount + ": " + axiom + " Expecting " + expectedExplanations.size() + " explanations");
        }
        Set generatedExplanations = this.expGen.getExplanations(unsatClass, max);
        HashSet<Set<OWLAxiom>> notFoundExplanations = new HashSet<Set<OWLAxiom>>(expectedExplanations);
        if (log.isLoggable(Level.FINER)) {
            StringWriter sw = new StringWriter();
            this.renderer.startRendering((Writer)sw);
            this.renderer.render(axiom, expectedExplanations);
            this.renderer.endRendering();
            log.finer("Expected:\n" + sw);
        }
        Assert.assertNotNull((String)("Axiom " + axiom + " not entailed"), (Object)generatedExplanations);
        HashSet<Set> unexpectedExplanations = new HashSet<Set>();
        for (Set explanation : generatedExplanations) {
            if (notFoundExplanations.remove(explanation)) continue;
            unexpectedExplanations.add(explanation);
        }
        if (!notFoundExplanations.isEmpty() || !unexpectedExplanations.isEmpty()) {
            StringWriter sw = new StringWriter();
            ConciseExplanationRenderer renderer = new ConciseExplanationRenderer();
            renderer.startRendering((Writer)sw);
            sw.getBuffer().append("\nExpected:\n");
            renderer.render(axiom, expectedExplanations);
            if (!notFoundExplanations.isEmpty()) {
                sw.getBuffer().append("Not Found:\n");
                renderer.render(axiom, notFoundExplanations);
            }
            if (!unexpectedExplanations.isEmpty()) {
                sw.getBuffer().append("Unexpected:\n");
                renderer.render(axiom, unexpectedExplanations);
            }
            renderer.endRendering();
            System.out.println("Error in explanation: " + sw);
            Assert.fail((String)"Error in explanation, see the log file for details");
        }
    }
}

