/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.PelletIncremantalReasonerFactory;
import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class ModularityUpdateTest
extends AbstractModularityTest {
    @Test
    public void addNonLocal() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.D)};
        this.createOntology(axioms);
        IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(this.ontology);
        modular.classify();
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        Assert.assertFalse((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.D)));
        OntologyUtils.addAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.equivalentClasses((OWLClassExpression)this.D, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D)), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)));
        modular.classify();
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.D)));
        OntologyUtils.removeAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        modular.classify();
        Assert.assertFalse((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.D)));
        modular.dispose();
    }

    @Test
    public void deleteNonLocal() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.D), OWL.equivalentClasses((OWLClassExpression)this.D, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D))};
        this.createOntology(axioms);
        IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(this.ontology);
        modular.classify();
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        Assert.assertFalse((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.D)));
        OntologyUtils.removeAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.equivalentClasses((OWLClassExpression)this.D, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D))));
        OntologyUtils.addAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)));
        modular.classify();
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.D)));
        OntologyUtils.removeAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        modular.classify();
        Assert.assertFalse((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.D)));
        modular.dispose();
    }

    @Test
    public void testDeferredClassification() {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.D)};
        this.createOntology(axioms);
        IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(this.ontology);
        modular.classify();
        Assert.assertTrue((boolean)modular.isClassified());
        Assert.assertEquals(Collections.emptySet(), (Object)modular.getTypes(this.a, false).getFlattened());
        Assert.assertTrue((boolean)modular.isRealized());
        OntologyUtils.addAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A)));
        Assert.assertTrue((boolean)modular.isClassified());
        Assert.assertFalse((boolean)modular.isRealized());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{this.A, this.B, OWL.Thing}), (Object)modular.getTypes(this.a, false).getFlattened());
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        Assert.assertFalse((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C)));
        Assert.assertTrue((boolean)modular.isRealized());
        OntologyUtils.addAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C)));
        Assert.assertFalse((boolean)modular.isClassified());
        Assert.assertFalse((boolean)modular.isRealized());
        modular.classify();
        Assert.assertTrue((boolean)modular.isClassified());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{this.A, this.B, this.C, this.D, OWL.Thing}), (Object)modular.getTypes(this.a, false).getFlattened());
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)));
        Assert.assertTrue((boolean)modular.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C)));
    }
}

