/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.AxiomBasedModuleExtractor;
import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.PelletIncremantalReasonerFactory;
import com.clarkparsia.modularity.io.IncrementalClassifierPersistence;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.test.PelletTestSuite;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class PersistenceUpdatesTest {
    public static final String base = PelletTestSuite.base + "modularity/";
    private static final String TEST_FILE = "test-persistence-classification.zip";

    public ModuleExtractor createModuleExtractor() {
        return new AxiomBasedModuleExtractor();
    }

    public void performPersistenceRemoves(String fileName) throws IOException {
        String common = "file:" + base + fileName;
        this.testPersistenceRemoves(common + ".owl");
    }

    public void performPersistenceAdds(String fileName) throws IOException {
        String common = "file:" + base + fileName;
        this.testPersistenceAdds(common + ".owl");
    }

    public void performPersistenceAllowedUpdates(String fileName) throws IOException {
        String common = "file:" + base + fileName;
        this.testAllowedUpdates(common + ".owl");
    }

    public void performUpdatesAfterPersistence(String fileName) throws IOException {
        String common = "file:" + base + fileName;
        this.testUpdatesAfterPersistence(common + ".owl");
    }

    public void performUpdatesAfterPersistence2(String fileName) throws IOException {
        String common = "file:" + base + fileName;
        this.testUpdatesAfterPersistence2(common + ".owl");
    }

    public void performUpdatesWhenPersisted(String fileName) throws IOException {
        String common = "file:" + base + fileName;
        this.testUpdatesWhenPersisted(common + ".owl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistenceRemoves(String inputOnt) throws IOException {
        File testFile = new File(TEST_FILE);
        OWLOntology ontology = OntologyUtils.loadOntology((String)inputOnt);
        try {
            ModuleExtractor moduleExtractor = this.createModuleExtractor();
            IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, moduleExtractor);
            modular.classify();
            ArrayList<OWLAxiom> axiomsToRemove = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 1));
            for (OWLAxiom axiomToRemove : axiomsToRemove) {
                OWL.manager.applyChange((OWLOntologyChange)new RemoveAxiom(ontology, axiomToRemove));
            }
            try {
                FileOutputStream fos = new FileOutputStream(testFile);
                IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
                Assert.fail((String)"The incremental classifer must not allow itself to be persisted if there are any unapplied changes to the ontology");
                fos.close();
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)testFile.delete());
            }
        }
        finally {
            if (ontology != null) {
                OWL.manager.removeOntology(ontology);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistenceAdds(String inputOnt) throws IOException {
        File testFile = new File(TEST_FILE);
        OWLOntology ontology = OntologyUtils.loadOntology((String)inputOnt);
        try {
            ModuleExtractor moduleExtractor = this.createModuleExtractor();
            IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, moduleExtractor);
            ArrayList<OWLAxiom> axiomsToRemove = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 1));
            for (OWLAxiom axiomToRemove : axiomsToRemove) {
                OWL.manager.applyChange((OWLOntologyChange)new RemoveAxiom(ontology, axiomToRemove));
            }
            modular.classify();
            for (OWLAxiom axiomToAdd : axiomsToRemove) {
                OWL.manager.applyChange((OWLOntologyChange)new AddAxiom(ontology, axiomToAdd));
            }
            try {
                FileOutputStream fos = new FileOutputStream(testFile);
                IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
                Assert.fail((String)"The incremental classifer must not allow itself to be persisted if there are any unapplied changes to the ontology");
                fos.close();
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)testFile.delete());
            }
            modular.dispose();
        }
        finally {
            if (ontology != null) {
                OWL.manager.removeOntology(ontology);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowedUpdates(String inputOnt) throws IOException {
        File testFile = new File(TEST_FILE);
        OWLOntology ontology = OntologyUtils.loadOntology((String)inputOnt);
        try {
            ModuleExtractor moduleExtractor = this.createModuleExtractor();
            IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, moduleExtractor);
            modular.classify();
            ArrayList<OWLAxiom> axiomsToRemove = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 1));
            for (OWLAxiom axiomToRemove : axiomsToRemove) {
                OWL.manager.applyChange((OWLOntologyChange)new RemoveAxiom(ontology, axiomToRemove));
            }
            for (OWLAxiom axiomToAdd : axiomsToRemove) {
                OWL.manager.applyChange((OWLOntologyChange)new AddAxiom(ontology, axiomToAdd));
            }
            ArrayList<OWLAxiom> axiomsToRemove2 = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 1));
            for (OWLAxiom axiomToRemove : axiomsToRemove2) {
                OWL.manager.applyChange((OWLOntologyChange)new RemoveAxiom(ontology, axiomToRemove));
            }
            modular.classify();
            FileOutputStream fos = new FileOutputStream(testFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
            fos.close();
            Assert.assertTrue((boolean)testFile.delete());
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdatesAfterPersistence(String inputOnt) throws IOException {
        File testFile = new File(TEST_FILE);
        OWLOntology ontology = OntologyUtils.loadOntology((String)inputOnt);
        try {
            ModuleExtractor moduleExtractor = this.createModuleExtractor();
            IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, moduleExtractor);
            modular.classify();
            FileOutputStream fos = new FileOutputStream(testFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
            fos.close();
            FileInputStream fis = new FileInputStream(testFile);
            modular = IncrementalClassifierPersistence.load((InputStream)fis);
            fis.close();
            ArrayList<OWLAxiom> axiomsToRemove = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 1));
            for (OWLAxiom axiomToRemove : axiomsToRemove) {
                OWL.manager.applyChange((OWLOntologyChange)new RemoveAxiom(modular.getRootOntology(), axiomToRemove));
            }
            modular.classify();
            PelletReasoner expected = PelletReasonerFactory.getInstance().createReasoner(modular.getRootOntology());
            TestUtils.assertClassificationEquals((OWLReasoner)expected, (OWLReasoner)modular);
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdatesAfterPersistence2(String inputOnt) throws IOException {
        File testFile = new File(TEST_FILE);
        OWLOntology ontology = OntologyUtils.loadOntology((String)inputOnt);
        try {
            IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, this.createModuleExtractor());
            modular.classify();
            FileOutputStream fos = new FileOutputStream(testFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
            fos.close();
            FileInputStream fis = new FileInputStream(testFile);
            modular = IncrementalClassifierPersistence.load((InputStream)fis, (OWLOntology)ontology);
            fis.close();
            ArrayList<OWLAxiom> axiomsToRemove = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 1));
            for (OWLAxiom axiomToRemove : axiomsToRemove) {
                OWL.manager.applyChange((OWLOntologyChange)new RemoveAxiom(ontology, axiomToRemove));
            }
            modular.classify();
            PelletReasoner expected = PelletReasonerFactory.getInstance().createReasoner(ontology);
            TestUtils.assertClassificationEquals((OWLReasoner)expected, (OWLReasoner)modular);
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdatesWhenPersisted(String inputOnt) throws IOException {
        File testFile = new File(TEST_FILE);
        OWLOntology ontology = OntologyUtils.loadOntology((String)inputOnt);
        try {
            IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, this.createModuleExtractor());
            modular.classify();
            FileOutputStream fos = new FileOutputStream(testFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
            fos.close();
            ArrayList<OWLAxiom> axiomsToRemove = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 1));
            for (OWLAxiom axiomToRemove : axiomsToRemove) {
                OWL.manager.applyChange((OWLOntologyChange)new RemoveAxiom(ontology, axiomToRemove));
            }
            FileInputStream fis = new FileInputStream(testFile);
            modular = IncrementalClassifierPersistence.load((InputStream)fis, (OWLOntology)ontology);
            fis.close();
            PelletReasoner expected = PelletReasonerFactory.getInstance().createReasoner(ontology);
            TestUtils.assertClassificationEquals((OWLReasoner)expected, (OWLReasoner)modular);
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    @Test
    public void miniTambisPersistenceAddsTest() throws IOException {
        this.performPersistenceAdds("miniTambis");
    }

    @Test
    public void miniTambisPersistenceRemovesTest() throws IOException {
        this.performPersistenceRemoves("miniTambis");
    }

    @Test
    public void miniTambisPersistenceAllowedUpdatesTest() throws IOException {
        this.performPersistenceAllowedUpdates("miniTambis");
    }

    @Test
    public void miniTambisUpdatesAfterPersistenceTest() throws IOException {
        this.performUpdatesAfterPersistence("miniTambis");
    }

    @Test
    public void miniTambisUpdatesAfterPersistence2Test() throws IOException {
        this.performUpdatesAfterPersistence2("miniTambis");
    }

    @Test
    public void miniTambisUpdatesWhenPersistedTest() throws IOException {
        this.performUpdatesWhenPersisted("miniTambis");
    }
}

