/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class RandomizedIncrementalClassifierTest
extends AbstractModularityTest {
    private String path;

    public RandomizedIncrementalClassifierTest(String path) {
        this.path = path;
        if (!new File(path).exists()) {
            throw new RuntimeException("Path to data files is not correct: " + path);
        }
    }

    private void classifyCorrectnessTest(String file) throws OWLException {
        OWLOntology ontology = OntologyUtils.loadOntology((String)("file:" + file), (boolean)false);
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 10));
        OntologyUtils.removeAxioms((OWLOntology)ontology, axioms.subList(0, 5));
        List<OWLAxiom> additions = axioms.subList(0, 5);
        List<OWLAxiom> deletions = axioms.subList(5, 10);
        try {
            TestUtils.runUpdateTest(ontology, this.modExtractor, additions, deletions);
        }
        catch (AssertionError e) {
            System.err.println("Additions: " + additions);
            System.err.println("Deletions: " + deletions);
            throw e;
        }
        catch (RuntimeException e) {
            System.err.println("Additions: " + additions);
            System.err.println("Deletions: " + deletions);
            throw e;
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    @Test
    public void galenRandomizedIncrementalClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "galen.owl");
    }

    @Test
    public void koalaRandomizedIncrementalClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "koala.owl");
    }

    @Test
    public void sumoRandomizedIncrementalClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "SUMO.owl");
    }

    @Test
    public void sweetRandomizedIncrementalClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "SWEET.owl");
    }
}

