/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.ModularityUtils;
import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.Test;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RandomizedModularityTest
extends AbstractModularityTest {
    private String path;

    public RandomizedModularityTest(String path) {
        this.path = path;
        if (!new File(path).exists()) {
            throw new RuntimeException("Path to data files is not correct: " + path);
        }
    }

    private void modularityTest(String file) throws OWLException {
        OWLOntology ontology = OntologyUtils.loadOntology((String)("file:" + file), (boolean)false);
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>();
        signature.addAll(TestUtils.selectRandomElements(ontology.getClassesInSignature(), 5));
        this.modularityTest(ontology, signature);
        OWL.manager.removeOntology(ontology);
    }

    private void modularityTest(OWLOntology ontology, Set<OWLEntity> signature) throws OWLException {
        this.modularityTest(ontology, signature, ModuleType.BOT);
        this.modularityTest(ontology, signature, ModuleType.TOP);
    }

    private void modularityTest(OWLOntology ontology, Set<OWLEntity> signature, ModuleType moduleType) throws OWLException {
        Set computed = ModularityUtils.extractModule((OWLOntology)ontology, signature, (ModuleType)moduleType);
        SyntacticLocalityModuleExtractor segmenter = new SyntacticLocalityModuleExtractor(OWL.manager, ontology, moduleType);
        Set expected = segmenter.extract(signature);
        for (OWLEntity entity : signature) {
            OWLDeclarationAxiom declaration = OWL.declaration((OWLEntity)entity);
            computed.remove(declaration);
            computed.remove(declaration);
        }
        Iterator i = expected.iterator();
        while (i.hasNext()) {
            OWLAxiom axiom = (OWLAxiom)i.next();
            if (axiom.getAxiomType() != AxiomType.SAME_INDIVIDUAL && axiom.getAxiomType() != AxiomType.DIFFERENT_INDIVIDUALS) continue;
            i.remove();
        }
        TestUtils.assertToStringEquals("Modules diff for " + signature, expected.toArray(new OWLAxiom[0]), computed.toArray(new OWLAxiom[0]));
    }

    @Test
    public void galenModularityTest() throws OWLException {
        this.modularityTest(this.path + "galen.owl");
    }

    @Test
    public void koalaModularityTest() throws OWLException {
        this.modularityTest(this.path + "koala.owl");
    }

    @Test
    public void sumoModularityTest() throws OWLException {
        this.modularityTest(this.path + "SUMO.owl");
    }

    @Test
    public void sweetModularityTest() throws OWLException {
        this.modularityTest(this.path + "SWEET.owl");
    }

    @Test
    public void wineModularityTest() throws OWLException {
        this.modularityTest(this.path + "wine.owl");
    }
}

