/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import com.clarkparsia.owlapiv3.OWL;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class SyntacticTopLocalityTests {
    private SyntacticLocalityEvaluator evaluator = new SyntacticLocalityEvaluator(LocalityClass.TOP_BOTTOM);

    private void assertLocal(OWLAxiom a, OWLEntity ... signature) {
        Assert.assertTrue((boolean)this.evaluator.isLocal(a, TestUtils.set(signature)));
    }

    private void assertNonLocal(OWLAxiom a, OWLEntity ... signature) {
        Assert.assertFalse((boolean)this.evaluator.isLocal(a, TestUtils.set(signature)));
    }

    @Test
    public void objectComplementSubCls() {
        this.assertLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.not((OWLClassExpression)OWL.Thing), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.not((OWLClassExpression)OWL.Class((String)"B")), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.not((OWLClassExpression)OWL.Class((String)"B")), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.Class((String)"B")});
    }

    @Test
    public void objectExistentialFillerSuperCls() {
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.Class((String)"A"), (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLClassExpression)OWL.Class((String)"B"))), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.Class((String)"A"), (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLClassExpression)OWL.Class((String)"B"))), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
    }

    @Test
    public void objectMaxSubCls() {
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLClassExpression)OWL.Thing), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLClassExpression)OWL.Thing), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLClassExpression)OWL.Nothing), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLClassExpression)OWL.Nothing), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLClassExpression)OWL.Class((String)"B")), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLClassExpression)OWL.Class((String)"B")), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLClassExpression)OWL.Class((String)"B")), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p"), OWL.Class((String)"B")});
    }

    @Test
    public void objectSuperCls() {
        this.assertLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.Class((String)"A"), (OWLClassExpression)OWL.Class((String)"B")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.Class((String)"A"), (OWLClassExpression)OWL.Class((String)"B")), new OWLEntity[]{OWL.Class((String)"B")});
    }

    @Test
    public void objectUniversalSubCls() {
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.all((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLClassExpression)OWL.Class((String)"B")), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.all((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLClassExpression)OWL.Class((String)"B")), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.Class((String)"B")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.all((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLClassExpression)OWL.Class((String)"B")), (OWLClassExpression)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
    }
}

