/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Assume;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.test.AbstractKBTests;

public class DatatypeRestrictionTests
extends AbstractKBTests {
    public static Test suite() {
        return new JUnit4TestAdapter(DatatypeRestrictionTests.class);
    }

    @org.junit.Test
    public void simpleRestriction() {
        this.classes(C);
        this.dataProperties(p);
        this.individuals(a, b);
        this.kb.addDatatypeDefinition(D, TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)1))}));
        this.kb.addEquivalentClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)2));
        this.kb.addPropertyValue(p, b, TermFactory.literal((int)3));
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(b, C));
    }

    @org.junit.Test
    public void nestedRestriction() {
        this.classes(C);
        this.dataProperties(p);
        this.individuals(a, b);
        this.kb.addDatatypeDefinition(E, TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.maxInclusive((ATermAppl)TermFactory.literal((int)2))}));
        this.kb.addDatatypeDefinition(D, TermFactory.restrict((ATermAppl)E, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)1))}));
        this.kb.addEquivalentClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)2));
        this.kb.addPropertyValue(p, b, TermFactory.literal((int)3));
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(b, C));
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void invalidRestriction() {
        this.classes(C);
        this.dataProperties(p);
        this.individuals(a, b);
        this.kb.addDatatypeDefinition(E, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((int)1), TermFactory.literal((int)2), TermFactory.literal((int)3)}));
        this.kb.addDatatypeDefinition(D, TermFactory.restrict((ATermAppl)E, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)1))}));
        this.kb.addEquivalentClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)2));
        this.kb.addPropertyValue(p, b, TermFactory.literal((int)3));
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(b, C));
    }

    @org.junit.Test
    public void invalidLiteralBuiltInDatatype() {
        this.dataProperties(p);
        this.individuals(a);
        this.kb.addRange((ATerm)p, Datatypes.INTEGER);
        this.kb.addPropertyValue(p, a, TermFactory.literal((String)"-1", (ATermAppl)Datatypes.POSITIVE_INTEGER));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void invalidLiteralRestrictedDatatype() {
        this.dataProperties(p);
        this.individuals(a);
        ATermAppl uri = TermFactory.term((String)"http//example.com/datatype");
        this.kb.addRange((ATerm)p, Datatypes.INTEGER);
        this.kb.addDatatypeDefinition(uri, TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)0))}));
        this.kb.addPropertyValue(p, a, TermFactory.literal((String)"-1", (ATermAppl)uri));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void validLiteralRestrictedDatatype() {
        this.dataProperties(p);
        this.individuals(a);
        ATermAppl uri = TermFactory.term((String)"http//example.com/datatype");
        this.kb.addRange((ATerm)p, Datatypes.INTEGER);
        this.kb.addDatatypeDefinition(uri, TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)0))}));
        this.kb.addPropertyValue(p, a, TermFactory.literal((String)"1", (ATermAppl)uri));
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void validLiteralStringRestriction1() {
        this.dataProperties(p);
        this.individuals(a);
        ATermAppl uri = TermFactory.term((String)"http//example.com/datatype");
        this.kb.addDatatypeDefinition(uri, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((String)"a"), TermFactory.literal((String)"b")}));
        this.kb.addRange((ATerm)p, uri);
        this.kb.addPropertyValue(p, a, TermFactory.literal((String)"a"));
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void invalidLiteralStringRestriction() {
        Assume.assumeTrue((boolean)PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY);
        this.dataProperties(p);
        this.individuals(a);
        ATermAppl uri = TermFactory.term((String)"http//example.com/datatype");
        this.kb.addDatatypeDefinition(uri, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((String)"a"), TermFactory.literal((String)"b")}));
        this.kb.addRange((ATerm)p, uri);
        this.kb.addPropertyValue(p, a, TermFactory.literal((String)"a", (ATermAppl)uri));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void validLiteralStringRestriction2() {
        this.dataProperties(p);
        this.individuals(a, b, c);
        ATermAppl uri = TermFactory.term((String)"http//example.com/datatype");
        this.kb.addDatatypeDefinition(uri, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((String)"a"), TermFactory.literal((String)"b")}));
        this.kb.addRange((ATerm)p, uri);
        this.kb.addPropertyValue(p, a, TermFactory.literal((String)"c"));
        this.kb.addAllDifferent(TermFactory.list((ATermAppl[])new ATermAppl[]{a, b, c}));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }
}

