/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import com.clarkparsia.pellet.datatypes.DiscreteInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;

public class IntegerIntervalTests {
    public static IntegerInterval interval(Integer l, Integer u) {
        return new IntegerInterval((Number)l, (Number)u);
    }

    @Test
    public void greater1() {
        IntegerInterval i = IntegerIntervalTests.interval(1, 5);
        Assert.assertEquals((Object)IntegerIntervalTests.interval(3, 5), (Object)i.greater((Number)2));
    }

    @Test
    public void greater2() {
        IntegerInterval i = IntegerIntervalTests.interval(1, 5);
        Assert.assertEquals((Object)IntegerIntervalTests.interval(2, 5), (Object)i.greater((Number)1));
    }

    @Test
    public void inclusiveEndpoints() {
        IntegerInterval interval = IntegerIntervalTests.interval(-1, 3);
        Assert.assertTrue((boolean)interval.contains((Number)-1));
        Assert.assertTrue((boolean)interval.contains((Number)3));
        Assert.assertTrue((boolean)interval.contains((Number)0));
    }

    @Test
    public void intersectionEmpty() {
        IntegerInterval a = IntegerIntervalTests.interval(null, 0);
        IntegerInterval b = IntegerIntervalTests.interval(1, null);
        Assert.assertNull((Object)a.intersection((DiscreteInterval)b));
        Assert.assertNull((Object)b.intersection((DiscreteInterval)a));
    }

    @Test
    public void intersectionPoint() {
        IntegerInterval a = IntegerIntervalTests.interval(null, 2);
        IntegerInterval b = IntegerIntervalTests.interval(2, null);
        IntegerInterval expected = new IntegerInterval((Number)2);
        Assert.assertEquals((Object)expected, (Object)a.intersection((DiscreteInterval)b));
        Assert.assertEquals((Object)expected, (Object)b.intersection((DiscreteInterval)a));
        Assert.assertTrue((boolean)((IntegerInterval)a.intersection((DiscreteInterval)b)).contains((Number)2));
        Assert.assertTrue((boolean)((IntegerInterval)b.intersection((DiscreteInterval)a)).contains((Number)2));
    }

    @Test
    public void less1() {
        IntegerInterval i = IntegerIntervalTests.interval(1, 5);
        Assert.assertEquals((Object)IntegerIntervalTests.interval(1, 3), (Object)i.less((Number)4));
    }

    @Test
    public void less2() {
        IntegerInterval i = IntegerIntervalTests.interval(1, 5);
        Assert.assertEquals((Object)IntegerIntervalTests.interval(1, 4), (Object)i.less((Number)5));
    }

    @Test
    public void unboundContainsAll() {
        IntegerInterval interval = new IntegerInterval(null, null);
        Assert.assertTrue((boolean)interval.contains((Number)-1));
        Assert.assertTrue((boolean)interval.contains((Number)0));
        Assert.assertTrue((boolean)interval.contains((Number)1));
        Assert.assertTrue((boolean)interval.contains((Number)Long.MAX_VALUE));
        Assert.assertTrue((boolean)interval.contains((Number)BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.TEN)));
    }
}

