/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import com.clarkparsia.pellet.datatypes.IntervalRelations;
import com.clarkparsia.pellet.datatypes.OWLRealInterval;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class OWLRealIntervalTests {
    public static OWLRealInterval interval(Double l, Double u, boolean il, boolean iu, OWLRealInterval.LineType t) {
        return new OWLRealInterval((Number)(l == null ? null : BigDecimal.valueOf(l)), (Number)(u == null ? null : BigDecimal.valueOf(u)), il, iu, t);
    }

    public static OWLRealInterval interval(Integer l, Integer u, boolean il, boolean iu, OWLRealInterval.LineType t) {
        return new OWLRealInterval((Number)l, (Number)u, il, iu, t);
    }

    @Test
    public void exclusiveEndpointsCon() {
        OWLRealInterval interval = OWLRealIntervalTests.interval(-1.3, 2.5, false, false, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertFalse((boolean)interval.contains((Number)BigDecimal.valueOf(-1.3)));
        Assert.assertFalse((boolean)interval.contains((Number)BigDecimal.valueOf(2.5)));
        Assert.assertTrue((boolean)interval.contains((Number)0));
    }

    @Test
    public void exclusiveEndpointsNoI1() {
        OWLRealInterval interval = OWLRealIntervalTests.interval(-1.3, 2.5, false, false, OWLRealInterval.LineType.INTEGER_EXCLUDED);
        Assert.assertFalse((boolean)interval.contains((Number)BigDecimal.valueOf(-1.3)));
        Assert.assertFalse((boolean)interval.contains((Number)BigDecimal.valueOf(2.5)));
        Assert.assertFalse((boolean)interval.contains((Number)0));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(0.1)));
    }

    @Test
    public void exclusiveEndpointsNoI2() {
        OWLRealInterval interval = OWLRealIntervalTests.interval(-1, 3, false, false, OWLRealInterval.LineType.INTEGER_EXCLUDED);
        Assert.assertFalse((boolean)interval.contains((Number)-1));
        Assert.assertFalse((boolean)interval.contains((Number)3));
        Assert.assertFalse((boolean)interval.contains((Number)0));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(0.1)));
    }

    @Test
    public void exclusiveEndpointsOnly() {
        OWLRealInterval interval = OWLRealIntervalTests.interval(-1, 3, false, false, OWLRealInterval.LineType.INTEGER_ONLY);
        Assert.assertFalse((boolean)interval.contains((Number)-1));
        Assert.assertFalse((boolean)interval.contains((Number)3));
        Assert.assertTrue((boolean)interval.contains((Number)0));
    }

    @Test
    public void greaterInt1() {
        OWLRealInterval i = OWLRealIntervalTests.interval(1, 5, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        Assert.assertEquals((Object)OWLRealIntervalTests.interval(3, 5, true, true, OWLRealInterval.LineType.INTEGER_ONLY), (Object)i.greater((Number)2));
    }

    @Test
    public void greaterInt2() {
        OWLRealInterval i = OWLRealIntervalTests.interval(1, 5, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        Assert.assertEquals((Object)OWLRealIntervalTests.interval(2, 5, true, true, OWLRealInterval.LineType.INTEGER_ONLY), (Object)i.greater((Number)1));
    }

    @Test
    public void inclusiveEndpointsCon() {
        OWLRealInterval interval = OWLRealIntervalTests.interval(-1.3, 2.5, true, true, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(-1.3)));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(2.5)));
        Assert.assertTrue((boolean)interval.contains((Number)0));
    }

    @Test
    public void inclusiveEndpointsNoI1() {
        OWLRealInterval interval = OWLRealIntervalTests.interval(-1.3, 2.5, true, true, OWLRealInterval.LineType.INTEGER_EXCLUDED);
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(-1.3)));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(2.5)));
        Assert.assertFalse((boolean)interval.contains((Number)0));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(0.1)));
    }

    @Test
    public void inclusiveEndpointsNoI2() {
        OWLRealInterval interval = OWLRealIntervalTests.interval(-1, 3, true, true, OWLRealInterval.LineType.INTEGER_EXCLUDED);
        Assert.assertFalse((boolean)interval.contains((Number)-1));
        Assert.assertFalse((boolean)interval.contains((Number)3));
        Assert.assertFalse((boolean)interval.contains((Number)0));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(0.1)));
    }

    @Test
    public void inclusiveEndpointsOnly() {
        OWLRealInterval interval = OWLRealIntervalTests.interval(-1, 3, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        Assert.assertTrue((boolean)interval.contains((Number)-1));
        Assert.assertTrue((boolean)interval.contains((Number)3));
        Assert.assertTrue((boolean)interval.contains((Number)0));
    }

    @Test
    public void intersectionEmpty() {
        for (OWLRealInterval.LineType t : OWLRealInterval.LineType.values()) {
            OWLRealInterval a = OWLRealIntervalTests.interval(null, 0, false, true, t);
            OWLRealInterval b = OWLRealIntervalTests.interval(1, null, true, false, t);
            Assert.assertNull((Object)a.intersection(b));
            Assert.assertNull((Object)b.intersection(a));
            Assert.assertEquals((Object)IntervalRelations.PRECEDES, (Object)a.compare(b));
            Assert.assertEquals((Object)IntervalRelations.PRECEDED_BY, (Object)b.compare(a));
        }
    }

    @Test
    public void intersectionMeetsCon() {
        OWLRealInterval a = OWLRealIntervalTests.interval(null, 2.1, false, false, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval b = OWLRealIntervalTests.interval(2.1, null, true, false, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertNull((Object)a.intersection(b));
        Assert.assertNull((Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.MEETS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.MET_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionMeetsNoI() {
        OWLRealInterval a = OWLRealIntervalTests.interval(null, 2.1, false, false, OWLRealInterval.LineType.INTEGER_EXCLUDED);
        OWLRealInterval b = OWLRealIntervalTests.interval(2.1, null, true, false, OWLRealInterval.LineType.INTEGER_EXCLUDED);
        Assert.assertNull((Object)a.intersection(b));
        Assert.assertNull((Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.MEETS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.MET_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionOverlapConCon1() {
        OWLRealInterval a = OWLRealIntervalTests.interval(null, 0.51, false, false, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval b = OWLRealIntervalTests.interval(0.49, null, false, false, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval expected = OWLRealIntervalTests.interval(0.49, 0.51, false, false, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertEquals((Object)expected, (Object)a.intersection(b));
        Assert.assertEquals((Object)expected, (Object)b.intersection(a));
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.5)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.5)));
        Assert.assertFalse((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.49)));
        Assert.assertFalse((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.49)));
        Assert.assertFalse((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.51)));
        Assert.assertFalse((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.51)));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPPED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionOverlapConCon2() {
        OWLRealInterval a = OWLRealIntervalTests.interval(null, 0.51, false, true, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval b = OWLRealIntervalTests.interval(0.49, null, true, false, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval expected = OWLRealIntervalTests.interval(0.49, 0.51, true, true, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertEquals((Object)expected, (Object)a.intersection(b));
        Assert.assertEquals((Object)expected, (Object)b.intersection(a));
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.5)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.5)));
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.49)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.49)));
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.51)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.51)));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPPED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionPointCon() {
        OWLRealInterval a = OWLRealIntervalTests.interval(null, 2.1, false, true, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval b = OWLRealIntervalTests.interval(2.1, null, true, false, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval expected = new OWLRealInterval((Number)BigDecimal.valueOf(2.1));
        Assert.assertEquals((Object)expected, (Object)a.intersection(b));
        Assert.assertEquals((Object)expected, (Object)b.intersection(a));
        Assert.assertTrue((boolean)a.intersection(b).isPoint());
        Assert.assertTrue((boolean)b.intersection(a).isPoint());
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(2.1)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(2.1)));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPPED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionPointOnly() {
        OWLRealInterval a = OWLRealIntervalTests.interval(null, 2, false, true, OWLRealInterval.LineType.INTEGER_ONLY);
        OWLRealInterval b = OWLRealIntervalTests.interval(2, null, true, false, OWLRealInterval.LineType.INTEGER_ONLY);
        OWLRealInterval expected = new OWLRealInterval((Number)2);
        Assert.assertEquals((Object)expected, (Object)a.intersection(b));
        Assert.assertEquals((Object)expected, (Object)b.intersection(a));
        Assert.assertTrue((boolean)a.intersection(b).isPoint());
        Assert.assertTrue((boolean)b.intersection(a).isPoint());
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)2));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)2));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPPED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionStartsConCon1() {
        OWLRealInterval a = OWLRealIntervalTests.interval(2.1, 3.1, true, true, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval b = OWLRealIntervalTests.interval(2.1, null, true, false, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertEquals((Object)a, (Object)a.intersection(b));
        Assert.assertEquals((Object)a, (Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.STARTS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.STARTED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionStartsConCon2() {
        OWLRealInterval a = OWLRealIntervalTests.interval(2.1, 3.1, false, true, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval b = OWLRealIntervalTests.interval(2.1, null, false, false, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertEquals((Object)a, (Object)a.intersection(b));
        Assert.assertEquals((Object)a, (Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.STARTS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.STARTED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionStartsConCon3() {
        OWLRealInterval a = OWLRealIntervalTests.interval(2.1, 3.1, false, true, OWLRealInterval.LineType.CONTINUOUS);
        OWLRealInterval b = OWLRealIntervalTests.interval(2.1, null, true, false, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertEquals((Object)a, (Object)a.intersection(b));
        Assert.assertEquals((Object)a, (Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.DURING, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.CONTAINS, (Object)b.compare(a));
    }

    @Test
    public void isPointFalseCon() {
        OWLRealInterval a = OWLRealIntervalTests.interval(0.1, 0.2, true, true, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertFalse((boolean)a.isPoint());
    }

    @Test
    public void isPointFalseOnly() {
        OWLRealInterval a = OWLRealIntervalTests.interval(1, 2, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        Assert.assertFalse((boolean)a.isPoint());
    }

    @Test
    public void isPointTrueCon() {
        OWLRealInterval a = new OWLRealInterval((Number)BigDecimal.valueOf(0.1));
        Assert.assertTrue((boolean)a.isPoint());
        OWLRealInterval b = OWLRealIntervalTests.interval(0.1, 0.1, true, true, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertTrue((boolean)b.isPoint());
        Assert.assertEquals((Object)a, (Object)b);
    }

    @Test
    public void lessInt1() {
        OWLRealInterval i = OWLRealIntervalTests.interval(1, 5, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        Assert.assertEquals((Object)OWLRealIntervalTests.interval(1, 3, true, true, OWLRealInterval.LineType.INTEGER_ONLY), (Object)i.less((Number)4));
    }

    @Test
    public void lessInt2() {
        OWLRealInterval i = OWLRealIntervalTests.interval(1, 5, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        Assert.assertEquals((Object)OWLRealIntervalTests.interval(1, 4, true, true, OWLRealInterval.LineType.INTEGER_ONLY), (Object)i.less((Number)5));
    }

    @Test
    public void unboundContainsAll() {
        OWLRealInterval interval = new OWLRealInterval(null, null, false, false, OWLRealInterval.LineType.CONTINUOUS);
        Assert.assertFalse((boolean)interval.boundLower());
        Assert.assertFalse((boolean)interval.boundUpper());
        Assert.assertFalse((boolean)interval.isPoint());
        Assert.assertTrue((boolean)interval.contains((Number)-1));
        Assert.assertTrue((boolean)interval.contains((Number)0));
        Assert.assertTrue((boolean)interval.contains((Number)1));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(-0.31)));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(0.13)));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.valueOf(0.123))));
    }
}

