/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class OWLRealUtilsTests {
    private static Number decimal(String s) {
        return new BigDecimal(s);
    }

    private static Rational rational(Number a, Number b) {
        return new Rational(a, b);
    }

    @Test
    public void compareWithRational() {
        Assert.assertTrue((OWLRealUtils.compare((Number)OWLRealUtilsTests.decimal("0.333"), (Number)OWLRealUtilsTests.rational(1, 3)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((OWLRealUtils.compare((Number)OWLRealUtilsTests.decimal("0.334"), (Number)OWLRealUtilsTests.rational(1, 3)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((OWLRealUtils.compare((Number)OWLRealUtilsTests.decimal("0.25"), (Number)OWLRealUtilsTests.rational(1, 4)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((OWLRealUtils.compare((Number)2, (Number)OWLRealUtilsTests.rational(42, 14)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((OWLRealUtils.compare((Number)3, (Number)OWLRealUtilsTests.rational(42, 14)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((OWLRealUtils.compare((Number)4, (Number)OWLRealUtilsTests.rational(42, 14)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void canonicalBigDecimal() {
        Assert.assertEquals((Object)1, (Object)OWLRealUtils.getCanonicalObject((Number)BigDecimal.valueOf(10L, 1)));
        Assert.assertEquals((Object)1, (Object)OWLRealUtils.getCanonicalObject((Number)BigDecimal.valueOf(1L, 0)));
        Assert.assertEquals((Object)0, (Object)OWLRealUtils.getCanonicalObject((Number)BigDecimal.valueOf(0L, 0)));
        Assert.assertEquals((Object)0, (Object)OWLRealUtils.getCanonicalObject((Number)BigDecimal.valueOf(0L, 1)));
    }

    @Test
    public void isDecimalValueInteger() {
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("0")));
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("1")));
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("10")));
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("11")));
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("0.0")));
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("1.0")));
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("1.00")));
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("10.0")));
        Assert.assertTrue((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("11.0")));
        Assert.assertFalse((boolean)OWLRealUtils.isInteger((Number)new BigDecimal("10.01")));
    }
}

