/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class RestrictedTextDatatypeTests {
    private DatatypeReasoner reasoner = new DatatypeReasonerImpl();

    @Test
    public void testXSDString() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.STRING);
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\t")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\n")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"  This is a string  ")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"This is   a string")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"This is a string")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"sp-")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"EN-123456789")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"12345678-12345678")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"a")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"token")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"en")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"FR")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"sp-00")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"EN-12345678")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"-")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)".")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"8")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\u00b7")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":_.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"B00A")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":aA-.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"_.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"A8A")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"aA-.")));
    }

    @Test
    public void testXSDNormalizedString() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.NORMALIZED_STRING);
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\t")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\n")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"  This is a string  ")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"This is   a string")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"This is a string")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"sp-")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"EN-123456789")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"12345678-12345678")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"a")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"token")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"en")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"FR")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"sp-00")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"EN-12345678")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"-")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)".")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"8")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\u00b7")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":_.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"B00A")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":aA-.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"_.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"A8A")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"aA-.")));
    }

    @Test
    public void testXSDToken() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.TOKEN);
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\t")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\n")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"  This is a string  ")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"This is   a string")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"This is a string")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"sp-")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"EN-123456789")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"12345678-12345678")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"a")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"token")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"en")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"FR")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"sp-00")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"EN-12345678")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"-")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)".")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"8")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\u00b7")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":_.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"B00A")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":aA-.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"_.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"A8A")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"aA-.")));
    }

    @Test
    public void testXSDLanguage() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.LANGUAGE);
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\t")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\n")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"  This is a string  ")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"This is   a string")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"This is a string")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"sp-")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"EN-123456789")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"12345678-12345678")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"a")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"token")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"en")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"FR")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"sp-00")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"EN-12345678")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"-")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)".")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"8")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\u00b7")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":_.")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"B00A")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":aA-.")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"_.")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"A8A")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"aA-.")));
    }

    @Test
    public void testXSDNMToken() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.NMTOKEN);
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"-")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)".")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"8")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"\u00b7")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)" ")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)": ")));
    }

    @Test
    public void testXSDName() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.NAME);
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":_.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"B00A")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":aA-.")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)" ")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"0:")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"98w")));
    }

    @Test
    public void testXSDNCName() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.NCNAME);
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"_.")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"A8A")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"aA-.")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":_.")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":B00A")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)":aA-.")));
    }
}

