/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.MiscTests;

public class BlockingTests
extends AbstractKBTests {
    public static Test suite() {
        return new JUnit4TestAdapter(BlockingTests.class);
    }

    @org.junit.Test
    public void transitivityInverse() {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addTransitiveProperty(r);
        this.kb.addSubProperty((ATerm)r, q);
        this.kb.addSubClass(D, TermFactory.all((ATermAppl)q, (ATermAppl)C));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)D, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)D), (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.not((ATermAppl)C))))))));
    }

    @org.junit.Test
    public void propertyChain() {
        this.classes(C, D);
        this.objectProperties(p, q, r, s);
        this.kb.addDisjointClass(C, D);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, TermFactory.inv((ATermAppl)q), r, s}), s);
        this.kb.addSubClass(D, TermFactory.all((ATermAppl)s, (ATermAppl)C));
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)q), (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.some((ATermAppl)s, (ATermAppl)D)))));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void propertyChainInverse() {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{r, p}), q);
        this.kb.addSubClass(D, TermFactory.all((ATermAppl)q, (ATermAppl)C));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)D, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)D), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)C))))))));
    }

    @org.junit.Test
    public void propertyChainInverseCardinality() {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addFunctionalProperty(p);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{r, p}), q);
        this.kb.addSubClass(D, TermFactory.all((ATermAppl)q, (ATermAppl)C));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)D, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)D), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)C))))))));
    }

    @org.junit.Test
    public void doubleBlockingExample() {
        this.classes(C, D);
        this.objectProperties(f, r);
        this.kb.addTransitiveProperty(r);
        this.kb.addSubProperty((ATerm)f, r);
        this.kb.addEquivalentClass(D, TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)f, (ATermAppl)TermFactory.not((ATermAppl)C))));
        this.kb.addSubClass(TermFactory.TOP, TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.not((ATermAppl)C), TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)D), TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)D))})));
    }

    @org.junit.Test
    public void complexInconsistent() {
        this.kb = new OWLAPILoader().createKB(new String[]{MiscTests.base + "one+one-inconsistent.owl"});
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void complexAllUnsat() {
        this.kb = new OWLAPILoader().createKB(new String[]{MiscTests.base + "one+one-consistent-but-all-unsat.owl"});
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertEquals((Object)this.kb.getClasses(), (Object)this.kb.getUnsatisfiableClasses());
    }

    @org.junit.Test
    public void complexAllInfSat() {
        this.kb = new OWLAPILoader().createKB(new String[]{MiscTests.base + "one+one-consistent-and-all-inf-sat.owl"});
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getUnsatisfiableClasses().isEmpty());
    }

    @org.junit.Test
    public void deadlockBlock() {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addSubClass(D, TermFactory.BOTTOM);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)D)), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)D))));
    }

    @org.junit.Test
    public void yoyo() {
        this.classes(A);
        this.objectProperties(r);
        this.individuals(a, b);
        this.kb.addFunctionalProperty(r);
        this.kb.addSubClass(A, TermFactory.all((ATermAppl)r, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.TOP)));
        this.kb.addType(a, A);
        this.kb.addType(a, TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.TOP));
        this.kb.addPropertyValue(r, a, a);
        this.kb.addPropertyValue(r, a, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(A));
    }
}

