/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.owlapiv3.SWRL;
import com.clarkparsia.owlapiv3.XSD;
import com.clarkparsia.pellet.owlapiv3.AxiomConverter;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.clarkparsia.pellet.test.owlapi.AbstractOWLAPITests;
import com.clarkparsia.pellet.utils.PropertiesBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.test.MiscTests;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;

public class OWLAPIv3Tests
extends AbstractOWLAPITests {
    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(OWLAPIv3Tests.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOWL2() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "owl2.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        try {
            this.testOWL2Reasoner(ns, (OWLReasoner)reasoner);
        }
        finally {
            reasoner.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOWL2Incremental() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "owl2.owl"));
        IncrementalClassifier classifier = new IncrementalClassifier(ont);
        try {
            classifier.classify();
            OWLNamedIndividual ind1 = OWL.Individual((String)(ns + "ind1"));
            classifier.getTypes(ind1, true);
            this.testOWL2Reasoner(ns, (OWLReasoner)classifier);
        }
        finally {
            classifier.dispose();
        }
    }

    private void testOWL2Reasoner(String ns, OWLReasoner reasoner) {
        OWLClass C = OWL.Class((String)(ns + "C"));
        OWLClass D = OWL.Class((String)(ns + "D"));
        OWLClass D1 = OWL.Class((String)(ns + "D1"));
        OWLClass D2 = OWL.Class((String)(ns + "D2"));
        OWLClass D3 = OWL.Class((String)(ns + "D3"));
        OWLClass test1 = OWL.Class((String)(ns + "test1"));
        OWLClass test2 = OWL.Class((String)(ns + "test2"));
        OWLClass test3 = OWL.Class((String)(ns + "test3"));
        OWLClass OlderThan10 = OWL.Class((String)(ns + "OlderThan10"));
        OWLClass YoungerThan20 = OWL.Class((String)(ns + "YoungerThan20"));
        OWLClass Teenager = OWL.Class((String)(ns + "Teenager"));
        OWLClass Teen = OWL.Class((String)(ns + "Teen"));
        OWLNamedIndividual ind1 = OWL.Individual((String)(ns + "ind1"));
        OWLNamedIndividual ind3 = OWL.Individual((String)(ns + "ind3"));
        OWLNamedIndividual ind4 = OWL.Individual((String)(ns + "ind4"));
        OWLNamedIndividual ind5 = OWL.Individual((String)(ns + "ind5"));
        OWLNamedIndividual ind6 = OWL.Individual((String)(ns + "ind6"));
        OWLObjectProperty p = OWL.ObjectProperty((String)(ns + "p"));
        OWLObjectProperty r = OWL.ObjectProperty((String)(ns + "r"));
        OWLObjectProperty invR = OWL.ObjectProperty((String)(ns + "invR"));
        OWLObjectProperty ir = OWL.ObjectProperty((String)(ns + "ir"));
        OWLObjectProperty as = OWL.ObjectProperty((String)(ns + "as"));
        OWLObjectProperty d1 = OWL.ObjectProperty((String)(ns + "d1"));
        OWLObjectProperty d2 = OWL.ObjectProperty((String)(ns + "d2"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.reflexive((OWLObjectPropertyExpression)r)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.reflexive((OWLObjectPropertyExpression)invR)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.irreflexive((OWLObjectPropertyExpression)ir)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.asymmetric((OWLObjectPropertyExpression)as)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)D, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{D1, D2, D3}))));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)D, (OWLClassExpression)test1)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointClasses((OWLClassExpression)D1, (OWLClassExpression)D2)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointClasses((OWLClassExpression)D1, (OWLClassExpression)D3)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointClasses((OWLClassExpression)D2, (OWLClassExpression)D3)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)d1, (OWLObjectPropertyExpression)d2)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)d2, (OWLObjectPropertyExpression)d1)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)r)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)ind1, (OWLObjectPropertyExpression)r, (OWLIndividual)ind1)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)ind1, (OWLObjectPropertyExpression)invR, (OWLIndividual)ind1)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)ind1, (OWLIndividual)ind3)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)ind1, (OWLIndividual)ind4)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)ind5, (OWLIndividual)ind6)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)ind1, (OWLObjectPropertyExpression)p, (OWLIndividual)ind1)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)ind1, (OWLClassExpression)test2)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)ind1, (OWLClassExpression)test3)));
        PelletTestCase.assertIteratorValues(reasoner.getTypes(ind1, false).getFlattened().iterator(), OWL.Thing, C, test2, test3);
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)Teenager, (OWLClassExpression)OlderThan10)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)Teenager, (OWLClassExpression)YoungerThan20)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)Teenager, (OWLClassExpression)Teen)));
    }

    @Test
    public void testUncle() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "uncle.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        OWLNamedIndividual Bob = OWL.Individual((String)(ns + "Bob"));
        OWLNamedIndividual Sam = OWL.Individual((String)(ns + "Sam"));
        OWLObjectProperty uncleOf = OWL.ObjectProperty((String)(ns + "uncleOf"));
        OWLAPIv3Tests.assertPropertyValues(reasoner, Bob, uncleOf, new OWLIndividual[]{Sam});
    }

    @Test
    public void testSibling() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "sibling.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        OWLNamedIndividual Bob = OWL.Individual((String)(ns + "Bob"));
        OWLNamedIndividual John = OWL.Individual((String)(ns + "John"));
        OWLNamedIndividual Jane = OWL.Individual((String)(ns + "Jane"));
        OWLObjectProperty hasBrother = OWL.ObjectProperty((String)(ns + "hasBrother"));
        OWLObjectProperty hasSister = OWL.ObjectProperty((String)(ns + "hasSister"));
        OWLAPIv3Tests.assertPropertyValues(reasoner, Bob, hasBrother, new OWLIndividual[]{John});
        OWLAPIv3Tests.assertPropertyValues(reasoner, Bob, hasSister, new OWLIndividual[]{Jane});
    }

    public static void assertInstances(PelletReasoner reasoner, OWLClass subj, boolean direct, OWLNamedIndividual ... values) {
        HashSet<OWLNamedIndividual> expected = new HashSet<OWLNamedIndividual>(Arrays.asList(values));
        Assert.assertEquals(expected, (Object)reasoner.getInstances((OWLClassExpression)subj, direct).getFlattened());
    }

    public static void assertPropertyValues(PelletReasoner reasoner, OWLNamedIndividual subj, OWLObjectProperty pred, OWLIndividual ... values) {
        HashSet<OWLIndividual> expected = new HashSet<OWLIndividual>(Arrays.asList(values));
        Assert.assertEquals(expected, (Object)reasoner.getObjectPropertyValues(subj, (OWLObjectPropertyExpression)pred).getFlattened());
    }

    public static void assertPropertyValues(PelletReasoner reasoner, OWLNamedIndividual subj, OWLDataProperty pred, OWLLiteral values) {
        HashSet<OWLLiteral> expected = new HashSet<OWLLiteral>(Arrays.asList(values));
        Assert.assertEquals(expected, (Object)reasoner.getDataPropertyValues(subj, pred));
    }

    public static void assertTypes(PelletReasoner reasoner, OWLNamedIndividual subj, boolean direct, OWLClass ... values) {
        HashSet<OWLClass> expected = new HashSet<OWLClass>(Arrays.asList(values));
        Assert.assertEquals(expected, (Object)reasoner.getTypes(subj, direct).getFlattened());
    }

    @Test
    public void testPropertyChain() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "propertyChain.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        OWLClass C = OWL.Class((String)(ns + "C"));
        OWLClass S0 = OWL.Class((String)(ns + "S0"));
        OWLClass R0 = OWL.Class((String)(ns + "R0"));
        OWLClass R1 = OWL.Class((String)(ns + "R1"));
        OWLObjectProperty r = OWL.ObjectProperty((String)(ns + "r"));
        OWLObjectProperty s = OWL.ObjectProperty((String)(ns + "s"));
        OWLNamedIndividual[] a = new OWLNamedIndividual[17];
        for (int i = 0; i < a.length; ++i) {
            a[i] = OWL.Individual((String)(ns + "a" + i));
        }
        OWLIndividual[] theList = new OWLIndividual[]{a[1], a[2], a[3], a[4], a[5], a[6], a[8], a[10], a[12], a[14], a[16]};
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.transitive((OWLObjectPropertyExpression)r)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.transitive((OWLObjectPropertyExpression)s)));
        PelletTestCase.assertIteratorValues(reasoner.getInstances((OWLClassExpression)C, false).getFlattened().iterator(), theList);
        PelletTestCase.assertIteratorValues(reasoner.getInstances((OWLClassExpression)S0, false).getFlattened().iterator(), theList);
        PelletTestCase.assertIteratorValues(reasoner.getInstances((OWLClassExpression)R0, false).getFlattened().iterator(), a[7], a[9]);
        PelletTestCase.assertIteratorValues(reasoner.getInstances((OWLClassExpression)R1, false).getFlattened().iterator(), a[2], a[3], a[4], a[5], a[6]);
        PelletTestCase.assertIteratorValues(reasoner.getObjectPropertyValues(a[0], (OWLObjectPropertyExpression)r).getFlattened().iterator(), a[7], a[9]);
        PelletTestCase.assertIteratorValues(reasoner.getObjectPropertyValues(a[1], (OWLObjectPropertyExpression)r).getFlattened().iterator(), a[2], a[3], a[4], a[5], a[6]);
        PelletTestCase.assertIteratorValues(reasoner.getObjectPropertyValues(a[0], (OWLObjectPropertyExpression)s).getFlattened().iterator(), theList);
    }

    @Test
    public void testQualifiedCardinality1() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "qcr.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        OWLClass sub = OWL.Class((String)(ns + "sub"));
        OWLClass sup = OWL.Class((String)(ns + "sup"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)sub, (OWLClassExpression)sup)));
        Assert.assertTrue((boolean)reasoner.getSubClasses((OWLClassExpression)sup, false).getFlattened().contains(sub));
        Assert.assertTrue((boolean)reasoner.getSuperClasses((OWLClassExpression)sub, false).getFlattened().contains(sup));
    }

    @Test
    public void testReflexive2() throws OWLException {
        String ns = "http://www.example.org/test#";
        String foaf = "http://xmlns.com/foaf/0.1/";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "reflexive.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        OWLObjectProperty[] knows = new OWLObjectProperty[]{OWL.ObjectProperty((String)(foaf + "knows")), OWL.ObjectProperty((String)(ns + "knows2")), OWL.ObjectProperty((String)(ns + "knows3"))};
        OWLNamedIndividual[] people = new OWLNamedIndividual[5];
        for (int i = 0; i < people.length; ++i) {
            people[i] = OWL.Individual((String)(ns + "P" + (i + 1)));
            for (int j = 0; j < knows.length; ++j) {
                Assert.assertTrue((String)(people[i] + " " + knows[j]), (boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)people[i], (OWLObjectPropertyExpression)knows[j], (OWLIndividual)people[i])));
                OWLAPIv3Tests.assertPropertyValues(reasoner, people[i], knows[j], new OWLIndividual[]{people[i]});
            }
        }
    }

    @Test
    public void testInfiniteChain() throws Exception {
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "infiniteChain.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertTrue((!reasoner.isConsistent() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveLiteralNoBuffering1() throws Exception {
        this.testRemoveLiteral("ind1", false);
    }

    @Test
    public void testRemoveLiteralNoBuffering2() throws Exception {
        this.testRemoveLiteral("ind2", false);
    }

    @Test
    public void testRemoveLiteralWithBuffering1() throws Exception {
        this.testRemoveLiteral("ind1", true);
    }

    @Test
    public void testRemoveLiteralWithBuffering2() throws Exception {
        this.testRemoveLiteral("ind2", true);
    }

    public void testRemoveLiteral(String indName, boolean buffering) throws Exception {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "RemoveLiteral.owl"));
        PelletReasoner reasoner = buffering ? PelletReasonerFactory.getInstance().createReasoner(ont) : PelletReasonerFactory.getInstance().createNonBufferingReasoner(ont);
        OWLDataProperty pInt = OWL.DataProperty((String)(ns + "pInt"));
        OWLDataProperty pDouble = OWL.DataProperty((String)(ns + "pDouble"));
        OWLDataProperty pBoolean = OWL.DataProperty((String)(ns + "pBoolean"));
        OWLNamedIndividual ind = OWL.Individual((String)(ns + indName));
        OWLLiteral valDouble = (OWLLiteral)ind.getDataPropertyValues((OWLDataPropertyExpression)pDouble, ont).iterator().next();
        OWLLiteral valInt = (OWLLiteral)ind.getDataPropertyValues((OWLDataPropertyExpression)pInt, ont).iterator().next();
        OWLLiteral valBoolean = (OWLLiteral)ind.getDataPropertyValues((OWLDataPropertyExpression)pBoolean, ont).iterator().next();
        Assert.assertTrue((boolean)reasoner.isConsistent());
        OntologyUtils.removeAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)ind, (OWLDataPropertyExpression)pDouble, (OWLLiteral)valDouble)});
        if (buffering) {
            Assert.assertFalse((boolean)reasoner.getDataPropertyValues(ind, pDouble).isEmpty());
            reasoner.flush();
        }
        Assert.assertTrue((boolean)reasoner.getDataPropertyValues(ind, pDouble).isEmpty());
        OntologyUtils.removeAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)ind, (OWLDataPropertyExpression)pInt, (OWLLiteral)valInt)});
        if (buffering) {
            Assert.assertFalse((boolean)reasoner.getDataPropertyValues(ind, pInt).isEmpty());
            reasoner.flush();
        }
        Assert.assertTrue((boolean)reasoner.getDataPropertyValues(ind, pInt).isEmpty());
        OntologyUtils.removeAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)ind, (OWLDataPropertyExpression)pBoolean, (OWLLiteral)valBoolean)});
        if (buffering) {
            Assert.assertFalse((boolean)reasoner.getDataPropertyValues(ind, pBoolean).isEmpty());
            reasoner.flush();
        }
        Assert.assertTrue((boolean)reasoner.getDataPropertyValues(ind, pBoolean).isEmpty());
        OWLLiteral newVal = OWL.constant((String)"0.0", (OWLDatatype)XSD.DOUBLE);
        OntologyUtils.addAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)ind, (OWLDataPropertyExpression)pDouble, (OWLLiteral)newVal)});
        if (buffering) {
            reasoner.flush();
        }
        Assert.assertTrue((boolean)reasoner.isConsistent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFamily() throws OWLException {
        String ns = "http://www.example.org/family#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "family.owl"));
        for (OWLAxiom axiom : ont.getAxioms()) {
            System.out.println(axiom);
        }
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        try {
            this.testFamily(ns, (OWLReasoner)reasoner);
            reasoner.getKB().realize();
            this.testFamily(ns, (OWLReasoner)reasoner);
        }
        finally {
            reasoner.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFamilyIncremental() {
        String ns = "http://www.example.org/family#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "family.owl"));
        IncrementalClassifier classifier = new IncrementalClassifier(ont);
        try {
            classifier.classify();
            this.testFamily(ns, (OWLReasoner)classifier);
            OWLNamedIndividual ind1 = OWL.Individual((String)(ns + "ind1"));
            classifier.getTypes(ind1, true);
            this.testFamily(ns, (OWLReasoner)classifier);
        }
        finally {
            classifier.dispose();
        }
    }

    private void testFamily(String ns, OWLReasoner reasoner) {
        OWLObjectProperty hasBrother = OWL.ObjectProperty((String)(ns + "hasBrother"));
        OWLObjectProperty hasSon = OWL.ObjectProperty((String)(ns + "hasSon"));
        OWLObjectProperty hasFather = OWL.ObjectProperty((String)(ns + "hasFather"));
        OWLObjectProperty hasParent = OWL.ObjectProperty((String)(ns + "hasParent"));
        OWLObjectProperty hasChild = OWL.ObjectProperty((String)(ns + "hasChild"));
        OWLObjectProperty hasMother = OWL.ObjectProperty((String)(ns + "hasMother"));
        OWLObjectProperty hasDaughter = OWL.ObjectProperty((String)(ns + "hasDaughter"));
        OWLObjectProperty hasAncestor = OWL.ObjectProperty((String)(ns + "hasAncestor"));
        OWLObjectProperty likes = OWL.ObjectProperty((String)(ns + "likes"));
        OWLObjectProperty isMarriedTo = OWL.ObjectProperty((String)(ns + "isMarriedTo"));
        OWLObjectProperty dislikes = OWL.ObjectProperty((String)(ns + "dislikes"));
        OWLObjectProperty hasSister = OWL.ObjectProperty((String)(ns + "hasSister"));
        OWLObjectProperty hasDescendant = OWL.ObjectProperty((String)(ns + "hasDescendant"));
        OWLObjectProperty hasSibling = OWL.ObjectProperty((String)(ns + "hasSibling"));
        OWLClass Child = OWL.Class((String)(ns + "Child"));
        OWLClass Person = OWL.Class((String)(ns + "Person"));
        OWLClass PersonWithAtLeastTwoMaleChildren = OWL.Class((String)(ns + "PersonWithAtLeastTwoMaleChildren"));
        OWLClass PersonWithAtLeastTwoFemaleChildren = OWL.Class((String)(ns + "PersonWithAtLeastTwoFemaleChildren"));
        OWLClass PersonWithAtLeastTwoChildren = OWL.Class((String)(ns + "PersonWithAtLeastTwoChildren"));
        OWLClass PersonWithAtLeastFourChildren = OWL.Class((String)(ns + "PersonWithAtLeastFourChildren"));
        OWLClass Teen = OWL.Class((String)(ns + "Teen"));
        OWLClass Teenager = OWL.Class((String)(ns + "Teenager"));
        OWLClass Male = OWL.Class((String)(ns + "Male"));
        OWLClass Adult = OWL.Class((String)(ns + "Adult"));
        OWLClass Female = OWL.Class((String)(ns + "Female"));
        OWLClass Senior = OWL.Class((String)(ns + "Senior"));
        OWLNamedIndividual grandmother = OWL.Individual((String)(ns + "grandmother"));
        OWLNamedIndividual grandfather = OWL.Individual((String)(ns + "grandfather"));
        OWLNamedIndividual father = OWL.Individual((String)(ns + "father"));
        OWLNamedIndividual son = OWL.Individual((String)(ns + "son"));
        OWLNamedIndividual mother = OWL.Individual((String)(ns + "mother"));
        OWLNamedIndividual daughter = OWL.Individual((String)(ns + "daughter"));
        OWLNamedIndividual personX = OWL.Individual((String)(ns + "personX"));
        OWLNamedIndividual personY = OWL.Individual((String)(ns + "personY"));
        OWLNamedIndividual personZ = OWL.Individual((String)(ns + "personZ"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.transitive((OWLObjectPropertyExpression)hasAncestor)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.functional((OWLObjectPropertyExpression)hasAncestor)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.transitive((OWLObjectPropertyExpression)hasDescendant)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.functional((OWLObjectPropertyExpression)hasDescendant)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.symmetric((OWLObjectPropertyExpression)isMarriedTo)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.irreflexive((OWLObjectPropertyExpression)isMarriedTo)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subPropertyOf((OWLObjectPropertyExpression)hasParent, (OWLObjectPropertyExpression)hasAncestor)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subPropertyOf((OWLObjectPropertyExpression)hasFather, (OWLObjectPropertyExpression)hasAncestor)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subPropertyOf((OWLObjectPropertyExpression)hasMother, (OWLObjectPropertyExpression)hasAncestor)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subPropertyOf((OWLObjectPropertyExpression)hasChild, (OWLObjectPropertyExpression)hasDescendant)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)likes, (OWLObjectPropertyExpression)dislikes)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)dislikes, (OWLObjectPropertyExpression)likes)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)hasFather, (OWLObjectPropertyExpression)hasMother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)hasMother, (OWLObjectPropertyExpression)hasFather)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)grandfather, (OWLClassExpression)Person)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)grandfather, (OWLClassExpression)PersonWithAtLeastTwoChildren)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)grandfather, (OWLClassExpression)PersonWithAtLeastTwoMaleChildren)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)grandfather, (OWLClassExpression)Male)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)grandfather, (OWLClassExpression)Senior)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)grandfather, (OWLObjectPropertyExpression)isMarriedTo, (OWLIndividual)grandmother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)grandfather, (OWLObjectPropertyExpression)hasChild, (OWLIndividual)father)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)grandfather, (OWLObjectPropertyExpression)hasSon, (OWLIndividual)father)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)grandfather, (OWLIndividual)grandmother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)grandfather, (OWLIndividual)father)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)grandfather, (OWLIndividual)mother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)grandfather, (OWLIndividual)son)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)grandfather, (OWLIndividual)daughter)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)grandmother, (OWLClassExpression)Person)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)grandmother, (OWLClassExpression)Female)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)grandmother, (OWLClassExpression)Senior)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)grandmother, (OWLObjectPropertyExpression)isMarriedTo, (OWLIndividual)grandfather)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)grandmother, (OWLObjectPropertyExpression)hasChild, (OWLIndividual)father)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)grandmother, (OWLObjectPropertyExpression)hasSon, (OWLIndividual)father)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)father, (OWLClassExpression)Person)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)father, (OWLClassExpression)Male)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)father, (OWLClassExpression)Adult)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)father, (OWLObjectPropertyExpression)hasParent, (OWLIndividual)grandfather)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)father, (OWLObjectPropertyExpression)hasParent, (OWLIndividual)grandmother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)father, (OWLObjectPropertyExpression)hasFather, (OWLIndividual)grandfather)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)father, (OWLObjectPropertyExpression)hasMother, (OWLIndividual)grandmother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)father, (OWLObjectPropertyExpression)hasChild, (OWLIndividual)son)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)father, (OWLObjectPropertyExpression)hasSon, (OWLIndividual)son)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)father, (OWLObjectPropertyExpression)hasChild, (OWLIndividual)daughter)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)father, (OWLObjectPropertyExpression)hasDaughter, (OWLIndividual)daughter)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)mother, (OWLClassExpression)Person)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)mother, (OWLClassExpression)Female)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)son, (OWLClassExpression)Male)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)son, (OWLClassExpression)Teenager)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)son, (OWLClassExpression)Teen)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)son, (OWLObjectPropertyExpression)hasParent, (OWLIndividual)father)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)son, (OWLObjectPropertyExpression)hasFather, (OWLIndividual)father)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)son, (OWLObjectPropertyExpression)hasSibling, (OWLIndividual)daughter)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)son, (OWLObjectPropertyExpression)hasSister, (OWLIndividual)daughter)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)daughter, (OWLClassExpression)Female)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)daughter, (OWLClassExpression)Child)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)daughter, (OWLObjectPropertyExpression)hasAncestor, (OWLIndividual)grandfather)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)daughter, (OWLObjectPropertyExpression)hasAncestor, (OWLIndividual)grandmother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)daughter, (OWLObjectPropertyExpression)hasParent, (OWLIndividual)father)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)daughter, (OWLObjectPropertyExpression)hasFather, (OWLIndividual)father)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)daughter, (OWLObjectPropertyExpression)hasParent, (OWLIndividual)mother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)daughter, (OWLObjectPropertyExpression)hasMother, (OWLIndividual)mother)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)daughter, (OWLObjectPropertyExpression)hasSibling, (OWLIndividual)son)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)daughter, (OWLObjectPropertyExpression)hasBrother, (OWLIndividual)son)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)personX, (OWLIndividual)personY)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)personX, (OWLIndividual)personZ)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.differentFrom((OWLIndividual)personY, (OWLIndividual)personZ)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)Teen, (OWLClassExpression)Teenager)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)Senior, (OWLClassExpression)Adult)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastTwoMaleChildren, (OWLClassExpression)Person)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastTwoFemaleChildren, (OWLClassExpression)Person)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastTwoChildren, (OWLClassExpression)Person)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastFourChildren, (OWLClassExpression)Person)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastFourChildren, (OWLClassExpression)PersonWithAtLeastTwoChildren)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastTwoMaleChildren, (OWLClassExpression)PersonWithAtLeastTwoChildren)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastTwoFemaleChildren, (OWLClassExpression)PersonWithAtLeastTwoChildren)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastTwoFemaleChildren, (OWLClassExpression)PersonWithAtLeastTwoMaleChildren)));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)PersonWithAtLeastTwoMaleChildren, (OWLClassExpression)PersonWithAtLeastTwoFemaleChildren)));
    }

    @Test
    public void testAnonInverse() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "anon_inverse.owl"));
        OWLClass C = OWL.Class((String)(ns + "C"));
        OWLClass D = OWL.Class((String)(ns + "D"));
        OWLObjectProperty r = OWL.ObjectProperty((String)(ns + "r"));
        OWLObjectSomeValuesFrom desc = OWL.some((OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)r), (OWLClassExpression)D);
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertEquals(Collections.singleton(C), (Object)reasoner.getSubClasses((OWLClassExpression)desc, true).getFlattened());
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.inverseFunctional((OWLObjectPropertyExpression)OWL.ObjectProperty((String)(ns + "functionalP")))));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.functional((OWLObjectPropertyExpression)OWL.ObjectProperty((String)(ns + "inverseFunctionalP")))));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.transitive((OWLObjectPropertyExpression)OWL.ObjectProperty((String)(ns + "transitiveP")))));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.symmetric((OWLObjectPropertyExpression)OWL.ObjectProperty((String)(ns + "symmetricP")))));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.reflexive((OWLObjectPropertyExpression)OWL.ObjectProperty((String)(ns + "reflexiveP")))));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.irreflexive((OWLObjectPropertyExpression)OWL.ObjectProperty((String)(ns + "irreflexiveP")))));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.asymmetric((OWLObjectPropertyExpression)OWL.ObjectProperty((String)(ns + "asymmetricP")))));
        OWLObjectProperty p1 = OWL.ObjectProperty((String)(ns + "p1"));
        OWLObjectProperty p2 = OWL.ObjectProperty((String)(ns + "p2"));
        OWLObjectProperty p3 = OWL.ObjectProperty((String)(ns + "p3"));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.equivalentProperties((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.equivalentProperties((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p3)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.equivalentProperties((OWLObjectPropertyExpression)p2, (OWLObjectPropertyExpression)p3)));
    }

    @Test
    public void testDLSafeRules() throws OWLOntologyCreationException {
        String ns = "http://owldl.com/ontologies/dl-safe.owl#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "dl-safe.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        OWLObjectProperty hates = OWL.ObjectProperty((String)(ns + "hates"));
        OWLObjectProperty sibling = OWL.ObjectProperty((String)(ns + "sibling"));
        OWLClass BadChild = OWL.Class((String)(ns + "BadChild"));
        OWLClass Child = OWL.Class((String)(ns + "Child"));
        OWLClass Grandchild = OWL.Class((String)(ns + "Grandchild"));
        OWLClass Person = OWL.Class((String)(ns + "Person"));
        OWLNamedIndividual Abel = OWL.Individual((String)(ns + "Abel"));
        OWLNamedIndividual Cain = OWL.Individual((String)(ns + "Cain"));
        OWLNamedIndividual Oedipus = OWL.Individual((String)(ns + "Oedipus"));
        OWLNamedIndividual Remus = OWL.Individual((String)(ns + "Remus"));
        OWLNamedIndividual Romulus = OWL.Individual((String)(ns + "Romulus"));
        for (int test = 0; test < 2; ++test) {
            if (test != 0) {
                reasoner.prepareReasoner();
            }
            Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)Abel, (OWLObjectPropertyExpression)sibling, (OWLIndividual)Cain)));
            OWLAPIv3Tests.assertPropertyValues(reasoner, Abel, sibling, new OWLIndividual[]{Cain});
            Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)Cain, (OWLObjectPropertyExpression)sibling, (OWLIndividual)Abel)));
            OWLAPIv3Tests.assertPropertyValues(reasoner, Cain, sibling, new OWLIndividual[]{Abel});
            Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)Cain, (OWLObjectPropertyExpression)hates, (OWLIndividual)Abel)));
            Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)Abel, (OWLObjectPropertyExpression)hates, (OWLIndividual)Cain)));
            Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)Cain, (OWLClassExpression)Grandchild)));
            Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)Cain, (OWLClassExpression)BadChild)));
            Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)Romulus, (OWLObjectPropertyExpression)sibling, (OWLIndividual)Remus)));
            Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)Romulus, (OWLClassExpression)Grandchild)));
            Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)Romulus, (OWLClassExpression)BadChild)));
            Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)Oedipus, (OWLClassExpression)Child)));
        }
        PelletTestCase.assertIteratorValues(reasoner.getTypes(Cain, true).getFlattened().iterator(), BadChild, Child, Person);
    }

    @Test
    public void testDLSafeConstants() throws OWLOntologyCreationException {
        String ns = "http://owldl.com/ontologies/dl-safe-constants.owl#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "dl-safe-constants.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        OWLClass DreamTeamMember = OWL.Class((String)(ns + "DreamTeamMember"));
        OWLClass DreamTeamMember1 = OWL.Class((String)(ns + "DreamTeamMember1"));
        OWLClass DreamTeamMember2 = OWL.Class((String)(ns + "DreamTeamMember2"));
        OWLNamedIndividual Alice = OWL.Individual((String)(ns + "Alice"));
        OWLNamedIndividual Bob = OWL.Individual((String)(ns + "Bob"));
        OWLNamedIndividual Charlie = OWL.Individual((String)(ns + "Charlie"));
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                reasoner.prepareReasoner();
            }
            PelletTestCase.assertIteratorValues(reasoner.getInstances((OWLClassExpression)DreamTeamMember, false).getFlattened().iterator(), Alice, Bob, Charlie);
            PelletTestCase.assertIteratorValues(reasoner.getInstances((OWLClassExpression)DreamTeamMember1, false).getFlattened().iterator(), Alice, Bob, Charlie);
            PelletTestCase.assertIteratorValues(reasoner.getInstances((OWLClassExpression)DreamTeamMember2, false).getFlattened().iterator(), Alice, Bob, Charlie);
        }
    }

    @Test
    public void testInvalidTransitivity() throws Exception {
        String ns = "http://www.example.org/test#";
        OWLClass C = OWL.Class((String)(ns + "C"));
        OWLObjectProperty p1 = OWL.ObjectProperty((String)(ns + "p1"));
        OWLObjectProperty p2 = OWL.ObjectProperty((String)(ns + "p2"));
        OWLNamedIndividual x = OWL.Individual((String)(ns + "x"));
        OWLNamedIndividual y = OWL.Individual((String)(ns + "y"));
        OWLNamedIndividual z = OWL.Individual((String)(ns + "z"));
        OWLOntology ont = OWL.Ontology((OWLAxiom[])new OWLAxiom[]{OWL.transitive((OWLObjectPropertyExpression)p1), OWL.classAssertion((OWLIndividual)x, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)p1, (OWLClassExpression)C)), OWL.propertyAssertion((OWLIndividual)x, (OWLObjectPropertyExpression)p1, (OWLIndividual)y), OWL.propertyAssertion((OWLIndividual)y, (OWLObjectPropertyExpression)p1, (OWLIndividual)z)});
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)y, (OWLClassExpression)C)));
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)z, (OWLClassExpression)C)));
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.functional((OWLObjectPropertyExpression)p1), OWL.inverseFunctional((OWLObjectPropertyExpression)p1), OWL.irreflexive((OWLObjectPropertyExpression)p1), OWL.asymmetric((OWLObjectPropertyExpression)p1), OWL.disjointProperties((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2), OWL.subClassOf((OWLClassExpression)C, (OWLClassExpression)OWL.min((OWLObjectPropertyExpression)p1, (int)2)), OWL.classAssertion((OWLIndividual)x, (OWLClassExpression)OWL.max((OWLObjectPropertyExpression)p1, (int)3)), OWL.disjointClasses((OWLClassExpression)C, (OWLClassExpression)OWL.min((OWLObjectPropertyExpression)p1, (int)2))};
        for (int i = 0; i < axioms.length; ++i) {
            OntologyUtils.addAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{axioms[i]});
            reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
            Assert.assertTrue((String)axioms[i].toString(), (boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)y, (OWLClassExpression)C)));
            Assert.assertFalse((String)axioms[i].toString(), (boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)z, (OWLClassExpression)C)));
            OntologyUtils.removeAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{axioms[i]});
        }
    }

    @Test
    public void testInvalidTransitivity2() throws OWLOntologyCreationException {
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "invalidTransitivity.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        KnowledgeBase kb = reasoner.getKB();
        kb.prepare();
        for (Role r : kb.getRBox().getRoles()) {
            if (ATermUtils.isBuiltinProperty((ATermAppl)r.getName())) continue;
            Assert.assertTrue((String)r.toString(), (boolean)r.isSimple());
            Assert.assertFalse((String)r.toString(), (boolean)r.isTransitive());
        }
        for (ATermAppl p : kb.getObjectProperties()) {
            if (ATermUtils.isBuiltinProperty((ATermAppl)p)) continue;
            Assert.assertFalse((String)p.toString(), (boolean)kb.isTransitiveProperty(p));
        }
    }

    @Test
    public void testSameAs1() throws OWLException {
        String ns = "urn:test:";
        IRI ontIRI = IRI.create((String)(base + "invalidTransitivity.owl"));
        OWLNamedIndividual a = OWL.Individual((String)(ns + "a"));
        OWLNamedIndividual b = OWL.Individual((String)(ns + "b"));
        OWLNamedIndividual c = OWL.Individual((String)(ns + "c"));
        OWLObjectProperty p = OWL.ObjectProperty((String)(ns + "p"));
        OWLObjectProperty q = OWL.ObjectProperty((String)(ns + "q"));
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)c));
        axioms.add(OWL.propertyAssertion((OWLIndividual)b, (OWLObjectPropertyExpression)p, (OWLIndividual)b));
        axioms.add(OWL.propertyAssertion((OWLIndividual)c, (OWLObjectPropertyExpression)q, (OWLIndividual)a));
        axioms.add(OWL.sameAs((OWLIndividual)b, (OWLIndividual)c));
        axioms.add(OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)q, (OWLIndividual)c));
        OWLOntology ont = OWL.Ontology(axioms, (IRI)ontIRI);
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLNamedIndividual[]{a}), (Object)reasoner.getSameIndividuals(a).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLNamedIndividual[]{b, c}), (Object)reasoner.getSameIndividuals(b).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLNamedIndividual[]{b, c}), (Object)reasoner.getSameIndividuals(c).getEntities());
        OWLAPIv3Tests.assertPropertyValues(reasoner, a, p, new OWLIndividual[]{b, c});
        OWLAPIv3Tests.assertPropertyValues(reasoner, a, q, new OWLIndividual[]{b, c});
        OWLAPIv3Tests.assertPropertyValues(reasoner, b, p, new OWLIndividual[]{b, c});
        OWLAPIv3Tests.assertPropertyValues(reasoner, b, q, new OWLIndividual[]{a});
        OWLAPIv3Tests.assertPropertyValues(reasoner, c, p, new OWLIndividual[]{b, c});
        OWLAPIv3Tests.assertPropertyValues(reasoner, c, q, new OWLIndividual[]{a});
    }

    @Test
    public void testSameAs3() throws OWLException {
        String ns = "urn:test:";
        IRI ontIRI = IRI.create((String)(base + "test.owl"));
        OWLNamedIndividual i1 = OWL.Individual((String)(ns + "i1"));
        OWLNamedIndividual i2 = OWL.Individual((String)(ns + "i2"));
        OWLNamedIndividual i3 = OWL.Individual((String)(ns + "i3"));
        OWLClass c = OWL.Class((String)(ns + "c"));
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.equivalentClasses((OWLClassExpression)c, (OWLClassExpression)OWL.oneOf((OWLIndividual[])new OWLIndividual[]{i1, i2})));
        axioms.add(OWL.classAssertion((OWLIndividual)i3, (OWLClassExpression)c));
        OWLOntology ont = OWL.Ontology(axioms, (IRI)ontIRI);
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertTrue((!reasoner.isEntailed((OWLAxiom)OWL.sameAs((OWLIndividual)i1, (OWLIndividual)i2)) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isEntailed((OWLAxiom)OWL.sameAs((OWLIndividual)i1, (OWLIndividual)i3)) ? 1 : 0) != 0);
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLNamedIndividual[]{i1}), (Object)reasoner.getSameIndividuals(i1).getEntities());
        Assert.assertTrue((!reasoner.isEntailed((OWLAxiom)OWL.sameAs((OWLIndividual)i2, (OWLIndividual)i1)) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isEntailed((OWLAxiom)OWL.sameAs((OWLIndividual)i2, (OWLIndividual)i3)) ? 1 : 0) != 0);
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLNamedIndividual[]{i2}), (Object)reasoner.getSameIndividuals(i2).getEntities());
        Assert.assertTrue((!reasoner.isEntailed((OWLAxiom)OWL.sameAs((OWLIndividual)i3, (OWLIndividual)i1)) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isEntailed((OWLAxiom)OWL.sameAs((OWLIndividual)i3, (OWLIndividual)i2)) ? 1 : 0) != 0);
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLNamedIndividual[]{i3}), (Object)reasoner.getSameIndividuals(i3).getEntities());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealizeByIndividualsNPE() throws Exception {
        Properties newOptions = PropertiesBuilder.singleton((String)"REALIZE_INDIVIDUAL_AT_A_TIME", (String)"true");
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            TimedProgressMonitor monitor = new TimedProgressMonitor(1);
            OWLOntology ont = OntologyUtils.loadOntology((String)(base + "food.owl"));
            PelletReasoner pellet = PelletReasonerFactory.getInstance().createReasoner(ont);
            KnowledgeBase kb = pellet.getKB();
            kb.classify();
            kb.getTaxonomyBuilder().setProgressMonitor((ProgressMonitor)monitor);
            kb.realize();
            Assert.assertFalse((boolean)kb.isRealized());
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    @Test
    public void testClassificationTimeout() throws Exception {
        boolean timeout = false;
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "food.owl"));
        PelletReasoner pellet = PelletReasonerFactory.getInstance().createReasoner(ont);
        KnowledgeBase kb = pellet.getKB();
        Timer timer = kb.timers.createTimer("classify");
        timer.setTimeout(1L);
        try {
            kb.classify();
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertTrue((boolean)timeout);
        Assert.assertFalse((boolean)kb.isClassified());
    }

    @Test
    public void testRealizationTimeout() throws Exception {
        boolean timeout = false;
        OWLOntology ont = OntologyUtils.loadOntology((String)("file:" + PelletTestSuite.base + "modularity/SWEET.owl"));
        PelletReasoner pellet = PelletReasonerFactory.getInstance().createReasoner(ont);
        KnowledgeBase kb = pellet.getKB();
        Timer timer = kb.timers.createTimer("realize");
        timer.setTimeout(1L);
        try {
            kb.classify();
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertFalse((boolean)timeout);
        Assert.assertTrue((boolean)kb.isClassified());
        long time = System.currentTimeMillis();
        try {
            kb.realize();
            time = System.currentTimeMillis() - time;
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertTrue((String)("Timeout failed: " + timer + "\nAll timers:\n" + kb.timers), (boolean)timeout);
        Assert.assertFalse((boolean)kb.isRealized());
    }

    @Test
    public void testAxiomConverterRules1() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        kb.addClass(C);
        kb.addClass(D);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(SWRL.classAtom((OWLClassExpression)OWL.Class((String)"C"), (SWRLIArgument)SWRL.variable((String)"x")));
        consequent.add(SWRL.classAtom((OWLClassExpression)OWL.Class((String)"D"), (SWRLIArgument)SWRL.variable((String)"x")));
        SWRLRule expected = SWRL.rule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules1b() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl name = ATermUtils.makeTermAppl((String)"MyRule");
        kb.addClass(C);
        kb.addClass(D);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl)name, (ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(SWRL.classAtom((OWLClassExpression)OWL.Class((String)"C"), (SWRLIArgument)SWRL.variable((String)"x")));
        consequent.add(SWRL.classAtom((OWLClassExpression)OWL.Class((String)"D"), (SWRLIArgument)SWRL.variable((String)"x")));
        SWRLRule expected = SWRL.rule((String)name.getName(), antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void testAxiomConverterRules1c() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl name = ATermUtils.makeBnode((String)"MyRule");
        kb.addClass(C);
        kb.addClass(D);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl)name, (ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(SWRL.classAtom((OWLClassExpression)OWL.Class((String)"C"), (SWRLIArgument)SWRL.variable((String)"x")));
        consequent.add(SWRL.classAtom((OWLClassExpression)OWL.Class((String)"D"), (SWRLIArgument)SWRL.variable((String)"x")));
        SWRLRule expected = SWRL.rule((String)name.getArgument(0).toString(), (boolean)true, antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules2() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl i = ATermUtils.makeTermAppl((String)"i");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)i, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)i, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(SWRL.classAtom((OWLClassExpression)OWL.Class((String)"C"), (SWRLIArgument)SWRL.individual((OWLIndividual)OWL.Individual((String)"i"))));
        consequent.add(SWRL.classAtom((OWLClassExpression)OWL.Class((String)"D"), (SWRLIArgument)SWRL.individual((OWLIndividual)OWL.Individual((String)"i"))));
        SWRLRule expected = SWRL.rule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules3() {
        KnowledgeBase kb = new KnowledgeBase();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        AxiomConverter converter = new AxiomConverter(kb, df);
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl q = ATermUtils.makeTermAppl((String)"q");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl y = ATermUtils.makeVar((String)"y");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)q, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLObjectPropertyAtom> antecedent = new HashSet<SWRLObjectPropertyAtom>();
        HashSet<SWRLObjectPropertyAtom> consequent = new HashSet<SWRLObjectPropertyAtom>();
        antecedent.add(SWRL.propertyAtom((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (SWRLIArgument)SWRL.variable((String)"x"), (SWRLIArgument)SWRL.variable((String)"y")));
        consequent.add(SWRL.propertyAtom((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"q"), (SWRLIArgument)SWRL.variable((String)"x"), (SWRLIArgument)SWRL.variable((String)"y")));
        SWRLRule expected = SWRL.rule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules4() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl r = ATermUtils.makeTermAppl((String)"r");
        ATermAppl s = ATermUtils.makeTermAppl((String)"s");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl y = ATermUtils.makeVar((String)"y");
        kb.addDatatypeProperty((ATerm)r);
        kb.addDatatypeProperty((ATerm)s);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)r, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)s, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLDataPropertyAtom> antecedent = new HashSet<SWRLDataPropertyAtom>();
        HashSet<SWRLDataPropertyAtom> consequent = new HashSet<SWRLDataPropertyAtom>();
        antecedent.add(SWRL.propertyAtom((OWLDataPropertyExpression)OWL.DataProperty((String)"s"), (SWRLIArgument)SWRL.variable((String)"x"), (SWRLDArgument)SWRL.variable((String)"y")));
        consequent.add(SWRL.propertyAtom((OWLDataPropertyExpression)OWL.DataProperty((String)"r"), (SWRLIArgument)SWRL.variable((String)"x"), (SWRLDArgument)SWRL.variable((String)"y")));
        SWRLRule expected = SWRL.rule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void typeInheritanceWithAnonIndividual() throws OWLOntologyCreationException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)C, (OWLClassExpression)D), OWL.classAssertion((OWLIndividual)anon, (OWLClassExpression)C)};
        OWLOntology ont = OWL.Ontology((OWLAxiom[])axioms);
        PelletReasoner pellet = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertTrue((pellet.getInstances((OWLClassExpression)D, true).getNodes().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pellet.getInstances((OWLClassExpression)D, false).getNodes().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSubClassDirectParameter() {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)E, (OWLClassExpression)D), OWL.subClassOf((OWLClassExpression)D, (OWLClassExpression)C)};
        OWLOntology ont = OWL.Ontology((OWLAxiom[])axioms);
        PelletReasoner pellet = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertTrue((pellet.getSubClasses((OWLClassExpression)C, true).getNodes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((pellet.getSubClasses((OWLClassExpression)C, false).getNodes().size() == 3 ? 1 : 0) != 0);
    }

    private PelletReasoner setupReasonerIndividualNodeSetPolicy(IndividualNodeSetPolicy p) {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C), OWL.classAssertion((OWLIndividual)b, (OWLClassExpression)C), OWL.classAssertion((OWLIndividual)c, (OWLClassExpression)C), OWL.sameAs((OWLIndividual)a, (OWLIndividual)b), OWL.differentFrom((OWLIndividual)b, (OWLIndividual)c), OWL.differentFrom((OWLIndividual)a, (OWLIndividual)c)};
        OWLOntology ont = OWL.Ontology((OWLAxiom[])axioms);
        SimpleConfiguration config = new SimpleConfiguration((ReasonerProgressMonitor)new NullReasonerProgressMonitor(), FreshEntityPolicy.ALLOW, Long.MAX_VALUE, p);
        PelletReasoner pellet = PelletReasonerFactory.getInstance().createReasoner(ont, (OWLReasonerConfiguration)config);
        return pellet;
    }

    @Test
    public void testIndividualNodeSetPolicyBySameAs() {
        PelletReasoner pellet = this.setupReasonerIndividualNodeSetPolicy(IndividualNodeSetPolicy.BY_SAME_AS);
        Assert.assertTrue((pellet.getInstances((OWLClassExpression)C, true).getNodes().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((pellet.getDifferentIndividuals(c).getNodes().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testIndividualNodeSetPolicyByName() {
        PelletReasoner pellet = this.setupReasonerIndividualNodeSetPolicy(IndividualNodeSetPolicy.BY_NAME);
        Assert.assertTrue((pellet.getInstances((OWLClassExpression)C, true).getNodes().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((pellet.getDifferentIndividuals(c).getNodes().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testTopBottomPropertyAssertion() throws OWLOntologyCreationException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)OWL.topObjectProperty, (OWLIndividual)b), OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)OWL.topDataProperty, (OWLLiteral)lit), OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)OWL.bottomObjectProperty, (OWLIndividual)b), OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)OWL.bottomDataProperty, (OWLLiteral)lit)};
        for (int i = 0; i < axioms.length; ++i) {
            OWLOntology ont = OWL.Ontology((OWLAxiom[])new OWLAxiom[]{axioms[i]});
            PelletReasoner pellet = PelletReasonerFactory.getInstance().createReasoner(ont);
            Assert.assertEquals((Object)(i < 2 ? 1 : 0), (Object)pellet.isConsistent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopBottomPropertyInferences() throws OWLOntologyCreationException {
        boolean prevValue = PelletOptions.HIDE_TOP_PROPERTY_VALUES;
        PelletOptions.HIDE_TOP_PROPERTY_VALUES = false;
        try {
            this.createReasoner(new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b), OWL.classAssertion((OWLIndividual)c, (OWLClassExpression)C), OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)dp, (OWLLiteral)lit)});
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.subPropertyOf((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)OWL.topObjectProperty)));
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.subPropertyOf((OWLObjectPropertyExpression)OWL.bottomObjectProperty, (OWLObjectPropertyExpression)p)));
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.subPropertyOf((OWLDataPropertyExpression)dp, (OWLDataPropertyExpression)OWL.topDataProperty)));
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.subPropertyOf((OWLDataPropertyExpression)OWL.bottomDataProperty, (OWLDataPropertyExpression)dp)));
            Assert.assertEquals(Collections.singleton(p), (Object)this.reasoner.getSubObjectProperties((OWLObjectPropertyExpression)OWL.topObjectProperty, true).getFlattened());
            Assert.assertEquals(Collections.singleton(OWL.bottomObjectProperty), (Object)this.reasoner.getSubObjectProperties((OWLObjectPropertyExpression)p, true).getFlattened());
            Assert.assertEquals(Collections.singleton(dp), (Object)this.reasoner.getSubDataProperties(OWL.topDataProperty, true).getFlattened());
            Assert.assertEquals(Collections.singleton(OWL.bottomDataProperty), (Object)this.reasoner.getSubDataProperties(dp, true).getFlattened());
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b)));
            Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)b, (OWLObjectPropertyExpression)p, (OWLIndividual)a)));
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)OWL.topObjectProperty, (OWLIndividual)b)));
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)b, (OWLObjectPropertyExpression)OWL.topObjectProperty, (OWLIndividual)a)));
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)dp, (OWLLiteral)lit)));
            Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)b, (OWLDataPropertyExpression)dp, (OWLLiteral)lit)));
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)OWL.topDataProperty, (OWLLiteral)lit)));
            Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)b, (OWLDataPropertyExpression)OWL.topDataProperty, (OWLLiteral)lit)));
            OWLAPIv3Tests.assertPropertyValues(this.reasoner, a, p, new OWLIndividual[]{b});
            Assert.assertTrue((boolean)this.reasoner.getObjectPropertyValues(b, (OWLObjectPropertyExpression)p).getFlattened().isEmpty());
            OWLAPIv3Tests.assertPropertyValues(this.reasoner, a, OWL.topObjectProperty, new OWLIndividual[]{a, b, c});
            OWLAPIv3Tests.assertPropertyValues(this.reasoner, b, OWL.topObjectProperty, new OWLIndividual[]{a, b, c});
            OWLAPIv3Tests.assertPropertyValues(this.reasoner, a, OWL.topDataProperty, lit);
            OWLAPIv3Tests.assertPropertyValues(this.reasoner, b, OWL.topDataProperty, lit);
        }
        finally {
            PelletOptions.HIDE_TOP_PROPERTY_VALUES = prevValue;
        }
    }

    @Ignore
    @Test
    public void testSetTheory() throws OWLException {
        String ns = "http://www.integratedmodelling.org/ks/tarassandbox/set-theory.owl#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "set-theory.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        reasoner.getKB().classify();
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{OWL.Class((String)(ns + "SetOfXSets")), OWL.Class((String)(ns + "XSet")), OWL.Class((String)(ns + "XThing"))}), (Object)reasoner.getSubClasses((OWLClassExpression)OWL.Class((String)(ns + "XSetTheoryClass")), true).getFlattened());
    }

    @Test
    public void datatypeDefinition() {
        OWLDatatype between5and10 = OWL.Datatype((String)"between5and10");
        OWLDatatype between6and8 = OWL.Datatype((String)"between6and8");
        this.createReasoner(new OWLAxiom[]{OWL.datatypeDefinition((OWLDatatype)between5and10, (OWLDataRange)OWL.restrict((OWLDatatype)XSD.INTEGER, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.minInclusive((int)5), OWL.maxInclusive((int)10)})), OWL.datatypeDefinition((OWLDatatype)between6and8, (OWLDataRange)OWL.restrict((OWLDatatype)XSD.INTEGER, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.minInclusive((int)6), OWL.maxInclusive((int)8)})), OWL.equivalentClasses((OWLClassExpression)A, (OWLClassExpression)OWL.some((OWLDataPropertyExpression)dp, (OWLDataRange)between5and10)), OWL.equivalentClasses((OWLClassExpression)B, (OWLClassExpression)OWL.some((OWLDataPropertyExpression)dp, (OWLDataRange)between6and8)), OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)dp, (OWLLiteral)OWL.constant((int)9)), OWL.propertyAssertion((OWLIndividual)b, (OWLDataPropertyExpression)dp, (OWLLiteral)OWL.constant((int)7))});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.subClassOf((OWLClassExpression)B, (OWLClassExpression)A)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)A)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)B)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)b, (OWLClassExpression)A)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)b, (OWLClassExpression)B)));
    }

    @Test
    public void dataRangeEntailment() {
        this.createReasoner(new OWLAxiom[]{OWL.range((OWLDataPropertyExpression)dp, (OWLDataRange)XSD.INT)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.range((OWLDataPropertyExpression)dp, (OWLDataRange)XSD.INT)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.range((OWLDataPropertyExpression)dp, (OWLDataRange)XSD.INTEGER)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.range((OWLDataPropertyExpression)dp, (OWLDataRange)XSD.FLOAT)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.range((OWLDataPropertyExpression)dp, (OWLDataRange)XSD.STRING)));
    }

    @Test
    public void test149() throws OWLOntologyCreationException {
        this.createReasoner(new OWLAxiom[]{OWL.inverseProperties((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)q)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.equivalentProperties((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)q))));
    }

    @Test
    public void test150_1() {
        this.createReasoner(new OWLAxiom[]{OWL.disjointProperties((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)q))});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)q))));
    }

    @Test
    public void test150_2() {
        this.createReasoner(new OWLAxiom[]{OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)C), OWL.range((OWLObjectPropertyExpression)q, (OWLClassExpression)D), OWL.disjointClasses((OWLClassExpression)C, (OWLClassExpression)D)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)q))));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)p), (OWLObjectPropertyExpression)q)));
    }

    @Test
    public void testBooleanDatatypeConstructors() {
        OWLDatatype nni = XSD.NON_NEGATIVE_INTEGER;
        OWLDatatype npi = XSD.NON_POSITIVE_INTEGER;
        OWLDatatype ni = XSD.NEGATIVE_INTEGER;
        OWLDatatype pi = XSD.POSITIVE_INTEGER;
        OWLDatatype f = XSD.FLOAT;
        OWLDatatype i = XSD.INTEGER;
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)nni), OWL.declaration((OWLEntity)npi), OWL.declaration((OWLEntity)ni), OWL.declaration((OWLEntity)pi), OWL.declaration((OWLEntity)f), OWL.declaration((OWLEntity)dq), OWL.range((OWLDataPropertyExpression)dp, (OWLDataRange)OWL.dataAnd((OWLDataRange[])new OWLDataRange[]{pi, ni}))});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)pi)));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)OWL.dataNot((OWLDataRange)pi))));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)OWL.dataAnd((OWLDataRange[])new OWLDataRange[]{pi, ni}))));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)OWL.dataAnd((OWLDataRange[])new OWLDataRange[]{f, OWL.dataOr((OWLDataRange[])new OWLDataRange[]{pi, ni})}))));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)OWL.dataAnd((OWLDataRange[])new OWLDataRange[]{npi, ni}))));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)OWL.dataAnd((OWLDataRange[])new OWLDataRange[]{nni, pi}))));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)OWL.dataOr((OWLDataRange[])new OWLDataRange[]{nni, npi}))));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)OWL.dataAnd((OWLDataRange[])new OWLDataRange[]{nni, npi}))));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dq, (OWLDataRange)OWL.dataAnd((OWLDataRange[])new OWLDataRange[]{pi, OWL.restrict((OWLDatatype)i, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.maxExclusive((int)0)})}))));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable((OWLClassExpression)OWL.some((OWLDataPropertyExpression)dp, (OWLDataRange)XSD.ANY_TYPE)));
    }

    @Test
    public void testGetEquivalentClasses() {
        this.createReasoner(new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)A, (OWLClassExpression)B), OWL.equivalentClasses((OWLClassExpression)B, (OWLClassExpression)C)});
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A, B, C}), (Object)this.reasoner.getEquivalentClasses((OWLClassExpression)A).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A, B, C}), (Object)this.reasoner.getEquivalentClasses((OWLClassExpression)B).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A, B, C}), (Object)this.reasoner.getEquivalentClasses((OWLClassExpression)C).getEntities());
    }

    @Test
    public void testGetEquivalentObjectProperties() {
        this.createReasoner(new OWLAxiom[]{OWL.equivalentProperties((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)q), OWL.equivalentProperties((OWLObjectPropertyExpression)q, (OWLObjectPropertyExpression)r)});
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLObjectProperty[]{p, q, r}), (Object)this.reasoner.getEquivalentObjectProperties((OWLObjectPropertyExpression)p).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLObjectProperty[]{p, q, r}), (Object)this.reasoner.getEquivalentObjectProperties((OWLObjectPropertyExpression)q).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLObjectProperty[]{p, q, r}), (Object)this.reasoner.getEquivalentObjectProperties((OWLObjectPropertyExpression)r).getEntities());
    }

    @Test
    public void testGetEquivalentDataProperties() {
        this.createReasoner(new OWLAxiom[]{OWL.equivalentDataProperties((OWLDataPropertyExpression)dp, (OWLDataPropertyExpression)dq), OWL.equivalentDataProperties((OWLDataPropertyExpression)dq, (OWLDataPropertyExpression)dr)});
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLDataProperty[]{dp, dq, dr}), (Object)this.reasoner.getEquivalentDataProperties(dp).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLDataProperty[]{dp, dq, dr}), (Object)this.reasoner.getEquivalentDataProperties(dq).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLDataProperty[]{dp, dq, dr}), (Object)this.reasoner.getEquivalentDataProperties(dr).getEntities());
    }

    @Test
    public void testGetUnsatClasses() {
        this.createReasoner(new OWLAxiom[]{OWL.disjointClasses((OWLClassExpression)A, (OWLClassExpression)B), OWL.equivalentClasses((OWLClassExpression)C, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{A, B}))});
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{C, OWL.Nothing}), (Object)this.reasoner.getUnsatisfiableClasses().getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{C, OWL.Nothing}), (Object)this.reasoner.getEquivalentClasses((OWLClassExpression)C).getEntities());
    }

    @Test
    public void test454() {
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "ticket-454-test-case.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertFalse((boolean)reasoner.isConsistent());
    }

    @Test
    public void test456() {
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "ticket-456-test-case.owl"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
        Assert.assertTrue((boolean)reasoner.isConsistent());
    }

    @Test
    public void testDataDomainWithEquivalents() {
        this.createReasoner(new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)A, (OWLClassExpression)OWL.min((OWLDataPropertyExpression)dp, (int)1)), OWL.domain((OWLDataPropertyExpression)dp, (OWLClassExpression)A), OWL.subClassOf((OWLClassExpression)A, (OWLClassExpression)B)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.domain((OWLDataPropertyExpression)dp, (OWLClassExpression)A)));
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A}), (Object)this.reasoner.getDataPropertyDomains(dp, true).getFlattened());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A, B, OWL.Thing}), (Object)this.reasoner.getDataPropertyDomains(dp, false).getFlattened());
    }

    @Test
    public void testDataDomainWithSubClasses() {
        this.createReasoner(new OWLAxiom[]{OWL.domain((OWLDataPropertyExpression)dp, (OWLClassExpression)A), OWL.subClassOf((OWLClassExpression)A, (OWLClassExpression)B)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.domain((OWLDataPropertyExpression)dp, (OWLClassExpression)A)));
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A}), (Object)this.reasoner.getDataPropertyDomains(dp, true).getFlattened());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A, B, OWL.Thing}), (Object)this.reasoner.getDataPropertyDomains(dp, false).getFlattened());
    }

    @Test
    public void testObjecDomainWithEquivalents() {
        this.createReasoner(new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)A, (OWLClassExpression)OWL.min((OWLObjectPropertyExpression)p, (int)1)), OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)A), OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)C), OWL.subClassOf((OWLClassExpression)A, (OWLClassExpression)B)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)A)));
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A}), (Object)this.reasoner.getObjectPropertyDomains((OWLObjectPropertyExpression)p, true).getFlattened());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A, B, C, OWL.Thing}), (Object)this.reasoner.getObjectPropertyDomains((OWLObjectPropertyExpression)p, false).getFlattened());
    }

    @Test
    public void testObjectDomainWithSubClasses() {
        this.createReasoner(new OWLAxiom[]{OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)A), OWL.subClassOf((OWLClassExpression)A, (OWLClassExpression)B)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)A)));
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A}), (Object)this.reasoner.getObjectPropertyDomains((OWLObjectPropertyExpression)p, true).getFlattened());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{A, B, OWL.Thing}), (Object)this.reasoner.getObjectPropertyDomains((OWLObjectPropertyExpression)p, false).getFlattened());
    }

    @Test
    public void testObjectRangeWithEquivalents() {
        this.createReasoner(new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)C, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)p), (OWLClassExpression)OWL.Thing)), OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)D), OWL.subClassOf((OWLClassExpression)C, (OWLClassExpression)E)});
        this.reasoner.getKB().printClassTree();
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)C)));
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{C}), (Object)this.reasoner.getEquivalentClasses((OWLClassExpression)OWL.some((OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)p), (OWLClassExpression)OWL.Thing)).getEntities());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{C}), (Object)this.reasoner.getObjectPropertyRanges((OWLObjectPropertyExpression)p, true).getFlattened());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{C, D, E, OWL.Thing}), (Object)this.reasoner.getObjectPropertyRanges((OWLObjectPropertyExpression)p, false).getFlattened());
    }

    @Test
    public void testObjectRangeWithSubClasses() {
        this.createReasoner(new OWLAxiom[]{OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)A), OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)C), OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)D), OWL.subClassOf((OWLClassExpression)C, (OWLClassExpression)E)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)C)));
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{C, D}), (Object)this.reasoner.getObjectPropertyRanges((OWLObjectPropertyExpression)p, true).getFlattened());
        Assert.assertEquals((Object)SetUtils.create((Object[])new OWLClass[]{C, D, E, OWL.Thing}), (Object)this.reasoner.getObjectPropertyRanges((OWLObjectPropertyExpression)p, false).getFlattened());
    }

    @Test
    public void testQuotedLiteral() {
        OWLLiteral literal = OWL.constant((String)"\"test\"");
        this.createReasoner(new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)dp, (OWLLiteral)literal)});
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)dp, (OWLLiteral)literal)));
        Assert.assertEquals(Collections.singleton(literal), (Object)this.reasoner.getDataPropertyValues(a, dp));
    }

    @Test
    public void testComplementRemoval() throws OWLException {
        String ns = "http://test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(MiscTests.base + "ticket539.ofn"));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createNonBufferingReasoner(ont);
        Assert.assertFalse((boolean)reasoner.isConsistent());
        OWL.manager.removeAxiom(ont, (OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.Class((String)(ns + "a_GROUP")), (OWLClassExpression)OWL.Class((String)(ns + "a_TEMPORALTHING"))));
        Assert.assertFalse((boolean)reasoner.isConsistent());
        OWL.manager.removeAxiom(ont, (OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.Class((String)(ns + "a_INDIVIDUAL")), (OWLClassExpression)OWL.not((OWLClassExpression)OWL.Class((String)(ns + "a_SETORCOLLECTION")))));
        Assert.assertFalse((boolean)reasoner.isConsistent());
    }

    public static class TimedProgressMonitor
    extends ConsoleProgressMonitor {
        private final int limit;

        public TimedProgressMonitor(int limit) {
            this.limit = limit;
        }

        public void taskFinished() {
            super.taskFinished();
        }

        public void taskStarted() {
            super.taskStarted();
        }

        public boolean isCanceled() {
            long elapsedTime = this.timer.getElapsed();
            return elapsedTime > (long)this.limit;
        }
    }
}

