/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetUtils {
    private static final Logger log = Logger.getLogger(ResultSetUtils.class.getName());
    private static final RDFNode DUMMY_FOR_BNODE = ResourceFactory.createPlainLiteral((String)"dummy node for bnode");

    public static boolean assertEquals(ResultSet expectedResults, ResultSet computedResults) {
        ResultSetRewindable expected = ResultSetFactory.makeRewindable((ResultSet)expectedResults);
        ResultSetRewindable computed = ResultSetFactory.makeRewindable((ResultSet)computedResults);
        System.out.println("Computed: " + computed.size() + " Expected: " + expected.size());
        if (expected.size() != computed.size()) {
            ResultSetUtils.logResults("Expected", expected);
            ResultSetUtils.logResults("Real", computed);
            Assert.fail((String)("Expected " + expected.size() + " but got " + computed.size()));
        }
        List vars = expected.getResultVars();
        Collection<Map<String, RDFNode>> results = ResultSetUtils.results(computed);
        expected.reset();
        while (expected.hasNext()) {
            QuerySolution qs = expected.nextSolution();
            Map<String, RDFNode> map = ResultSetUtils.solutionMap(qs, vars);
            if (results.contains(map)) continue;
            ResultSetUtils.logResults("Expected", expected);
            ResultSetUtils.logResults("Real", computed);
            Assert.fail((String)("Solution not found: " + map));
            Assert.fail((String)("Expected " + expected.size() + " but got " + computed.size()));
        }
        return true;
    }

    public static Map<String, RDFNode> solutionMap(QuerySolution qs, List<String> vars) {
        HashMap<String, RDFNode> result = new HashMap<String, RDFNode>();
        Iterator<String> i$ = vars.iterator();
        while (i$.hasNext()) {
            String var;
            RDFNode val = qs.get(var = i$.next());
            result.put(var, val.isAnon() ? DUMMY_FOR_BNODE : val);
        }
        return result;
    }

    public static Collection<Map<String, RDFNode>> results(ResultSetRewindable rs) {
        rs.reset();
        List vars = rs.getResultVars();
        HashSet<Map<String, RDFNode>> results = new HashSet<Map<String, RDFNode>>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            HashMap<String, RDFNode> result = new HashMap<String, RDFNode>();
            for (String var : vars) {
                result.put(var, qs.get(var));
            }
            results.add(ResultSetUtils.solutionMap(qs, vars));
        }
        return results;
    }

    public static void logResults(String name, ResultSetRewindable results) {
        if (log.isLoggable(Level.WARNING)) {
            log.warning(name + " (" + results.size() + ")");
            results.reset();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ResultSetFormatter.output((OutputStream)out, (ResultSet)results, (ResultsFormat)ResultsFormat.FMT_TEXT);
            log.warning("\n" + out.toString());
        }
    }
}

