/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.clarkparsia.pellet.test.query.ARQSparqlDawgTester;
import com.clarkparsia.pellet.test.query.ManifestEngine;
import com.clarkparsia.pellet.test.query.ManifestEngineProcessor;
import com.clarkparsia.pellet.test.query.PelletSparqlDawgTester;
import com.clarkparsia.pellet.test.query.SparqlDawgTestCase;
import com.clarkparsia.pellet.test.query.SparqlDawgTester;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.mindswap.pellet.test.PelletTestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparqlDawgTestSuite
extends TestSuite {
    private static String getName(String manifestName) {
        String name = manifestName;
        try {
            URI uri = URI.create(manifestName);
            String[] pathComponents = uri.getPath().split("/");
            name = pathComponents[pathComponents.length - 2];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    private static TestSuite addSuite(final TestSuite root, String manifest, final Map<SparqlDawgTester, Properties> testers) {
        final ManifestEngine engine = new ManifestEngine(null, manifest);
        engine.setProcessor(new ManifestEngineProcessor(){
            TestSuite current;
            final Map<TestSuite, TestSuite> map;
            {
                this.current = root;
                this.map = new HashMap<TestSuite, TestSuite>();
            }

            public void manifestStarted(String manifestName) {
                TestSuite newSuite = new TestSuite(SparqlDawgTestSuite.getName(manifestName));
                this.map.put(newSuite, this.current);
                this.current.addTest((Test)newSuite);
                this.current = newSuite;
            }

            public void test(Resource test) {
                for (Map.Entry entry : testers.entrySet()) {
                    SparqlDawgTester tester = (SparqlDawgTester)entry.getKey();
                    Properties options = (Properties)entry.getValue();
                    this.current.addTest((Test)new SparqlDawgTestCase(tester, engine, test, options));
                }
            }

            public void manifestFinished(String manifestName) {
                this.current = this.map.get(this.current);
            }
        });
        engine.run();
        return root;
    }

    public static TestSuite suite() {
        return new SparqlDawgTestSuite();
    }

    public SparqlDawgTestSuite() {
        super(SparqlDawgTestCase.class.toString());
        ARQSparqlDawgTester arqTester = new ARQSparqlDawgTester();
        PelletSparqlDawgTester basicSparqlDLTester = new PelletSparqlDawgTester(SparqlDLExecutionFactory.QueryEngineType.PELLET, false);
        PelletSparqlDawgTester integratedSparqlDLTester = new PelletSparqlDawgTester(SparqlDLExecutionFactory.QueryEngineType.MIXED, false);
        String sparqldlTests = PelletTestSuite.base + "sparqldl-tests/manifest.ttl";
        String sparqlSameAsTests = PelletTestSuite.base + "query/sameAs/manifest.ttl";
        Properties noUndistVars = new Properties();
        noUndistVars.setProperty("IGNORE_UNSUPPORTED_AXIOMS", "false");
        noUndistVars.setProperty("TREAT_ALL_VARS_DISTINGUISHED", "true");
        Properties undistVars = new Properties();
        undistVars.setProperty("IGNORE_UNSUPPORTED_AXIOMS", "false");
        undistVars.setProperty("TREAT_ALL_VARS_DISTINGUISHED", "false");
        HashMap<ARQSparqlDawgTester, Properties> dawgTesters = new HashMap<ARQSparqlDawgTester, Properties>();
        dawgTesters.put(arqTester, noUndistVars);
        dawgTesters.put(basicSparqlDLTester, noUndistVars);
        dawgTesters.put(integratedSparqlDLTester, noUndistVars);
        HashMap<SparqlDawgTester, Properties> sparqldlTesters = new HashMap<SparqlDawgTester, Properties>();
        sparqldlTesters.put(basicSparqlDLTester, undistVars);
        sparqldlTesters.put(integratedSparqlDLTester, undistVars);
        SparqlDawgTestSuite.addSuite(this, sparqldlTests, sparqldlTesters);
        HashMap<SparqlDawgTester, Properties> sparqlSameAsTesters = new HashMap<SparqlDawgTester, Properties>();
        sparqlSameAsTesters.put(basicSparqlDLTester, undistVars);
        SparqlDawgTestSuite.addSuite(this, sparqlSameAsTests, sparqlSameAsTesters);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SparqlDawgTestSuite.suite());
    }
}

