/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.tbox;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Before;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class TBoxTests
extends AbstractKBTests {
    private TBox tbox;

    public static Test suite() {
        return new JUnit4TestAdapter(TBoxTests.class);
    }

    @Before
    public void initializeKB() {
        super.initializeKB();
        this.tbox = this.kb.getTBox();
    }

    private void prepareTBox() {
        this.tbox.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void removedByAbsorbReaddedOnChange() {
        boolean oldTracing = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        try {
            this.classes(A, B, C, D);
            ATermAppl axiom1 = ATermUtils.makeEqClasses((ATerm)A, (ATerm)ATermUtils.makeOr((ATermAppl)C, (ATermAppl)D));
            Assert.assertTrue((boolean)this.tbox.addAxiom(axiom1));
            ATermAppl axiom2 = ATermUtils.makeSub((ATerm)A, (ATerm)B);
            Assert.assertTrue((boolean)this.tbox.addAxiom(axiom2));
            Unfolding unfoldForAxiom2 = Unfolding.create((ATermAppl)B, Collections.singleton(axiom2));
            this.prepareTBox();
            Assert.assertFalse((boolean)IteratorUtils.toSet((Iterator)this.tbox.unfold(A)).contains(unfoldForAxiom2));
            this.tbox.removeAxiom(axiom1);
            this.prepareTBox();
            Assert.assertTrue((boolean)IteratorUtils.toSet((Iterator)this.tbox.unfold(A)).contains(unfoldForAxiom2));
        }
        finally {
            PelletOptions.USE_TRACING = oldTracing;
        }
    }

    @org.junit.Test
    public void assertedAxioms() {
        this.classes(A, B, C, D);
        ATermAppl axiom = ATermUtils.makeSub((ATerm)ATermUtils.makeAnd((ATerm)A, (ATerm)B), (ATerm)ATermUtils.makeNot((ATerm)B));
        this.tbox.addAxiom(axiom);
        this.prepareTBox();
        Assert.assertTrue((this.tbox.getAxioms().size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.tbox.getAxioms().contains(axiom));
        Assert.assertEquals(Collections.singleton(axiom), (Object)this.tbox.getAssertedAxioms());
    }

    @org.junit.Test
    public void binaryAbsorption() {
        ATermAppl SPECIALCLIENT = TermFactory.term((String)"SPECIALCLIENT");
        ATermAppl CLIENT = TermFactory.term((String)"CLIENT");
        ATermAppl EXPENSIVE = TermFactory.term((String)"EXPENSIVE");
        ATermAppl PROFITABLE = TermFactory.term((String)"PROFITABLE");
        ATermAppl TRUSTEDCLIENT = TermFactory.term((String)"TRUSTEDCLIENT");
        ATermAppl Recommend = TermFactory.term((String)"Recommend");
        ATermAppl Buy = TermFactory.term((String)"Buy");
        this.classes(SPECIALCLIENT, CLIENT, EXPENSIVE, PROFITABLE, TRUSTEDCLIENT);
        this.objectProperties(Buy, Recommend);
        this.tbox.addAxiom(ATermUtils.makeSub((ATerm)SPECIALCLIENT, (ATerm)TRUSTEDCLIENT));
        this.tbox.addAxiom(ATermUtils.makeEqClasses((ATerm)SPECIALCLIENT, (ATerm)TermFactory.and((ATermAppl[])new ATermAppl[]{CLIENT, TermFactory.some((ATermAppl)Buy, (ATermAppl)TermFactory.or((ATermAppl)EXPENSIVE, (ATermAppl)PROFITABLE)), TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)Recommend), (ATermAppl)TRUSTEDCLIENT)})));
        this.prepareTBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void removeAssertedAxioms() {
        boolean oldTracing = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        try {
            this.classes(A, B, C, D);
            ATermAppl axiom = ATermUtils.makeSub((ATerm)ATermUtils.makeAnd((ATerm)A, (ATerm)B), (ATerm)ATermUtils.makeNot((ATerm)B));
            this.tbox.addAxiom(axiom);
            this.prepareTBox();
            this.tbox.removeAxiom(axiom);
            this.prepareTBox();
            Assert.assertTrue((boolean)this.tbox.getAxioms().isEmpty());
            Assert.assertTrue((boolean)this.tbox.getAssertedAxioms().isEmpty());
        }
        finally {
            PelletOptions.USE_TRACING = oldTracing;
        }
    }
}

