/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToTopPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class EquivalentToTopPatternTest
extends PellintTestCase {
    private EquivalentToTopPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new EquivalentToTopPattern();
    }

    @Test
    public void testNone() throws OWLException {
        Assert.assertTrue((boolean)this.m_Pattern.isFixable());
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLClassExpression[]{OWL.Nothing, this.m_Cls[2], this.m_Cls[3]}));
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.subClassOf((OWLClassExpression)OWL.Thing, (OWLClassExpression)this.m_Cls[1]);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testSimple() throws OWLException {
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLClassExpression[]{OWL.Thing, this.m_Cls[0], this.m_Cls[1]}));
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        LintFixer fixer = lint.getLintFixer();
        Assert.assertTrue((boolean)fixer.getAxiomsToRemove().contains(axiom));
        Assert.assertTrue((boolean)fixer.getAxiomsToAdd().isEmpty());
        Assert.assertNull((Object)lint.getSeverity());
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }
}

