/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.LargeDisjunctionPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.test.PellintTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class LargeDisjunctionPatternTest
extends PellintTestCase {
    private LargeDisjunctionPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new LargeDisjunctionPattern();
    }

    @Test
    public void testNone() throws OWLException {
        this.m_Pattern.setMaxAllowed(3);
        OWLObjectUnionOf union = OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[1], OWL.Thing, OWL.Nothing});
        OWLSubClassOfAxiom axiom = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)union);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        Assert.assertFalse((boolean)this.m_Pattern.isFixable());
    }

    @Test
    public void testSimple() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectUnionOf union = OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]});
        OWLSubClassOfAxiom axiom = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)union);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        Assert.assertSame((Object)this.m_Pattern, (Object)lint.getPattern());
        Assert.assertEquals((long)1L, (long)lint.getParticipatingAxioms().size());
        Assert.assertNull((Object)lint.getLintFixer());
        Assert.assertEquals((double)3.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testDisjointClasses() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectUnionOf union = OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]});
        OWLDisjointClassesAxiom axiom = OWL.disjointClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)union);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testNested1() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectUnionOf union = OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]});
        OWLObjectAllValuesFrom all = OWL.all((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)union);
        OWLObjectIntersectionOf and = OWL.and((OWLClassExpression[])new OWLClassExpression[]{all, this.m_Cls[4]});
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLClassExpression)and, (OWLClassExpression)this.m_Cls[0]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testNested2() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectUnionOf union1 = OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]});
        OWLObjectAllValuesFrom all = OWL.all((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)union1);
        OWLObjectUnionOf union2 = OWL.or((OWLClassExpression[])new OWLClassExpression[]{all, this.m_Cls[4]});
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLClassExpression)union2, (OWLClassExpression)this.m_Cls[0]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }
}

