/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.ontology;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.lintpattern.ontology.EquivalentAndSubclassAxiomPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class EquivalentAndSubclassAxiomPatternTest
extends PellintTestCase {
    private EquivalentAndSubclassAxiomPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new EquivalentAndSubclassAxiomPattern();
    }

    @Test
    public void testNone1() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0AllC0));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_Cls[1]));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)this.m_Cls[2]));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)this.m_Cls[3]));
        Assert.assertTrue((boolean)this.m_Pattern.isFixable());
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
    }

    @Test
    public void testNone2() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0AllC0));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_Cls[1]));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.Thing));
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
    }

    @Test
    public void testNone3() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0AllC0));
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
    }

    @Test
    public void testEquivalentWithOneDescription() throws OWLException {
        OWLObjectMinCardinality min = OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)2, (OWLClassExpression)this.m_Cls[1]);
        OWLEquivalentClassesAxiom badAxiom = OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)min);
        this.addAxiom((OWLAxiom)badAxiom);
        OWLSubClassOfAxiom fixedAxiom = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)min);
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0AllC0));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.Thing));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLClassExpression[]{this.m_Cls[0], this.m_Cls[3], this.m_Cls[4]})));
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
        Lint lint = (Lint)lints.get(0);
        Set participatingClasses = lint.getParticipatingClasses();
        Assert.assertEquals((long)1L, (long)participatingClasses.size());
        Assert.assertTrue((boolean)participatingClasses.contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        Set axiomsToRemove = fixer.getAxiomsToRemove();
        Set axiomsToAdd = fixer.getAxiomsToAdd();
        Assert.assertEquals((long)1L, (long)axiomsToRemove.size());
        Assert.assertTrue((boolean)axiomsToRemove.contains(badAxiom));
        Assert.assertEquals((long)1L, (long)axiomsToAdd.size());
        Assert.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom));
        Assert.assertNull((Object)lint.getSeverity());
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testEquivalentWithManyDescriptions() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0SomeC1));
        OWLClassExpression exactly = OWL.exactly((OWLObjectProperty)this.m_Pro[1], (int)2, (OWLClassExpression)this.m_Cls[2]);
        OWLEquivalentClassesAxiom badAxiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLClassExpression[]{this.m_Cls[0], this.m_Cls[3], this.m_Cls[4], exactly}));
        this.addAxiom((OWLAxiom)badAxiom);
        Set restOf = CollectionUtil.asSet((Object[])new OWLClassExpression[]{this.m_Cls[3], this.m_Cls[4], exactly});
        OWLEquivalentClassesAxiom fixedAxiom1 = OWL.equivalentClasses((Set)restOf);
        OWLSubClassOfAxiom fixedAxiom2 = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.and((Set)restOf));
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
        LintFixer fixer = ((Lint)lints.get(0)).getLintFixer();
        Set axiomsToRemove = fixer.getAxiomsToRemove();
        Set axiomsToAdd = fixer.getAxiomsToAdd();
        Assert.assertEquals((long)1L, (long)axiomsToRemove.size());
        Assert.assertTrue((boolean)axiomsToRemove.contains(badAxiom));
        Assert.assertEquals((long)2L, (long)axiomsToAdd.size());
        Assert.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom1));
        Assert.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom2));
    }

    @Test
    public void testOneOf() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0AllC0));
        OWLObjectOneOf oneOf = OWL.oneOf((OWLIndividual[])this.m_Ind);
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLClassExpression[]{this.m_Cls[0], this.m_Cls[1], oneOf})));
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
    }

    @Test
    public void testOnlyEquivalences() throws OWLException {
        OWLEquivalentClassesAxiom badAxiom1 = OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0AllC0);
        OWLSubClassOfAxiom fixedAxiom1 = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0AllC0);
        OWLEquivalentClassesAxiom badAxiom2 = OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0SomeC1);
        OWLSubClassOfAxiom fixedAxiom2 = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)this.m_P0SomeC1);
        this.addAxiom((OWLAxiom)badAxiom1);
        this.addAxiom((OWLAxiom)badAxiom2);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
        Lint lint = (Lint)lints.get(0);
        Set participatingClasses = lint.getParticipatingClasses();
        Assert.assertEquals((long)1L, (long)participatingClasses.size());
        Assert.assertTrue((boolean)participatingClasses.contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        Set axiomsToRemove = fixer.getAxiomsToRemove();
        Set axiomsToAdd = fixer.getAxiomsToAdd();
        Assert.assertEquals((long)2L, (long)axiomsToRemove.size());
        Assert.assertTrue((boolean)axiomsToRemove.contains(badAxiom1));
        Assert.assertTrue((boolean)axiomsToRemove.contains(badAxiom2));
        Assert.assertEquals((long)2L, (long)axiomsToAdd.size());
        Assert.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom1));
        Assert.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom2));
    }
}

