/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.model;

import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.test.lintpattern.MockLintPattern;
import com.clarkparsia.pellint.test.model.MockLintFixer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class LintTest
extends PellintTestCase {
    private LintPattern m_MockPattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_MockPattern = new MockLintPattern();
    }

    @Test
    public void testWithoutFixer() throws OWLOntologyChangeException {
        Lint lint = new Lint(this.m_MockPattern, this.m_Ontology);
        Assert.assertSame((Object)this.m_MockPattern, (Object)lint.getPattern());
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
        Assert.assertFalse((boolean)lint.applyFix(this.m_Manager));
    }

    @Test
    public void testWithFixer() throws OWLOntologyChangeException {
        Lint lint = new Lint(this.m_MockPattern, this.m_Ontology);
        MockLintFixer fixer = new MockLintFixer();
        lint.setLintFixer((LintFixer)fixer);
        Assert.assertTrue((boolean)lint.applyFix(this.m_Manager));
        Assert.assertTrue((boolean)fixer.applyCalled);
    }
}

