/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.util;

import com.clarkparsia.owlapiv3.OWL;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;

public class OWL2DLProfileViolationsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrectOntology() throws OWLOntologyCreationException {
        OWLOntology ontology = OWL.manager.loadOntologyFromOntologyDocument(new File("test/data/misc/agencies.owl"));
        try {
            OWL2DLProfile owl2Profile = new OWL2DLProfile();
            Assert.assertTrue((boolean)owl2Profile.checkOntology(ontology).isInProfile());
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuperPropertyTopDataProperty() throws OWLOntologyCreationException {
        OWLOntology ontology = OWL.manager.createOntology();
        try {
            OWLDataProperty property = OWL.factory.getOWLDataProperty(IRI.create((String)"tag:clarkparsia.com,2008:pellint:test:superProperty"));
            OWLDataProperty topProperty = OWL.factory.getOWLTopDataProperty();
            OWLSubDataPropertyOfAxiom axiom = OWL.factory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)topProperty, (OWLDataPropertyExpression)property);
            OWL.manager.addAxiom(ontology, (OWLAxiom)axiom);
            OWL2DLProfile owl2Profile = new OWL2DLProfile();
            Assert.assertFalse((boolean)owl2Profile.checkOntology(ontology).isInProfile());
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidTransitivity() throws OWLOntologyCreationException {
        OWLOntology ontology = OWL.manager.loadOntologyFromOntologyDocument(new File("test/data/misc/invalidTransitivity.owl"));
        try {
            OWL2DLProfile owl2Profile = new OWL2DLProfile();
            Assert.assertFalse((boolean)owl2Profile.checkOntology(ontology).isInProfile());
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }
}

