/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.sparqlowl.parser.test;

import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.clarkparsia.sparqlowl.parser.arq.ARQTerpParser;
import com.clarkparsia.sparqlowl.parser.arq.TerpSyntax;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class ParserTest {
    public static final String base = PelletTestSuite.base + "/sparqldl-tests/simple/";
    private static ARQParser parser;
    private final String kbFile;
    private KnowledgeBase kb;
    private final String sparqlFile;
    private final String sparqlOWLFile;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        ParserTest.addParameter(parameters, "simple", 1, 8, 6);
        ParserTest.addParameter(parameters, "parent", 1, 11, new Integer[0]);
        return parameters;
    }

    private static void addParameter(Collection<Object[]> parameters, String prefix, int minIndex, int maxIndex, Integer ... ignoreIndices) {
        Set ignoreSet = SetUtils.create((Object[])ignoreIndices);
        for (int i = minIndex; i <= maxIndex; ++i) {
            if (ignoreSet.contains(i)) continue;
            parameters.add(new Object[]{prefix + ".ttl", prefix + i + ".rq", prefix + i + ".terp"});
        }
    }

    public ParserTest(String kbFile, String sparqlFile, String sparqlOWLFile) {
        this.kbFile = kbFile;
        this.sparqlFile = sparqlFile;
        this.sparqlOWLFile = sparqlOWLFile;
    }

    @BeforeClass
    public static void beforeClass() {
        ARQTerpParser.registerFactory();
    }

    @AfterClass
    public static void afterClass() {
        ARQTerpParser.unregisterFactory();
    }

    @Before
    public void before() {
        this.kb = new JenaLoader().createKB(new String[]{base + this.kbFile});
        parser = new ARQParser();
    }

    @After
    public void after() {
        this.kb = null;
        parser = null;
    }

    @Test
    public void compareQuery() throws FileNotFoundException, IOException {
        com.hp.hpl.jena.query.Query sparql = QueryFactory.create((String)FileUtils.readFile((String)(base + this.sparqlFile)), (Syntax)Syntax.syntaxSPARQL);
        Query expected = parser.parse(sparql, this.kb);
        com.hp.hpl.jena.query.Query sparqlOWL = QueryFactory.create((String)FileUtils.readFile((String)(base + this.sparqlOWLFile)), (Syntax)TerpSyntax.getInstance());
        Query actual = parser.parse(sparqlOWL, this.kb);
        Assert.assertEquals((Object)expected.getAtoms(), (Object)actual.getAtoms());
    }
}

