/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.types.real.XSDByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import com.clarkparsia.pellet.datatypes.types.text.XSDString;
import com.clarkparsia.pellet.utils.PropertiesBuilder;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.textui.TestRunner;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.iterator.FlattenningIterator;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class MiscTests
extends AbstractKBTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static void main(String[] args) {
        TestRunner.run((junit.framework.Test)MiscTests.suite());
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(MiscTests.class);
    }

    @Test
    public void backtrackPreservesAssertedIndividuals() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addIndividual(TermFactory.term((String)"x"));
        kb.addClass(TermFactory.term((String)"C"));
        kb.addClass(TermFactory.term((String)"D"));
        kb.addDatatypeProperty((ATerm)TermFactory.term((String)"p"));
        kb.addFunctionalProperty(TermFactory.term((String)"p"));
        kb.addSubClass(TermFactory.term((String)"C"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"p"), (ATerm)ATermUtils.makeValue((ATerm)ATermUtils.makePlainLiteral((String)"0"))));
        kb.addSubClass(TermFactory.term((String)"D"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"p"), (ATerm)ATermUtils.makeValue((ATerm)ATermUtils.makePlainLiteral((String)"1"))));
        kb.addType(TermFactory.term((String)"x"), ATermUtils.makeOr((ATermList)ATermUtils.makeList((ATerm[])new ATerm[]{TermFactory.term((String)"C"), TermFactory.term((String)"D")})));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.addIndividual(TermFactory.term((String)"y"));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertNotNull((Object)kb.getABox().getIndividual((ATerm)TermFactory.term((String)"y")));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), ATermUtils.makePlainLiteral((String)"2"));
        Assert.assertFalse((boolean)kb.isConsistent());
        Assert.assertNotNull((Object)kb.getABox().getIndividual((ATerm)TermFactory.term((String)"y")));
    }

    @Test
    public void testFileUtilsToURI() throws MalformedURLException {
        Assert.assertEquals((Object)new File("build.xml").toURI().toURL().toString(), (Object)FileUtils.toURI((String)"build.xml"));
        Assert.assertEquals((Object)"http://example.com/foo", (Object)FileUtils.toURI((String)"http://example.com/foo"));
        Assert.assertEquals((Object)"file:///foo", (Object)FileUtils.toURI((String)"file:///foo"));
        Assert.assertEquals((Object)"ftp://example.com/foo", (Object)FileUtils.toURI((String)"ftp://example.com/foo"));
        Assert.assertEquals((Object)"https://example.com/foo", (Object)FileUtils.toURI((String)"https://example.com/foo"));
    }

    @Test
    public void testQualifiedCardinalityObjectProperty() {
        ATermAppl sub = TermFactory.term((String)"sub");
        ATermAppl sup = TermFactory.term((String)"sup");
        this.classes(c, d, sub, sup);
        this.objectProperties(p, f);
        this.kb.addFunctionalProperty(f);
        this.kb.addSubClass(sub, sup);
        PelletTestCase.assertSatisfiable(this.kb, TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)d)), TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.not((ATermAppl)d)), (ATermAppl)c))}));
        PelletTestCase.assertSubClass(this.kb, TermFactory.min((ATermAppl)p, (int)4, (ATermAppl)TermFactory.TOP), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertNotSubClass(this.kb, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertNotSubClass(this.kb, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)d));
        PelletTestCase.assertNotSubClass(this.kb, TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)c), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)d));
        PelletTestCase.assertSubClass(this.kb, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c));
        PelletTestCase.assertSubClass(this.kb, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertSubClass(this.kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertNotSubClass(this.kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)d));
        PelletTestCase.assertSubClass(this.kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)d)), TermFactory.some((ATermAppl)p, (ATermAppl)c));
        PelletTestCase.assertSubClass(this.kb, TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)sup), TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)sub));
        PelletTestCase.assertSubClass(this.kb, TermFactory.and((ATermAppl)TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP), (ATermAppl)TermFactory.all((ATermAppl)f, (ATermAppl)c)), TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)c));
        PelletTestCase.assertSubClass(this.kb, TermFactory.and((ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), (ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)p, (int)4, (ATermAppl)TermFactory.TOP));
    }

    @Test
    public void testQualifiedCardinalityDataProperty() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)10))});
        ATermAppl d = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.maxInclusive((ATermAppl)TermFactory.literal((int)20))});
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl f = TermFactory.term((String)"f");
        ATermAppl sub = Datatypes.SHORT;
        ATermAppl sup = Datatypes.INTEGER;
        kb.addDatatype(sub);
        kb.addDatatype(sup);
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)f);
        kb.addFunctionalProperty(f);
        PelletTestCase.assertSatisfiable(kb, TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)d)), TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.not((ATermAppl)d)), (ATermAppl)c))}));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)4, (ATermAppl)TermFactory.TOP_LIT), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP_LIT));
        PelletTestCase.assertNotSubClass(kb, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP_LIT), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP_LIT));
        PelletTestCase.assertNotSubClass(kb, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)d));
        PelletTestCase.assertNotSubClass(kb, TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)c), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)d));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP_LIT));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP_LIT));
        PelletTestCase.assertNotSubClass(kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)d));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)d)), TermFactory.some((ATermAppl)p, (ATermAppl)c));
        PelletTestCase.assertSubClass(kb, TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)sup), TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)sub));
        PelletTestCase.assertSubClass(kb, TermFactory.and((ATermAppl)TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP_LIT), (ATermAppl)TermFactory.all((ATermAppl)f, (ATermAppl)c)), TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)c));
        PelletTestCase.assertSubClass(kb, TermFactory.and((ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), (ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)p, (int)4, (ATermAppl)TermFactory.TOP_LIT));
    }

    @Test
    public void testQualifiedCardinality3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"z");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl e = TermFactory.term((String)"e");
        ATermAppl notD = TermFactory.term((String)"notD");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y3 = TermFactory.term((String)"y3");
        kb.addObjectProperty((ATerm)p);
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(e);
        kb.addClass(notD);
        kb.addDisjointClass(d, notD);
        kb.addIndividual(x);
        kb.addIndividual(y3);
        kb.addType(x, TermFactory.and((ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)d, (ATermAppl)e)), (ATermAppl)TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)d)));
        kb.addType(y3, TermFactory.not((ATermAppl)e));
        kb.addType(y3, TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.value((ATermAppl)x)));
        kb.addType(y3, TermFactory.or((ATermAppl)d, (ATermAppl)c));
        Assert.assertTrue((boolean)kb.isConsistent());
    }

    @Test
    public void testSelfRestrictions() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(c);
        kb.addClass(d);
        kb.addObjectProperty((ATerm)p);
        kb.addRange((ATerm)p, d);
        kb.addSubClass(c, TermFactory.and((ATermAppl)TermFactory.self((ATermAppl)p), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP)));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSatisfiable(c));
        Assert.assertTrue((boolean)kb.isSubClassOf(c, d));
    }

    @Test
    public void testBooleanDatatypeConstructors() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl nni = Datatypes.NON_NEGATIVE_INTEGER;
        ATermAppl npi = Datatypes.NON_POSITIVE_INTEGER;
        ATermAppl ni = Datatypes.NEGATIVE_INTEGER;
        ATermAppl pi = Datatypes.POSITIVE_INTEGER;
        ATermAppl f = Datatypes.FLOAT;
        ATermAppl s = TermFactory.term((String)"s");
        kb.addDatatypeProperty((ATerm)s);
        PelletTestCase.assertSatisfiable(kb, TermFactory.some((ATermAppl)s, (ATermAppl)pi));
        PelletTestCase.assertSatisfiable(kb, TermFactory.some((ATermAppl)s, (ATermAppl)TermFactory.not((ATermAppl)pi)));
        PelletTestCase.assertUnsatisfiable(kb, TermFactory.some((ATermAppl)s, (ATermAppl)TermFactory.and((ATermAppl)pi, (ATermAppl)ni)));
        PelletTestCase.assertUnsatisfiable(kb, TermFactory.some((ATermAppl)s, (ATermAppl)TermFactory.and((ATermAppl)f, (ATermAppl)TermFactory.or((ATermAppl)pi, (ATermAppl)ni))));
        PelletTestCase.assertSatisfiable(kb, TermFactory.some((ATermAppl)s, (ATermAppl)TermFactory.and((ATermAppl)npi, (ATermAppl)ni)));
        PelletTestCase.assertSatisfiable(kb, TermFactory.some((ATermAppl)s, (ATermAppl)TermFactory.and((ATermAppl)nni, (ATermAppl)pi)));
        PelletTestCase.assertSatisfiable(kb, TermFactory.some((ATermAppl)s, (ATermAppl)TermFactory.or((ATermAppl)nni, (ATermAppl)npi)));
        PelletTestCase.assertSatisfiable(kb, TermFactory.some((ATermAppl)s, (ATermAppl)TermFactory.and((ATermAppl)nni, (ATermAppl)npi)));
    }

    @Test
    public void testSelfRestrictionRestore() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"c");
        ATermAppl D = TermFactory.term((String)"d");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl a = TermFactory.term((String)"a");
        kb.addClass(C);
        kb.addClass(D);
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addSubClass(C, TermFactory.or((ATermAppl)TermFactory.not((ATermAppl)TermFactory.self((ATermAppl)p)), (ATermAppl)TermFactory.not((ATermAppl)TermFactory.self((ATermAppl)q))));
        kb.addIndividual(a);
        kb.addType(a, C);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertFalse((boolean)kb.isType(a, TermFactory.not((ATermAppl)TermFactory.self((ATermAppl)p))));
        Assert.assertFalse((boolean)kb.isType(a, TermFactory.not((ATermAppl)TermFactory.self((ATermAppl)q))));
    }

    @Test
    public void testReflexive1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl sub = TermFactory.term((String)"sub");
        ATermAppl sup = TermFactory.term((String)"sup");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl weakR = TermFactory.term((String)"weakR");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(sub);
        kb.addClass(sup);
        kb.addSubClass(sub, sup);
        kb.addSubClass(TermFactory.some((ATermAppl)weakR, (ATermAppl)TermFactory.TOP), TermFactory.self((ATermAppl)weakR));
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addObjectProperty((ATerm)weakR);
        kb.addReflexiveProperty(r);
        kb.addRange((ATerm)r, d);
        kb.addIndividual(x);
        kb.addType(x, TermFactory.self((ATermAppl)p));
        kb.addType(x, TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)weakR, (ATermAppl)TermFactory.value((ATermAppl)x))));
        kb.addIndividual(y);
        kb.addPropertyValue(weakR, y, x);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.self((ATermAppl)p)), TermFactory.some((ATermAppl)p, (ATermAppl)c)));
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.min((ATermAppl)r, (int)1, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)r, (int)2, (ATermAppl)TermFactory.TOP)));
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.min((ATermAppl)r, (int)1, (ATermAppl)c), d));
        Assert.assertTrue((boolean)kb.hasPropertyValue(x, p, x));
        Assert.assertTrue((boolean)kb.hasPropertyValue(y, weakR, y));
        Assert.assertTrue((boolean)kb.isDifferentFrom(x, y));
        Assert.assertTrue((boolean)kb.isDifferentFrom(y, x));
        Assert.assertTrue((boolean)kb.isType(x, TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.value((ATermAppl)x))));
        Assert.assertTrue((boolean)kb.isSatisfiable(TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.self((ATermAppl)p), TermFactory.self((ATermAppl)TermFactory.inv((ATermAppl)p)), TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP)})));
    }

    @Test
    public void testReflexive2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl r = TermFactory.term((String)"r");
        kb.addIndividual(a);
        kb.addClass(c);
        kb.addSubClass(c, TermFactory.all((ATermAppl)r, (ATermAppl)TermFactory.BOTTOM));
        kb.addSubClass(c, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a}));
        kb.addObjectProperty((ATerm)r);
        kb.addReflexiveProperty(r);
        PelletTestCase.assertSatisfiable(kb, c, false);
    }

    @Test
    public void testReflexive3() {
        this.classes(C);
        this.objectProperties(r);
        this.individuals(a, b, c);
        this.kb.addEquivalentClass(C, TermFactory.self((ATermAppl)r));
        this.kb.addPropertyValue(r, a, a);
        this.kb.addType(b, C);
        this.kb.addPropertyValue(r, c, a);
        this.kb.addPropertyValue(r, c, b);
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, r, a));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(b, r, b));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, r, c));
        Map allRs = this.kb.getPropertyValues(r);
        PelletTestCase.assertIteratorValues(((List)allRs.get(a)).iterator(), a);
        PelletTestCase.assertIteratorValues(((List)allRs.get(b)).iterator(), b);
        PelletTestCase.assertIteratorValues(((List)allRs.get(c)).iterator(), a, b);
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(b, C));
        Assert.assertFalse((boolean)this.kb.isType(c, C));
        Assert.assertEquals((Object)this.kb.getInstances(C), (Object)SetUtils.create((Object[])new ATermAppl[]{a, b}));
    }

    @Test
    public void testAsymmetry() {
        ATermAppl p = TermFactory.term((String)"p");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty((ATerm)p);
        kb.addAsymmetricProperty(p);
        Assert.assertTrue((boolean)kb.isIrreflexiveProperty(p));
    }

    @Test
    public void testResrictedDataRange() {
        byte MIN = 0;
        byte MAX = 127;
        int COUNT = MAX - MIN + 1;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(E);
        kb.addDatatypeProperty((ATerm)p);
        kb.addRange((ATerm)p, ATermUtils.makeRestrictedDatatype((ATermAppl)XSDInteger.getInstance().getName(), (ATermAppl[])new ATermAppl[]{ATermUtils.makeFacetRestriction((ATermAppl)Facet.XSD.MIN_INCLUSIVE.getName(), (ATermAppl)ATermUtils.makeTypedLiteral((String)Byte.toString(MIN), (ATermAppl)XSDByte.getInstance().getName())), ATermUtils.makeFacetRestriction((ATermAppl)Facet.XSD.MAX_INCLUSIVE.getName(), (ATermAppl)ATermUtils.makeTypedLiteral((String)Byte.toString(MAX), (ATermAppl)XSDByte.getInstance().getName()))}));
        kb.addSubClass(C, TermFactory.card((ATermAppl)p, (int)(COUNT + 1), (ATermAppl)ATermUtils.TOP_LIT));
        kb.addSubClass(D, TermFactory.card((ATermAppl)p, (int)COUNT, (ATermAppl)ATermUtils.TOP_LIT));
        kb.addSubClass(E, TermFactory.card((ATermAppl)p, (int)(COUNT - 1), (ATermAppl)ATermUtils.TOP_LIT));
        kb.addIndividual(x);
        kb.addType(x, D);
        kb.addIndividual(y);
        kb.addType(y, E);
        Assert.assertFalse((boolean)kb.isSatisfiable(C));
        Assert.assertTrue((boolean)kb.isSatisfiable(D));
        Assert.assertTrue((boolean)kb.isSatisfiable(E));
        Assert.assertTrue((boolean)kb.hasPropertyValue(x, p, ATermUtils.makeTypedLiteral((String)"5", (ATermAppl)XSDInteger.getInstance().getName())));
        Assert.assertFalse((boolean)kb.hasPropertyValue(y, p, ATermUtils.makeTypedLiteral((String)"5", (ATermAppl)XSDDecimal.getInstance().getName())));
    }

    @Test
    public void testMaxCardinality() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty((ATerm)TermFactory.term((String)"p"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"q"));
        kb.addFunctionalProperty(TermFactory.term((String)"q"));
        kb.addClass(TermFactory.term((String)"C"));
        kb.addSubClass(TermFactory.term((String)"C"), ATermUtils.makeMax((ATerm)TermFactory.term((String)"p"), (int)2, (ATerm)ATermUtils.TOP));
        kb.addClass(TermFactory.term((String)"D1"));
        kb.addClass(TermFactory.term((String)"D2"));
        kb.addClass(TermFactory.term((String)"D3"));
        kb.addClass(TermFactory.term((String)"D4"));
        kb.addClass(TermFactory.term((String)"E1"));
        kb.addClass(TermFactory.term((String)"E2"));
        kb.addClass(TermFactory.term((String)"E3"));
        kb.addClass(TermFactory.term((String)"E4"));
        kb.addSubClass(TermFactory.term((String)"D1"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"q"), (ATerm)TermFactory.term((String)"E1")));
        kb.addSubClass(TermFactory.term((String)"D2"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"q"), (ATerm)TermFactory.term((String)"E2")));
        kb.addSubClass(TermFactory.term((String)"D3"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"q"), (ATerm)TermFactory.term((String)"E3")));
        kb.addSubClass(TermFactory.term((String)"D4"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"q"), (ATerm)TermFactory.term((String)"E4")));
        kb.addIndividual(TermFactory.term((String)"x"));
        kb.addType(TermFactory.term((String)"x"), TermFactory.term((String)"C"));
        kb.addIndividual(TermFactory.term((String)"x1"));
        kb.addType(TermFactory.term((String)"x1"), TermFactory.term((String)"D1"));
        kb.addIndividual(TermFactory.term((String)"x2"));
        kb.addType(TermFactory.term((String)"x2"), TermFactory.term((String)"D2"));
        kb.addIndividual(TermFactory.term((String)"x3"));
        kb.addType(TermFactory.term((String)"x3"), TermFactory.term((String)"D3"));
        kb.addIndividual(TermFactory.term((String)"x4"));
        kb.addType(TermFactory.term((String)"x4"), TermFactory.term((String)"D4"));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), TermFactory.term((String)"x1"));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), TermFactory.term((String)"x2"));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), TermFactory.term((String)"x3"));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), TermFactory.term((String)"x4"));
        kb.addDisjointClass(TermFactory.term((String)"E1"), TermFactory.term((String)"E2"));
        kb.addDisjointClass(TermFactory.term((String)"E1"), TermFactory.term((String)"E4"));
        kb.addDisjointClass(TermFactory.term((String)"E2"), TermFactory.term((String)"E3"));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSameAs(TermFactory.term((String)"x1"), TermFactory.term((String)"x3")));
        Assert.assertTrue((boolean)kb.isSameAs(TermFactory.term((String)"x3"), TermFactory.term((String)"x1")));
        Assert.assertTrue((boolean)kb.isSameAs(TermFactory.term((String)"x2"), TermFactory.term((String)"x4")));
        Assert.assertTrue((boolean)kb.getSames(TermFactory.term((String)"x1")).contains(TermFactory.term((String)"x3")));
        Assert.assertTrue((boolean)kb.getSames(TermFactory.term((String)"x2")).contains(TermFactory.term((String)"x4")));
    }

    @Test
    public void testDifferentFrom2() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(TermFactory.term((String)"C"));
        kb.addClass(TermFactory.term((String)"D"));
        kb.addDisjointClass(TermFactory.term((String)"C"), TermFactory.term((String)"D"));
        kb.addIndividual(TermFactory.term((String)"a"));
        kb.addType(TermFactory.term((String)"a"), TermFactory.term((String)"C"));
        kb.addIndividual(TermFactory.term((String)"b"));
        kb.addType(TermFactory.term((String)"b"), TermFactory.term((String)"D"));
        kb.classify();
        Assert.assertTrue((boolean)kb.getDifferents(TermFactory.term((String)"a")).contains(TermFactory.term((String)"b")));
        Assert.assertTrue((boolean)kb.getDifferents(TermFactory.term((String)"b")).contains(TermFactory.term((String)"a")));
    }

    @Test
    public void testSHOIN() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty((ATerm)TermFactory.term((String)"R1"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"invR1"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"R2"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"invR2"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"S1"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"invS1"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"S2"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"invS2"));
        kb.addInverseProperty(TermFactory.term((String)"R1"), TermFactory.term((String)"invR1"));
        kb.addInverseProperty(TermFactory.term((String)"R2"), TermFactory.term((String)"invR2"));
        kb.addInverseProperty(TermFactory.term((String)"S1"), TermFactory.term((String)"invS1"));
        kb.addInverseProperty(TermFactory.term((String)"S2"), TermFactory.term((String)"invS2"));
        kb.addIndividual(TermFactory.term((String)"o1"));
        kb.addIndividual(TermFactory.term((String)"o2"));
        kb.addSubClass(TermFactory.value((ATermAppl)TermFactory.term((String)"o1")), TermFactory.and((ATermAppl)TermFactory.max((ATermAppl)TermFactory.term((String)"invR1"), (int)2, (ATermAppl)ATermUtils.TOP), (ATermAppl)TermFactory.all((ATermAppl)TermFactory.term((String)"invR1"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"S1"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"invS2"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"R2"), (ATermAppl)TermFactory.value((ATermAppl)TermFactory.term((String)"o2"))))))));
        kb.addSubClass(TermFactory.value((ATermAppl)TermFactory.term((String)"o2")), TermFactory.and((ATermAppl)TermFactory.max((ATermAppl)TermFactory.term((String)"invR2"), (int)2, (ATermAppl)ATermUtils.TOP), (ATermAppl)TermFactory.all((ATermAppl)TermFactory.term((String)"invR2"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"S2"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"invS1"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"R1"), (ATermAppl)TermFactory.value((ATermAppl)TermFactory.term((String)"o1"))))))));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSatisfiable(TermFactory.and((ATermAppl)TermFactory.value((ATermAppl)TermFactory.term((String)"o1")), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"invR1"), (ATermAppl)TermFactory.TOP))));
    }

    @Test
    public void testCyclicTBox1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        kb.addEquivalentClass(C, TermFactory.not((ATermAppl)C));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testTopClass2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addObjectProperty((ATerm)p);
        kb.addEquivalentClass(A, TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.not((ATermAppl)B)));
        kb.addSubClass(C, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(A, TermFactory.TOP));
        Assert.assertFalse((boolean)kb.isEquivalentClass(B, TermFactory.TOP));
    }

    @Test
    public void testTopClass2EL() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        kb.addClass(A);
        kb.addClass(B);
        kb.addEquivalentClass(A, TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.not((ATermAppl)B)));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(A, TermFactory.TOP));
        Assert.assertFalse((boolean)kb.isEquivalentClass(B, TermFactory.TOP));
    }

    @Test
    public void testTopClass3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addEquivalentClass(A, B);
        kb.addEquivalentClass(B, TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.not((ATermAppl)B)));
        kb.addSubClass(C, A);
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(A, TermFactory.TOP));
        Assert.assertTrue((boolean)kb.isEquivalentClass(B, TermFactory.TOP));
        Assert.assertFalse((boolean)kb.isEquivalentClass(C, TermFactory.TOP));
    }

    @Test
    public void testTopClass4() {
        this.classes(A, B, C);
        this.kb.addSubClass(TermFactory.not((ATermAppl)A), A);
        this.kb.addSubClass(B, A);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.classify();
        Assert.assertTrue((boolean)this.kb.isEquivalentClass(A, TermFactory.TOP));
    }

    @Test
    public void testNonDisjointness() {
        this.classes(A, B, C);
        this.kb.addSubClass(TermFactory.not((ATermAppl)A), B);
        this.kb.addSubClass(C, TermFactory.and((ATermAppl)A, (ATermAppl)B));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.classify();
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
    }

    @Test
    public void testCyclicTBox2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, B);
        kb.addSubClass(D, C);
        kb.addEquivalentClass(D, B);
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(B, C));
        Assert.assertTrue((boolean)kb.isEquivalentClass(B, D));
        Assert.assertTrue((boolean)kb.isEquivalentClass(D, C));
    }

    @Test
    public void testCyclicTBox3() {
        List<ATermAppl> classes = Arrays.asList(TermFactory.term((String)"C0"), TermFactory.term((String)"C1"), TermFactory.term((String)"C2"));
        Taxonomy taxonomy = new Taxonomy(classes, (Object)ATermUtils.TOP, (Object)ATermUtils.BOTTOM);
        TaxonomyNode top = taxonomy.getTop();
        TaxonomyNode[] nodes = new TaxonomyNode[classes.size()];
        int i = 0;
        for (ATermAppl c : classes) {
            nodes[i++] = taxonomy.getNode((Object)c);
        }
        taxonomy.addSuper((Object)classes.get(1), (Object)classes.get(2));
        taxonomy.addSuper((Object)classes.get(0), (Object)classes.get(1));
        taxonomy.merge(top, nodes[0]);
        Assert.assertTrue((boolean)top.getSupers().isEmpty());
        Assert.assertTrue((boolean)top.getEquivalents().containsAll(classes));
    }

    @Test
    public void testComplexTypes() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        kb.addIndividual(a);
        kb.addType(a, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)TermFactory.TOP));
        kb.addType(a, TermFactory.max((ATermAppl)q, (int)2, (ATermAppl)TermFactory.TOP));
        kb.addType(a, TermFactory.min((ATermAppl)q, (int)1, (ATermAppl)TermFactory.TOP));
        kb.addType(a, TermFactory.min((ATermAppl)q, (int)1, (ATermAppl)TermFactory.TOP));
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        Assert.assertTrue((boolean)kb.isConsistent());
    }

    @Test
    public void testBottomSub() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"c");
        kb.addClass(c);
        kb.addSubClass(ATermUtils.BOTTOM, c);
        kb.classify();
        Assert.assertTrue((boolean)kb.isSubClassOf(ATermUtils.BOTTOM, c));
    }

    @Test
    @Ignore(value="Known to fail because different lexical forms are stored in one canonical literal")
    public void testCanonicalLiteral() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl plain = ATermUtils.makePlainLiteral((String)"lit");
        ATermAppl typed = ATermUtils.makeTypedLiteral((String)"lit", (ATermAppl)XSDString.getInstance().getName());
        kb.addIndividual(a);
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)q);
        kb.addPropertyValue(p, a, plain);
        kb.addPropertyValue(q, a, typed);
        PelletTestCase.assertIteratorValues(kb.getDataPropertyValues(p, a).iterator(), plain);
        PelletTestCase.assertIteratorValues(kb.getDataPropertyValues(q, a).iterator(), typed);
    }

    @Test
    public void testSimpleABoxRemove() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(a);
        kb.addType(a, C);
        kb.addType(a, D);
        kb.removeType(a, D);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, C));
        Assert.assertFalse((boolean)kb.isType(a, D));
    }

    @Test
    public void testABoxRemovalWithAllValues() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(C);
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addType(a, TermFactory.all((ATermAppl)p, (ATermAppl)C));
        kb.addType(b, C);
        kb.addPropertyValue(p, a, b);
        kb.removeType(b, C);
        kb.removePropertyValue(p, a, b);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertFalse((boolean)kb.isType(b, C));
        Assert.assertFalse((boolean)kb.hasPropertyValue(a, p, b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove1() {
        Properties newOptions = PropertiesBuilder.singleton((String)"USE_TRACING", (String)"true");
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl B = ATermUtils.makeTermAppl((String)"B");
            ATermAppl C = ATermUtils.makeTermAppl((String)"C");
            ATermAppl x = ATermUtils.makeTermAppl((String)"x");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addClass(B);
            kb.addClass(C);
            kb.addIndividual(x);
            kb.addSubClass(C, A);
            kb.addType(x, C);
            kb.addType(x, B);
            HashSet<Set<ATermAppl>> expectedTypes = new HashSet<Set<ATermAppl>>();
            expectedTypes.add(Collections.singleton(ATermUtils.TOP));
            expectedTypes.add(Collections.singleton(A));
            expectedTypes.add(Collections.singleton(B));
            expectedTypes.add(Collections.singleton(C));
            Assert.assertTrue((boolean)kb.isConsistent());
            Set actualTypes = kb.getTypes(x);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
            kb.addDisjointClass(A, B);
            Assert.assertFalse((boolean)kb.isConsistent());
            Assert.assertTrue((boolean)kb.removeAxiom(ATermUtils.makeDisjoint((ATerm)A, (ATerm)B)));
            Assert.assertTrue((boolean)kb.isConsistent());
            actualTypes = kb.getTypes(x);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove2() {
        Properties newOptions = PropertiesBuilder.singleton((String)"USE_TRACING", (String)"true");
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            this.classes(A, B, C);
            this.individuals(a);
            this.kb.addSubClass(C, A);
            this.kb.addType(a, C);
            this.kb.addType(a, B);
            HashSet<Set<ATermAppl>> expectedTypes = new HashSet<Set<ATermAppl>>();
            expectedTypes.add(Collections.singleton(ATermUtils.TOP));
            expectedTypes.add(Collections.singleton(A));
            expectedTypes.add(Collections.singleton(B));
            expectedTypes.add(Collections.singleton(C));
            Assert.assertTrue((boolean)this.kb.isConsistent());
            Set actualTypes = this.kb.getTypes(a);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
            this.kb.addSubClass(A, ATermUtils.makeNot((ATerm)B));
            Assert.assertFalse((boolean)this.kb.isConsistent());
            this.kb.addDisjointClass(A, B);
            Assert.assertFalse((boolean)this.kb.isConsistent());
            Assert.assertTrue((boolean)this.kb.removeAxiom(ATermUtils.makeDisjoint((ATerm)A, (ATerm)B)));
            Assert.assertFalse((boolean)this.kb.isConsistent());
            Assert.assertTrue((boolean)this.kb.removeAxiom(ATermUtils.makeSub((ATerm)A, (ATerm)ATermUtils.makeNot((ATerm)B))));
            Assert.assertTrue((boolean)this.kb.isConsistent());
            actualTypes = this.kb.getTypes(a);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove3() {
        Properties newOptions = PropertiesBuilder.singleton((String)"USE_TRACING", (String)"true");
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            this.classes(A, B, C);
            this.individuals(a);
            this.kb.addSubClass(C, A);
            this.kb.addType(a, C);
            this.kb.addType(a, B);
            HashSet<Set<ATermAppl>> expectedTypes = new HashSet<Set<ATermAppl>>();
            expectedTypes.add(Collections.singleton(ATermUtils.TOP));
            expectedTypes.add(Collections.singleton(A));
            expectedTypes.add(Collections.singleton(B));
            expectedTypes.add(Collections.singleton(C));
            Assert.assertTrue((boolean)this.kb.isConsistent());
            Set actualTypes = this.kb.getTypes(a);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
            this.kb.addSubClass(A, ATermUtils.makeNot((ATerm)B));
            Assert.assertFalse((boolean)this.kb.isConsistent());
            ATermList list = ATermUtils.toSet((ATerm[])new ATerm[]{A, B, D}, (int)3);
            this.kb.addDisjointClasses(list);
            Assert.assertFalse((boolean)this.kb.isConsistent());
            Assert.assertTrue((boolean)this.kb.removeAxiom(ATermUtils.makeDisjoints((ATermList)list)));
            Assert.assertFalse((boolean)this.kb.isConsistent());
            Assert.assertTrue((boolean)this.kb.removeAxiom(ATermUtils.makeSub((ATerm)A, (ATerm)ATermUtils.makeNot((ATerm)B))));
            Assert.assertTrue((boolean)this.kb.isConsistent());
            actualTypes = this.kb.getTypes(a);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove4() {
        Properties newOptions = new PropertiesBuilder().set("USE_TRACING", "true").set("USE_ROLE_ABSORPTION", "true").build();
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl B = ATermUtils.makeTermAppl((String)"B");
            ATermAppl p = ATermUtils.makeTermAppl((String)"p");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addClass(B);
            kb.addObjectProperty((ATerm)p);
            ATermAppl or1 = TermFactory.or((ATermAppl)A, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)A));
            ATermAppl or2 = TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B));
            ATermList list = ATermUtils.toSet((ATerm[])new ATerm[]{or1, or2}, (int)2);
            kb.addDisjointClasses(list);
            Assert.assertTrue((boolean)kb.isConsistent());
            ATermAppl disjoint = ATermUtils.makeDisjoints((ATermList)list);
            Assert.assertFalse((boolean)kb.removeAxiom(disjoint));
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove5() {
        Properties newOptions = new PropertiesBuilder().set("USE_TRACING", "true").set("USE_ROLE_ABSORPTION", "true").build();
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl B = ATermUtils.makeTermAppl((String)"B");
            ATermAppl p = ATermUtils.makeTermAppl((String)"p");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addClass(B);
            kb.addObjectProperty((ATerm)p);
            ATermAppl or1 = TermFactory.or((ATermAppl)A, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)A));
            ATermAppl or2 = TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B));
            kb.addDisjointClass(or1, or2);
            Assert.assertTrue((boolean)kb.isConsistent());
            ATermAppl disjoint = ATermUtils.makeDisjoint((ATerm)or1, (ATerm)or2);
            Assert.assertFalse((boolean)kb.removeAxiom(disjoint));
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove6() {
        Properties newOptions = new PropertiesBuilder().set("USE_TRACING", "true").set("USE_ROLE_ABSORPTION", "true").build();
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl p = ATermUtils.makeTermAppl((String)"p");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addObjectProperty((ATerm)p);
            kb.addSubClass(TermFactory.TOP, TermFactory.all((ATermAppl)p, (ATermAppl)A));
            Role r = kb.getRole((ATerm)p);
            Assert.assertTrue((boolean)kb.isConsistent());
            Assert.assertTrue((boolean)r.getRanges().contains(A));
            Assert.assertFalse((boolean)kb.removeAxiom(ATermUtils.makeSub((ATerm)TermFactory.TOP, (ATerm)TermFactory.all((ATermAppl)p, (ATermAppl)A))));
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    @Test
    public void testAssertedSameAs() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl e = TermFactory.term((String)"e");
        ATermAppl f = TermFactory.term((String)"f");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addIndividual(e);
        kb.addIndividual(f);
        kb.addSame(a, b);
        kb.addSame(b, c);
        kb.addSame(c, d);
        kb.addSame(a, d);
        kb.addSame(b, d);
        kb.addSame(e, f);
        kb.addDifferent(e, f);
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testSubPropertyRestore() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl invQ = TermFactory.term((String)"invQ");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)invP);
        kb.addObjectProperty((ATerm)invQ);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, a, b);
        kb.addSubProperty((ATerm)p, q);
        kb.addInverseProperty(p, invP);
        kb.addInverseProperty(q, invQ);
        kb.addType(b, TermFactory.or((ATermAppl)TermFactory.value((ATermAppl)c), (ATermAppl)TermFactory.value((ATermAppl)d)));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(b, TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)invP, (ATermAppl)TermFactory.value((ATermAppl)a)), (ATermAppl)TermFactory.some((ATermAppl)invQ, (ATermAppl)TermFactory.value((ATermAppl)a)))));
    }

    @Test
    public void testInverseProperty() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl invQ = TermFactory.term((String)"invQ");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)invP);
        kb.addObjectProperty((ATerm)invQ);
        kb.addInverseProperty(p, invP);
        kb.addInverseProperty(q, invQ);
        Assert.assertEquals(Collections.singleton(invP), (Object)kb.getInverses((ATerm)p));
        Assert.assertEquals(Collections.singleton(invQ), (Object)kb.getInverses((ATerm)q));
        Assert.assertEquals(Collections.singleton(p), (Object)kb.getInverses((ATerm)invP));
        Assert.assertEquals(Collections.singleton(q), (Object)kb.getInverses((ATerm)invQ));
    }

    @Test
    public void testUndefinedTerms() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        kb.addClass(C);
        ATermAppl p = TermFactory.term((String)"p");
        kb.addObjectProperty((ATerm)p);
        ATermAppl undef = TermFactory.term((String)"undef");
        Assert.assertEquals(Collections.singleton(p), (Object)kb.getAllEquivalentProperties(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentProperties(p));
        Assert.assertEquals(Collections.singleton(Collections.singleton(TermFactory.BOTTOM_OBJECT_PROPERTY)), (Object)kb.getSubProperties(p));
        Assert.assertEquals(Collections.singleton(Collections.singleton(TermFactory.TOP_OBJECT_PROPERTY)), (Object)kb.getSuperProperties(p));
        Assert.assertEquals(Collections.singleton(C), (Object)kb.getAllEquivalentClasses(C));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentClasses(C));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSubClasses(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSuperClasses(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getAllEquivalentProperties(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentProperties(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSubProperties(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSuperProperties(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getAllEquivalentClasses(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentClasses(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSubClasses(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSuperClasses(undef));
    }

    @Test
    public void testDatatypeReasoner() {
        this.dataProperties(p);
        this.individuals(a);
        this.kb.addRange((ATerm)p, Datatypes.FLOAT);
        this.kb.addPropertyValue(p, a, TermFactory.literal((float)42.0f));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, TermFactory.some((ATermAppl)p, (ATermAppl)Datatypes.FLOAT)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCRonDTP() {
        Properties newOptions = new PropertiesBuilder().set("SILENT_UNDEFINED_ENTITY_HANDLING", "false").build();
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            KnowledgeBase kb = new KnowledgeBase();
            ATermAppl p = TermFactory.term((String)"p");
            ATermAppl c = TermFactory.and((ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.value((ATermAppl)TermFactory.literal((String)"s"))), (ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.value((ATermAppl)TermFactory.literal((String)"l"))));
            kb.addDatatypeProperty((ATerm)p);
            Assert.assertFalse((boolean)kb.isSatisfiable(c));
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    @Test
    public void testInvalidTransitivity2() {
        KBLoader[] loaders;
        for (KBLoader loader : loaders = new KBLoader[]{new JenaLoader()}) {
            KnowledgeBase kb = loader.createKB(new String[]{base + "invalidTransitivity.owl"});
            for (Role r : kb.getRBox().getRoles()) {
                if (ATermUtils.isBuiltinProperty((ATermAppl)r.getName())) continue;
                Assert.assertTrue((String)r.toString(), (boolean)r.isSimple());
                Assert.assertFalse((String)r.toString(), (boolean)r.isTransitive());
            }
            for (ATermAppl p : kb.getObjectProperties()) {
                if (ATermUtils.isBuiltinProperty((ATermAppl)p)) continue;
                Assert.assertFalse((String)p.toString(), (boolean)kb.isTransitiveProperty(p));
            }
        }
    }

    @Test
    public void testInternalization() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addSubClass(TermFactory.TOP, TermFactory.and((ATermAppl)TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.not((ATermAppl)A)), (ATermAppl)TermFactory.or((ATermAppl)C, (ATermAppl)TermFactory.not((ATermAppl)B))));
        PelletTestCase.assertSubClass(kb, A, B);
        PelletTestCase.assertSubClass(kb, B, C);
        kb.classify();
    }

    @Test
    public void testNominalCache() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addClass(C);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addSubClass(C, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a, b}));
        kb.addEquivalentClass(A, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a}));
        kb.addEquivalentClass(B, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b}));
        kb.addDisjointClass(A, B);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSatisfiable(C));
        PelletTestCase.assertNotSubClass(kb, C, A);
        PelletTestCase.assertNotSubClass(kb, C, B);
        PelletTestCase.assertNotSubClass(kb, A, C);
        PelletTestCase.assertNotSubClass(kb, B, C);
        Assert.assertFalse((boolean)kb.isType(a, C));
        Assert.assertFalse((boolean)kb.isType(b, C));
        Assert.assertFalse((boolean)kb.isType(a, TermFactory.not((ATermAppl)C)));
        Assert.assertFalse((boolean)kb.isType(b, TermFactory.not((ATermAppl)C)));
    }

    @Test
    public void testNominalValueInteraction() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl t1 = TermFactory.term((String)"T1");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl i1 = TermFactory.term((String)"i1");
        ATermAppl i21 = TermFactory.term((String)"i21");
        ATermAppl i22 = TermFactory.term((String)"i22");
        ATermAppl t1eq = ATermUtils.makeAnd((ATerm)ATermUtils.makeHasValue((ATerm)p, (ATerm)i21), (ATerm)ATermUtils.makeHasValue((ATerm)p, (ATerm)i22));
        ATermAppl test = TermFactory.term((String)"test");
        kb.addClass(t1);
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(i1);
        kb.addIndividual(i21);
        kb.addIndividual(i22);
        kb.addIndividual(test);
        kb.addEquivalentClass(t1, t1eq);
        kb.addSame(i1, i21);
        kb.addSame(i21, i1);
        kb.addPropertyValue(p, test, i21);
        kb.addPropertyValue(p, test, i22);
        Set t1inds = kb.retrieve(t1eq, (Collection)kb.getIndividuals());
        Assert.assertEquals((String)"Individual test should be of type T1. ", Collections.singleton(test), (Object)t1inds);
    }

    @Test
    public void testMultiEdgesWithTransitivity() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl e = TermFactory.term((String)"e");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl s = TermFactory.term((String)"s");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addObjectProperty((ATerm)s);
        kb.addTransitiveProperty(r);
        kb.addTransitiveProperty(s);
        kb.addSubProperty((ATerm)r, p);
        kb.addSubProperty((ATerm)s, p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addIndividual(e);
        kb.addPropertyValue(r, a, b);
        kb.addPropertyValue(r, b, c);
        kb.addPropertyValue(r, b, d);
        kb.addPropertyValue(s, a, c);
        kb.addPropertyValue(s, c, b);
        kb.addPropertyValue(s, c, e);
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, b));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, c));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, d));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, e));
        PelletTestCase.assertIteratorValues(kb.getPropertyValues(p, a).iterator(), b, c, d, e);
    }

    @Test
    public void testLiteralMerge() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addDatatypeProperty((ATerm)p);
        kb.addFunctionalProperty(p);
        kb.addType(a, TermFactory.some((ATermAppl)p, (ATermAppl)XSDInteger.getInstance().getName()));
        kb.addType(a, TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP_LIT));
        kb.addPropertyValue(p, b, TermFactory.literal((String)"b"));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isDifferentFrom(a, b));
    }

    @Test
    public void testDatatypeSubProperty1a() {
        ATermAppl[] ranges;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        for (ATermAppl rangeP : ranges = new ATermAppl[]{null, XSDInteger.getInstance().getName(), XSDString.getInstance().getName()}) {
            for (ATermAppl rangeQ : ranges) {
                kb.clear();
                kb.addDatatypeProperty((ATerm)p);
                kb.addDatatypeProperty((ATerm)q);
                if (rangeP != null) {
                    kb.addRange((ATerm)p, rangeP);
                }
                if (rangeQ != null) {
                    kb.addRange((ATerm)q, rangeQ);
                }
                Assert.assertTrue((boolean)kb.isConsistent());
                Assert.assertFalse((boolean)kb.isSubPropertyOf(p, q));
                Assert.assertFalse((boolean)kb.isSubPropertyOf(q, p));
                Assert.assertFalse((boolean)kb.isEquivalentProperty(p, q));
                Assert.assertFalse((boolean)kb.isEquivalentProperty(q, p));
            }
        }
    }

    @Test
    public void testDatatypeSubProperty1b() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        kb.addClass(C);
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)q);
        kb.addDomain((ATerm)p, C);
        kb.addRange((ATerm)q, XSDInteger.getInstance().getName());
        kb.addSubClass(C, TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.TOP_LIT));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertFalse((boolean)kb.isSubPropertyOf(p, q));
        Assert.assertFalse((boolean)kb.isSubPropertyOf(q, p));
        Assert.assertFalse((boolean)kb.isEquivalentProperty(p, q));
        Assert.assertFalse((boolean)kb.isEquivalentProperty(q, p));
    }

    @Test
    public void testCachedNominalEdge() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addEquivalentClass(A, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        kb.addEquivalentClass(B, TermFactory.hasValue((ATermAppl)p, (ATermAppl)b));
        kb.addEquivalentClass(C, TermFactory.hasValue((ATermAppl)p, (ATermAppl)c));
        kb.addEquivalentClass(D, TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.some((ATermAppl)p, (ATermAppl)A), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.value((ATermAppl)b)), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.value((ATermAppl)c)), TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP)}));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isSubClassOf(D, B));
        Assert.assertTrue((boolean)kb.isSubClassOf(D, C));
    }

    @Test
    public void testDisjoints() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(B, A);
        kb.addSubClass(D, C);
        kb.addComplementClass(B, C);
        Assert.assertTrue((boolean)kb.isConsistent());
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.TOP).iterator(), Collections.singleton(TermFactory.BOTTOM));
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(A).iterator(), Collections.singleton(TermFactory.BOTTOM));
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(B).iterator(), Collections.singleton(TermFactory.BOTTOM), Collections.singleton(C), Collections.singleton(D));
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(C).iterator(), Collections.singleton(TermFactory.BOTTOM), Collections.singleton(B));
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(D).iterator(), Collections.singleton(TermFactory.BOTTOM), Collections.singleton(B));
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.BOTTOM).iterator(), Collections.singleton(TermFactory.TOP), Collections.singleton(A), Collections.singleton(B), Collections.singleton(C), Collections.singleton(D), Collections.singleton(TermFactory.BOTTOM));
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.TOP).iterator(), TermFactory.BOTTOM);
        Assert.assertTrue((boolean)kb.getComplements(A).isEmpty());
        PelletTestCase.assertIteratorValues(kb.getComplements(B).iterator(), C);
        PelletTestCase.assertIteratorValues(kb.getComplements(C).iterator(), B);
        Assert.assertTrue((boolean)kb.getComplements(D).isEmpty());
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.BOTTOM).iterator(), TermFactory.TOP);
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.not((ATermAppl)A)).iterator(), Collections.singleton(TermFactory.BOTTOM), Collections.singleton(A), Collections.singleton(B));
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.not((ATermAppl)B)).iterator(), Collections.singleton(TermFactory.BOTTOM), Collections.singleton(B));
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.not((ATermAppl)C)).iterator(), Collections.singleton(TermFactory.BOTTOM), Collections.singleton(C), Collections.singleton(D));
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.not((ATermAppl)D)).iterator(), Collections.singleton(TermFactory.BOTTOM), Collections.singleton(D));
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.not((ATermAppl)A)).iterator(), A);
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.not((ATermAppl)B)).iterator(), B);
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.not((ATermAppl)C)).iterator(), C);
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.not((ATermAppl)D)).iterator(), D);
    }

    @Test
    public void testDisjointDataProperties() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)q);
        kb.addRange((ATerm)p, Datatypes.INT);
        kb.addRange((ATerm)q, Datatypes.INT);
        Assert.assertFalse((String)"p and q should not be disjoint!", (boolean)kb.isDisjointProperty(p, q));
    }

    @Test
    public void testRemovePruned() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addEquivalentClass(A, TermFactory.value((ATermAppl)a));
        kb.addSubClass(A, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.not((ATermAppl)B)));
        kb.addSubClass(B, TermFactory.or((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)A), (ATermAppl)C));
        kb.addType(b, B);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(b, C));
        Assert.assertFalse((boolean)kb.isType(a, C));
    }

    @Test
    public void testDataAssertions() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl oneDecimal = TermFactory.literal((String)"1", (ATermAppl)Datatypes.DECIMAL);
        ATermAppl oneInteger = TermFactory.literal((String)"1", (ATermAppl)Datatypes.INTEGER);
        ATermAppl oneByte = TermFactory.literal((String)"1", (ATermAppl)Datatypes.BYTE);
        ATermAppl oneFloat = TermFactory.literal((String)"1", (ATermAppl)Datatypes.FLOAT);
        kb.addClass(A);
        kb.addDatatypeProperty((ATerm)p);
        kb.addIndividual(a);
        kb.addPropertyValue(p, a, oneInteger);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, oneDecimal));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, oneInteger));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, oneByte));
        Assert.assertFalse((boolean)kb.hasPropertyValue(a, p, oneFloat));
        Assert.assertEquals(Collections.singletonList(oneInteger), (Object)kb.getDataPropertyValues(p, a));
    }

    @Test
    public void testDatatypeIntersection() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl zeroDecimal = TermFactory.literal((String)"0", (ATermAppl)Datatypes.DECIMAL);
        ATermAppl zeroInteger = TermFactory.literal((String)"0", (ATermAppl)Datatypes.INTEGER);
        ATermAppl zeroByte = TermFactory.literal((String)"0", (ATermAppl)Datatypes.BYTE);
        ATermAppl zeroFloat = TermFactory.literal((String)"0", (ATermAppl)Datatypes.FLOAT);
        kb.addClass(A);
        kb.addDatatypeProperty((ATerm)p);
        kb.addIndividual(a);
        kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)Datatypes.NON_POSITIVE_INTEGER));
        kb.addSubClass(A, TermFactory.all((ATermAppl)p, (ATermAppl)Datatypes.NON_NEGATIVE_INTEGER));
        kb.addType(a, A);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, zeroDecimal));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, zeroInteger));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, zeroByte));
        Assert.assertFalse((boolean)kb.hasPropertyValue(a, p, zeroFloat));
        Assert.assertEquals(Collections.singletonList(zeroDecimal), (Object)kb.getDataPropertyValues(p, a));
    }

    @Test
    public void testDataOneOf() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl lit1 = TermFactory.literal((String)"test");
        ATermAppl lit2 = TermFactory.literal((String)"1", (ATermAppl)Datatypes.DECIMAL);
        kb.addClass(A);
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)q);
        kb.addIndividual(a);
        kb.addType(a, A);
        kb.addSubClass(A, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP_LIT));
        kb.addRange((ATerm)p, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{lit1}));
        kb.addSubClass(A, TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.TOP_LIT));
        kb.addRange((ATerm)q, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{lit2}));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertEquals(Collections.singletonList(lit1), (Object)kb.getDataPropertyValues(p, a));
        Assert.assertEquals(Collections.singletonList(lit2), (Object)kb.getDataPropertyValues(q, a));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, lit1));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, q, lit2));
    }

    @Test
    public void testDisjointSelf() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(A);
        kb.addObjectProperty((ATerm)p);
        kb.addDisjointClasses(Arrays.asList(A, TermFactory.self((ATermAppl)p)));
        kb.classify();
        Assert.assertTrue((boolean)kb.isSatisfiable(A));
    }

    @Test
    public void testDisjointPropertiesCache() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p1 = TermFactory.term((String)"p1");
        ATermAppl p2 = TermFactory.term((String)"p2");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        kb.addObjectProperty((ATerm)p1);
        kb.addObjectProperty((ATerm)p2);
        kb.addDisjointProperty(p1, p2);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addPropertyValue(p1, a, c);
        kb.addPropertyValue(p2, b, a);
        ATermAppl notp1a = ATermUtils.makeNot((ATerm)ATermUtils.makeHasValue((ATerm)p1, (ATerm)a));
        Assert.assertFalse((boolean)kb.isType(a, notp1a));
        Assert.assertTrue((boolean)kb.isType(b, notp1a));
        Assert.assertEquals(Collections.singleton(b), (Object)kb.getInstances(notp1a, false));
        Assert.assertFalse((boolean)kb.isType(a, notp1a));
        Assert.assertTrue((boolean)kb.isType(b, notp1a));
    }

    @Test
    public void testSynoymClassification() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addDatatypeProperty((ATerm)p);
        kb.addEquivalentClass(A, B);
        kb.addDomain((ATerm)p, A);
        kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP_LIT));
        kb.classify();
        PelletTestCase.assertSubClass(kb, C, A);
        PelletTestCase.assertSubClass(kb, C, B);
    }

    @Test
    public void testUndefinedProperty() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addPropertyValue(p, a, b);
        kb.isConsistent();
        Assert.assertTrue((boolean)kb.getPropertyValues(q).isEmpty());
    }

    @Test
    public void testGetSubClassBehavior() {
        this.classes(c, d, e);
        this.kb.addEquivalentClass(c, d);
        this.kb.addSubClass(e, d);
        HashSet<Set<ATermAppl>> result = new HashSet<Set<ATermAppl>>();
        result.add(Collections.singleton(ATermUtils.BOTTOM));
        result.add(Collections.singleton(e));
        Assert.assertEquals(result, (Object)this.kb.getSubClasses(c, false));
    }

    @Test
    public void test354() {
        this.classes(B);
        this.objectProperties(p);
        this.individuals(a, b, c);
        this.kb.addFunctionalProperty(p);
        this.kb.addEquivalentClass(B, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        Assert.assertFalse((boolean)this.kb.isType(a, TermFactory.not((ATermAppl)B)));
        this.kb.isSatisfiable(B);
        Assert.assertFalse((boolean)this.kb.isType(a, TermFactory.not((ATermAppl)B)));
    }

    @Test
    public void test370() {
        this.dataProperties(p);
        this.individuals(a);
        ATermAppl dt = TermFactory.restrict((ATermAppl)Datatypes.DECIMAL, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((String)"0.99", (ATermAppl)Datatypes.DECIMAL)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((String)"1.01", (ATermAppl)Datatypes.DECIMAL))});
        this.kb.addType(a, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)dt));
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @Test
    public void test348() {
        this.classes(B, C, D, E);
        this.individuals(a, b, c, d, e);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{d, e}));
        this.kb.addType(b, B);
        this.kb.addType(c, C);
        this.kb.addType(d, D);
        this.kb.addType(e, E);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertEquals(Collections.singleton(b), (Object)this.kb.retrieve(B, Arrays.asList(a, b, d, e)));
        Assert.assertEquals(Collections.singleton(c), (Object)this.kb.retrieve(C, Arrays.asList(a, c, d, e)));
        Assert.assertEquals(Collections.singleton(d), (Object)this.kb.retrieve(D, Arrays.asList(a, d, b, c)));
        Assert.assertEquals(Collections.singleton(e), (Object)this.kb.retrieve(E, Arrays.asList(a, e, b, c)));
    }

    @Test
    public void test375() {
        this.classes(A, B, C);
        this.dataProperties(p);
        ATermAppl dt = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)1))});
        this.kb.addRange((ATerm)p, XSDInteger.getInstance().getName());
        this.kb.addSubClass(A, C);
        this.kb.addEquivalentClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)dt));
        this.kb.addSubClass(B, C);
        this.kb.addEquivalentClass(B, TermFactory.hasValue((ATermAppl)p, (ATermAppl)TermFactory.literal((int)2)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        PelletTestCase.assertSubClass(this.kb, B, A);
        this.kb.classify();
        this.kb.printClassTree();
        PelletTestCase.assertSubClass(this.kb, B, A);
    }

    @Test
    public void minCardinalityOnIrreflexive() {
        this.classes(A);
        this.objectProperties(p);
        this.individuals(a);
        this.kb.addIrreflexiveProperty(p);
        this.kb.addSubClass(A, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP));
        this.kb.addEquivalentClass(A, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a}));
        this.kb.addEquivalentClass(TermFactory.TOP, A);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void subPropertyWithSameRange() {
        this.classes(A);
        this.objectProperties(p, q, r);
        this.kb.addRange((ATerm)p, A);
        this.kb.addDomain((ATerm)p, TermFactory.some((ATermAppl)q, (ATermAppl)A));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSubPropertyOf(p, q));
        Assert.assertFalse((boolean)this.kb.isSubPropertyOf(q, p));
    }

    @Test
    public void roleAbsorptionWithQCR() {
        this.classes(A, B, C);
        this.objectProperties(p);
        this.kb.addSubClass(A, B);
        this.kb.addEquivalentClass(A, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)B));
        this.kb.addSubClass(C, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertNotSubClass(this.kb, C, A);
    }

    @Test
    public void testUnsatClasses1() {
        this.classes(B, C, D);
        this.kb.addSubClass(B, TermFactory.and((ATermAppl)C, (ATermAppl)D));
        Assert.assertTrue((boolean)this.kb.getUnsatisfiableClasses().isEmpty());
        Assert.assertEquals(Collections.singleton(TermFactory.BOTTOM), (Object)this.kb.getAllUnsatisfiableClasses());
        Assert.assertFalse((boolean)this.kb.isClassified());
        Assert.assertTrue((boolean)this.kb.getUnsatisfiableClasses().isEmpty());
        Assert.assertEquals(Collections.singleton(TermFactory.BOTTOM), (Object)this.kb.getAllUnsatisfiableClasses());
    }

    @Test
    public void testUnsatClasses2() {
        this.classes(B, C, D);
        this.kb.addDisjointClass(C, D);
        this.kb.addSubClass(B, TermFactory.and((ATermAppl)C, (ATermAppl)D));
        Assert.assertEquals(Collections.singleton(B), (Object)this.kb.getUnsatisfiableClasses());
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{B, TermFactory.BOTTOM}), (Object)this.kb.getAllUnsatisfiableClasses());
        Assert.assertFalse((boolean)this.kb.isClassified());
        Assert.assertEquals(Collections.singleton(B), (Object)this.kb.getUnsatisfiableClasses());
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{B, TermFactory.BOTTOM}), (Object)this.kb.getAllUnsatisfiableClasses());
    }

    @Test
    public void testGuessingRule() {
        this.classes(C, D);
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addEquivalentClass(C, TermFactory.hasValue((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)a));
        this.kb.addType(a, TermFactory.card((ATermAppl)p, (int)2, (ATermAppl)D));
        this.kb.addType(a, TermFactory.card((ATermAppl)p, (int)3, (ATermAppl)TermFactory.TOP));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
    }

    @Test
    public void testGuessingRule2() {
        this.classes(A, B, C);
        this.objectProperties(p, q);
        this.individuals(a);
        this.kb.addInverseProperty(p, q);
        this.kb.addDomain((ATerm)p, A);
        this.kb.addRange((ATerm)p, TermFactory.or((ATermAppl)B, (ATermAppl)C));
        this.kb.addSubClass(A, TermFactory.card((ATermAppl)p, (int)1, (ATermAppl)B));
        this.kb.addSubClass(A, TermFactory.card((ATermAppl)p, (int)1, (ATermAppl)C));
        this.kb.addSubClass(B, TermFactory.card((ATermAppl)q, (int)1, (ATermAppl)A));
        this.kb.addSubClass(C, TermFactory.card((ATermAppl)q, (int)1, (ATermAppl)A));
        this.kb.addDisjointClasses(Arrays.asList(A, B, C));
        this.kb.addEquivalentClass(A, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a}));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertEquals(Collections.emptySet(), (Object)this.kb.getUnsatisfiableClasses());
    }

    @Test
    public void test484() {
        this.dataProperties(p);
        this.individuals(a);
        ATermAppl dt = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)0)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((int)0))});
        this.kb.addType(a, TermFactory.some((ATermAppl)p, (ATermAppl)dt));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Assert.assertEquals((Object)Clash.ClashType.EMPTY_DATATYPE, (Object)this.kb.getABox().getLastClash().getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test485() {
        Properties oldOptions = PelletOptions.setOptions((Properties)PropertiesBuilder.singleton((String)"DISABLE_EL_CLASSIFIER", (String)"true"));
        try {
            this.classes(A, B, C);
            this.objectProperties(p, q);
            this.individuals(a, b);
            this.kb.addSubClass(B, A);
            this.kb.addSubClass(C, A);
            this.kb.addDomain((ATerm)p, B);
            this.kb.addDomain((ATerm)q, A);
            this.kb.addType(a, A);
            this.kb.addType(b, B);
            this.kb.realize();
            Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A, B, TermFactory.TOP}), (Object)IteratorUtils.toSet((Iterator)new FlattenningIterator((Iterable)this.kb.getSuperClasses(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP)))));
            Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A, TermFactory.TOP}), (Object)IteratorUtils.toSet((Iterator)new FlattenningIterator((Iterable)this.kb.getSuperClasses(TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.TOP)))));
        }
        finally {
            PelletOptions.setOptions((Properties)oldOptions);
        }
    }

    @Test
    public void test518() {
        this.classes(A, B, C);
        this.objectProperties(p, q);
        this.kb.addInverseFunctionalProperty((ATerm)p);
        this.kb.addSubProperty((ATerm)q, TermFactory.inv((ATermAppl)p));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.BOTTOM)))));
    }

    @Test
    public void test553() {
        KnowledgeBase kb = new KnowledgeBase();
        KnowledgeBase copyKB = kb.copy();
        Assert.assertTrue((copyKB != kb ? 1 : 0) != 0);
        Assert.assertTrue((copyKB.getABox().getKB() == copyKB ? 1 : 0) != 0);
    }

    @Test
    public void testFunctionalSubDataProperty() {
        this.individuals(a);
        this.dataProperties(p, q);
        this.kb.addFunctionalProperty(p);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addPropertyValue(p, a, TermFactory.literal((String)"val1"));
        this.kb.addPropertyValue(q, a, TermFactory.literal((String)"val2"));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void test549() {
        int i;
        int n = 5;
        ATermAppl[] ind = new ATermAppl[n];
        for (int i2 = 0; i2 < n; ++i2) {
            ind[i2] = TermFactory.term((String)("ind" + i2));
        }
        ATermAppl[] cls = new ATermAppl[n];
        for (int i3 = 0; i3 < n; ++i3) {
            cls[i3] = TermFactory.term((String)("C" + i3));
        }
        this.classes(cls);
        this.dataProperties(p);
        this.individuals(ind);
        this.kb.addClass(C);
        float lower = 1.0f;
        float increment = 1.0f;
        for (i = 0; i < n; ++i) {
            this.kb.addSubClass(cls[i], C);
            this.kb.addType(ind[i], C);
            float upper = lower + increment;
            ATermAppl dt = TermFactory.term((String)("D" + i));
            ATermAppl def = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((float)lower)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((float)upper))});
            this.kb.addDatatypeDefinition(dt, def);
            this.kb.addEquivalentClass(cls[i], TermFactory.some((ATermAppl)p, (ATermAppl)dt));
            this.kb.addPropertyValue(p, ind[i], TermFactory.literal((float)lower));
            lower = upper;
        }
        for (i = 0; i < n; ++i) {
            Assert.assertEquals(Collections.singleton(ind[i]), (Object)this.kb.getInstances(cls[i]));
        }
    }

    @Test
    public void test532a() {
        this.classes(A, B, C, D);
        this.individuals(a, b, c, d);
        this.objectProperties(p, q);
        this.kb.addDisjointClasses(Arrays.asList(A, B, C, D));
        this.kb.addType(a, TermFactory.or((ATermAppl)A, (ATermAppl)B));
        this.kb.addType(b, TermFactory.or((ATermAppl)C, (ATermAppl)D));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addSame(a, b);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void test532b() {
        this.classes(C, D, E);
        this.individuals(a, b, c, d, e, f);
        this.objectProperties(p);
        this.kb.addType(a, TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        this.kb.addType(a, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, a, c);
        this.kb.addPropertyValue(p, a, d);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addSame(c, e);
        this.kb.addSame(d, e);
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @Test
    public void test560() {
        this.classes(A, B);
        this.individuals(a);
        this.objectProperties(p, q);
        this.kb.addFunctionalProperty(p);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addSubClass(A, TermFactory.hasValue((ATermAppl)q, (ATermAppl)a));
        this.kb.addType(a, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)q), (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a}))));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)A), (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)B))));
    }
}

