/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATermAppl;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.owlapiv3.AxiomConverter;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLAPIAxiomConversionTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";
    private static String ns = "urn:test#";
    private static OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private static OWLDataFactory factory = manager.getOWLDataFactory();
    private static OWLClass c1 = factory.getOWLClass(IRI.create((String)(ns + "c1")));
    private static OWLClass c2 = factory.getOWLClass(IRI.create((String)(ns + "c2")));
    private static OWLClass c3 = factory.getOWLClass(IRI.create((String)(ns + "c3")));
    private static OWLObjectProperty op1 = factory.getOWLObjectProperty(IRI.create((String)(ns + "op1")));
    private static OWLObjectProperty op2 = factory.getOWLObjectProperty(IRI.create((String)(ns + "op2")));
    private static OWLDataProperty dp1 = factory.getOWLDataProperty(IRI.create((String)(ns + "dp1")));
    private static OWLDataProperty dp2 = factory.getOWLDataProperty(IRI.create((String)(ns + "dp2")));
    private static OWLIndividual ind1 = factory.getOWLNamedIndividual(IRI.create((String)(ns + "ind1")));
    private static OWLIndividual ind2 = factory.getOWLNamedIndividual(IRI.create((String)(ns + "ind2")));
    private static OWLIndividual ind3 = factory.getOWLNamedIndividual(IRI.create((String)(ns + "ind3")));
    private static OWLIndividual ind4 = factory.getOWLNamedIndividual(IRI.create((String)(ns + "ind4")));
    private static OWLLiteral lit1 = factory.getOWLLiteral("lit1", OWL2Datatype.XSD_STRING);
    private static OWLDatatype d1 = factory.getOWLDatatype(IRI.create((String)(ns + "d1")));
    private static boolean DEFAULT_TRACING = PelletOptions.USE_TRACING;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(OWLAPIAxiomConversionTests.class);
    }

    @BeforeClass
    public static void turnOnTracing() {
        DEFAULT_TRACING = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
    }

    @AfterClass
    public static void turnOffTracing() {
        PelletOptions.USE_TRACING = DEFAULT_TRACING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testExplanation(OWLAxiom axiom) {
        OWLOntology ont = null;
        try {
            ont = OWL.Ontology((OWLAxiom[])new OWLAxiom[]{axiom});
            PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
            reasoner.getKB().setDoExplanation(true);
            Assert.assertTrue((String)"Entailment failed", (boolean)reasoner.isEntailed(axiom));
            Set terms = reasoner.getKB().getExplanationSet();
            Assert.assertTrue((String)("Explanation incorrect " + terms), (terms.size() == 1 ? 1 : 0) != 0);
            OWLAxiom explanation = new AxiomConverter(reasoner).convert((ATermAppl)terms.iterator().next());
            junit.framework.Assert.assertEquals((String)"Unexpected explanation", (Object)axiom, (Object)explanation);
            if (ont == null) return;
        }
        catch (Throwable throwable) {
            if (ont == null) throw throwable;
            manager.removeOntology(ont);
            throw throwable;
        }
        manager.removeOntology(ont);
    }

    @Test
    public void testSubClassAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSubClassOfAxiom((OWLClassExpression)c1, (OWLClassExpression)c2));
    }

    @Test
    public void testNegativeObjectPropertyAssertion() {
        this.testExplanation((OWLAxiom)factory.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)op1, ind1, ind2));
    }

    @Test
    public void testAntiSymmetricObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testReflexiveObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testDisjointClassesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDisjointClassesAxiom(SetUtils.create((Object[])new OWLClass[]{c1, c2})));
        this.testExplanation((OWLAxiom)factory.getOWLDisjointClassesAxiom(SetUtils.create((Object[])new OWLClass[]{c1, c2, c3})));
    }

    @Test
    public void testDataPropertyDomainAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)dp1, (OWLClassExpression)c1));
    }

    @Test
    public void testObjectPropertyDomainAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)op1, (OWLClassExpression)c1));
    }

    @Test
    public void testEquivalentObjectPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLEquivalentObjectPropertiesAxiom(SetUtils.create((Object[])new OWLObjectProperty[]{op1, op2})));
    }

    @Test
    public void testNegativeDataPropertyAssertion() {
        this.testExplanation((OWLAxiom)factory.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)dp1, ind1, lit1));
    }

    @Test
    public void testDifferentIndividualsAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDifferentIndividualsAxiom(SetUtils.create((Object[])new OWLIndividual[]{ind1, ind2})));
        this.testExplanation((OWLAxiom)factory.getOWLDifferentIndividualsAxiom(SetUtils.create((Object[])new OWLIndividual[]{ind1, ind2, ind3})));
    }

    @Test
    public void testDisjointDataPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDisjointDataPropertiesAxiom(SetUtils.create((Object[])new OWLDataProperty[]{dp1, dp2})));
    }

    @Test
    public void testDisjointObjectPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDisjointObjectPropertiesAxiom(SetUtils.create((Object[])new OWLObjectProperty[]{op1, op2})));
    }

    @Test
    public void testObjectPropertyRangeAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)op1, (OWLClassExpression)c1));
    }

    @Test
    public void testObjectPropertyAssertionAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)op1, ind1, ind2));
    }

    @Test
    public void testFunctionalObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testObjectSubPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)op1, (OWLObjectPropertyExpression)op2));
    }

    public void _testDisjointUnionAxiom() {
    }

    @Test
    public void testSymmetricObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    public void testDataPropertyRangeAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testFunctionalDataPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)dp1));
    }

    @Test
    public void testEquivalentDataPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLEquivalentDataPropertiesAxiom(SetUtils.create((Object[])new OWLDataProperty[]{dp1, dp2})));
    }

    @Test
    public void testClassAssertionAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLClassAssertionAxiom((OWLClassExpression)c1, ind1));
    }

    @Test
    @Ignore
    public void testClassAssertionAnonymousIndividualAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLClassAssertionAxiom((OWLClassExpression)c1, ind4));
    }

    @Test
    public void testEquivalentClassesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLEquivalentClassesAxiom(SetUtils.create((Object[])new OWLClass[]{c1, c2})));
    }

    @Test
    public void testDataPropertyAssertionAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dp1, ind1, lit1));
    }

    @Test
    public void testTransitiveObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testIrreflexiveObjectProperty() {
        this.testExplanation((OWLAxiom)factory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testDataSubPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)dp1, (OWLDataPropertyExpression)dp2));
    }

    @Test
    public void testInverseFunctionalObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testSameIndividualsAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSameIndividualAxiom(SetUtils.create((Object[])new OWLIndividual[]{ind1, ind2})));
    }

    public void _testObjectPropertyChainSubPropertyAxiom() {
    }

    @Test
    public void testInverseObjectPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)op1, (OWLObjectPropertyExpression)op2));
    }
}

