/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PelletTestCase {
    public static <T> Set<T> set(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    protected static boolean isAnonValue(Object n) {
        return n instanceof Resource && ((Resource)n).isAnon() || n instanceof Statement && ((Statement)n).getSubject().isAnon() || n instanceof Statement && PelletTestCase.isAnonValue(((Statement)n).getObject());
    }

    public static <T> void assertIteratorContains(Iterator<T> it, T val) {
        boolean found = false;
        while (it.hasNext() && !found) {
            T obj = it.next();
            found = obj.equals(val);
        }
        Assert.assertTrue((String)("Failed to find expected iterator value: " + val), (boolean)found);
    }

    public static <T> void assertIteratorValues(Iterator<? extends T> it, Iterator<? extends T> expected) {
        PelletTestCase.assertIteratorValues(it, IteratorUtils.toList(expected).toArray());
    }

    public static <T> void assertIteratorValues(Iterator<? extends T> it, T ... expected) {
        boolean[] found = new boolean[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            found[i] = false;
        }
        while (it.hasNext()) {
            T n = it.next();
            boolean gotit = false;
            for (int i = 0; i < expected.length; ++i) {
                if (!n.equals(expected[i])) continue;
                gotit = true;
                found[i] = true;
            }
            Assert.assertTrue((String)("Found unexpected iterator value: " + n), (boolean)gotit);
        }
        ArrayList<T> unfound = new ArrayList<T>();
        for (int i = 0; i < expected.length; ++i) {
            if (found[i]) continue;
            unfound.add(expected[i]);
        }
        Assert.assertTrue((String)("Failed to find expected iterator values: " + unfound), (boolean)unfound.isEmpty());
    }

    public static Set<Statement> createStatements(Resource subject, Property predicate, RDFNode ... objects) {
        HashSet<Statement> set = new HashSet<Statement>();
        for (RDFNode object : objects) {
            set.add(ResourceFactory.createStatement((Resource)subject, (Property)predicate, (RDFNode)object));
        }
        return set;
    }

    public static void addStatements(Model model, Resource subject, Property predicate, RDFNode ... objects) {
        for (RDFNode object : objects) {
            model.add(subject, predicate, object);
        }
    }

    public static void assertPropertyValues(Model model, Resource subject, Property predicate, RDFNode ... objects) {
        Model values = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(values, subject, predicate, objects);
        PelletTestCase.assertPropertyValues(model, predicate, values);
    }

    public static void assertPropertyValues(Model model, final Property pred, Model inferences) {
        Filter<Statement> predFilter = new Filter<Statement>(){

            public boolean accept(Statement stmt) {
                return stmt.getPredicate().equals(pred);
            }
        };
        StmtIterator i = inferences.listStatements();
        while (i.hasNext()) {
            Statement statement = i.nextStatement();
            Assert.assertEquals((Object)pred, (Object)statement.getPredicate());
            Assert.assertTrue((String)(statement + " not inferred"), (boolean)model.contains(statement));
        }
        PelletTestCase.assertIteratorValues(model.listStatements(null, pred, (RDFNode)null), inferences.listStatements());
        HashSet<Resource> testedSubj = new HashSet<Resource>();
        HashSet<RDFNode> testedObj = new HashSet<RDFNode>();
        StmtIterator i2 = inferences.listStatements();
        while (i2.hasNext()) {
            Statement statement = i2.nextStatement();
            Resource subj = statement.getSubject();
            RDFNode obj = statement.getObject();
            if (testedSubj.add(subj)) {
                PelletTestCase.assertIteratorValues(model.listStatements(subj, pred, (RDFNode)null), inferences.listStatements(subj, pred, (RDFNode)null));
                PelletTestCase.assertIteratorValues(model.listStatements(subj, null, (RDFNode)null).filterKeep((Filter)predFilter), inferences.listStatements(subj, null, (RDFNode)null).filterKeep((Filter)predFilter));
            }
            if (!testedObj.add(obj)) continue;
            PelletTestCase.assertIteratorValues(model.listStatements(null, pred, obj), inferences.listStatements(null, pred, obj));
            PelletTestCase.assertIteratorValues(model.listStatements(null, null, obj).filterKeep((Filter)predFilter), inferences.listStatements(null, null, obj).filterKeep((Filter)predFilter));
        }
    }

    public static void testResultSet(ResultSet results, List<Map<String, RDFNode>> ans) {
        ArrayList<Map<String, RDFNode>> answers = new ArrayList<Map<String, RDFNode>>(ans);
        while (results.hasNext()) {
            QuerySolution sol = results.nextSolution();
            Assert.assertNotNull((String)"QuerySolution", (Object)sol);
            HashMap<String, RDFNode> answer = new HashMap<String, RDFNode>();
            for (String var : results.getResultVars()) {
                RDFNode val = sol.get(var);
                Assert.assertNotNull((String)("Variable: " + var), (Object)val);
                answer.put(var, val);
            }
            Assert.assertTrue((String)("Unexpected binding found: " + answer), (boolean)answers.remove(answer));
        }
        Assert.assertTrue((String)("Binding not found: " + answers), (boolean)answers.isEmpty());
    }

    public static Map<String, RDFNode> createBinding(String[] keys, RDFNode[] values) {
        Assert.assertTrue((keys.length == values.length ? 1 : 0) != 0);
        HashMap<String, RDFNode> answer = new HashMap<String, RDFNode>();
        for (int i = 0; i < keys.length; ++i) {
            answer.put(keys[i], values[i]);
        }
        return answer;
    }

    public static List<Map<String, RDFNode>> createBindings(String[] keys, RDFNode[][] values) {
        ArrayList<Map<String, RDFNode>> answers = new ArrayList<Map<String, RDFNode>>();
        for (int i = 0; i < values.length; ++i) {
            HashMap<String, RDFNode> answer = new HashMap<String, RDFNode>();
            for (int j = 0; j < keys.length; ++j) {
                answer.put(keys[j], values[i][j]);
            }
            answers.add(answer);
        }
        return answers;
    }

    public static void printAll(Iterator<?> i) {
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public static void printAll(Iterator<?> i, String head) {
        System.out.print(head + ": ");
        if (i.hasNext()) {
            System.out.println();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        } else {
            System.out.println("<EMPTY>");
        }
    }

    public static void assertSatisfiable(KnowledgeBase kb, ATermAppl c) {
        PelletTestCase.assertSatisfiable(kb, c, true);
    }

    public static void assertUnsatisfiable(KnowledgeBase kb, ATermAppl c) {
        PelletTestCase.assertSatisfiable(kb, c, false);
    }

    public static void assertSatisfiable(KnowledgeBase kb, ATermAppl c, boolean isSatisfiable) {
        Assert.assertEquals((String)("Satisfiability for " + c + " failed"), (Object)isSatisfiable, (Object)kb.isSatisfiable(c));
    }

    public static void assertSubClass(KnowledgeBase kb, String c1, String c2) {
        PelletTestCase.assertSubClass(kb, TermFactory.term((String)c1), TermFactory.term((String)c2));
    }

    public static void assertSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2) {
        PelletTestCase.assertSubClass(kb, c1, c2, true);
    }

    public static void assertNotSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2) {
        PelletTestCase.assertSubClass(kb, c1, c2, false);
    }

    public static void assertSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2, boolean expectedSubClass) {
        boolean computedSubClass = kb.isSubClassOf(c1, c2);
        Assert.assertEquals((String)("Subclass check failed for (" + ATermUtils.toString((ATermAppl)c1) + " [= " + ATermUtils.toString((ATermAppl)c2) + ")"), (Object)expectedSubClass, (Object)computedSubClass);
        kb.isSatisfiable(c1);
        kb.isSatisfiable(TermFactory.not((ATermAppl)c1));
        kb.isSatisfiable(c2);
        kb.isSatisfiable(TermFactory.not((ATermAppl)c2));
        long satCount = kb.getABox().stats.satisfiabilityCount;
        computedSubClass = kb.isSubClassOf(c1, c2);
        boolean cached = satCount == kb.getABox().stats.satisfiabilityCount;
        Assert.assertEquals((String)("Subclass check (Cached: " + cached + ") failed for (" + ATermUtils.toString((ATermAppl)c1) + " [= " + ATermUtils.toString((ATermAppl)c2) + ")"), (Object)expectedSubClass, (Object)computedSubClass);
    }
}

