/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import com.clarkparsia.pellet.rules.RulesToATermTranslator;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class TracingTests
extends AbstractKBTests {
    private final ATermAppl bob = ATermUtils.makeTermAppl((String)"Bob");
    private final ATermAppl robert = ATermUtils.makeTermAppl((String)"Robert");
    private final ATermAppl mary = ATermUtils.makeTermAppl((String)"Mary");
    private final ATermAppl victor = ATermUtils.makeTermAppl((String)"Victor");
    private final ATermAppl email = ATermUtils.makeTermAppl((String)"MaryAndBob@example.com");
    private final ATermAppl mbox = ATermUtils.makeTermAppl((String)"mbox");
    private final ATermAppl relative = ATermUtils.makeTermAppl((String)"relative");
    private final ATermAppl sibling = ATermUtils.makeTermAppl((String)"sibling");
    private final ATermAppl person = ATermUtils.makeTermAppl((String)"person");
    private final ATermAppl human = ATermUtils.makeTermAppl((String)"human");
    private final ATermAppl ssn = ATermUtils.makeTermAppl((String)"ssn");
    private boolean old_USE_TRACING;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TracingTests.class);
    }

    @Before
    public void initializeKB() {
        super.initializeKB();
        this.old_USE_TRACING = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        this.kb.setDoExplanation(true);
    }

    @After
    public void disposeKB() {
        super.disposeKB();
        PelletOptions.USE_TRACING = this.old_USE_TRACING;
    }

    public void explainInconsistency(ATermAppl ... expected) {
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set actual = this.kb.getExplanationSet();
        Assert.assertEquals((Object)SetUtils.create((Object[])expected), (Object)actual);
    }

    public void explainEntailment(boolean entailment, ATermAppl ... expected) {
        Assert.assertTrue((boolean)entailment);
        Set actual = this.kb.getExplanationSet();
        Assert.assertEquals((Object)SetUtils.create((Object[])expected), (Object)actual);
    }

    @Test
    public void testAsymmetric() {
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addAsymmetricProperty(p);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, b, a);
        this.explainInconsistency(ATermUtils.makeAsymmetric((ATerm)p), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a));
    }

    @Test
    public void testBottomSatisfiable() {
        this.kb.addClass(this.human);
        this.explainEntailment(!this.kb.isSatisfiable(ATermUtils.makeAnd((ATerm)ATermUtils.makeNot((ATerm)this.human), (ATerm)ATermUtils.BOTTOM)), new ATermAppl[0]);
    }

    @Test
    public void testCourse() {
        ATermAppl Course = TermFactory.term((String)"Person");
        ATermAppl Person = TermFactory.term((String)"Course");
        ATermAppl Man = TermFactory.term((String)"Man");
        ATermAppl Woman = TermFactory.term((String)"Woman");
        ATermAppl isTaughtBy = TermFactory.term((String)"isTaughtBy");
        ATermAppl M1 = TermFactory.term((String)"M1");
        ATermAppl W1 = TermFactory.term((String)"W1");
        ATermAppl C1 = TermFactory.term((String)"C1");
        ATermAppl P1 = TermFactory.term((String)"P1");
        ATermAppl C2 = TermFactory.term((String)"C2");
        this.kb.addClass(Course);
        this.kb.addClass(Person);
        this.kb.addClass(Man);
        this.kb.addClass(Woman);
        this.kb.addDisjointClass(Man, Woman);
        this.kb.addObjectProperty((ATerm)isTaughtBy);
        this.kb.addFunctionalProperty(isTaughtBy);
        this.kb.addIndividual(C1);
        this.kb.addIndividual(P1);
        this.kb.addIndividual(M1);
        this.kb.addIndividual(M1);
        this.kb.addIndividual(W1);
        this.kb.addIndividual(C2);
        this.kb.addType(C1, Course);
        this.kb.addPropertyValue(isTaughtBy, C1, M1);
        this.kb.addPropertyValue(isTaughtBy, C1, P1);
        this.kb.addType(C2, Course);
        this.kb.addPropertyValue(isTaughtBy, C2, W1);
        this.kb.addPropertyValue(isTaughtBy, C2, P1);
        this.kb.addType(M1, Man);
        this.kb.addType(W1, Woman);
        this.kb.addType(P1, Person);
        this.explainInconsistency(ATermUtils.makeTypeAtom((ATermAppl)M1, (ATermAppl)Man), ATermUtils.makePropAtom((ATermAppl)isTaughtBy, (ATermAppl)C1, (ATermAppl)M1), ATermUtils.makePropAtom((ATermAppl)isTaughtBy, (ATermAppl)C1, (ATermAppl)P1), ATermUtils.makeTypeAtom((ATermAppl)W1, (ATermAppl)Woman), ATermUtils.makePropAtom((ATermAppl)isTaughtBy, (ATermAppl)C2, (ATermAppl)W1), ATermUtils.makePropAtom((ATermAppl)isTaughtBy, (ATermAppl)C2, (ATermAppl)P1), ATermUtils.makeFunctional((ATerm)isTaughtBy), ATermUtils.makeDisjoint((ATerm)Man, (ATerm)Woman));
    }

    @Test
    public void testDatatypeStatement() {
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addIndividual(this.robert);
        ATermAppl ssn1 = ATermUtils.makeTypedLiteral((String)"bob", (String)XSD.nonNegativeInteger.toString());
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn1)));
    }

    @Test
    public void testDisjunction() {
        this.classes(A, B);
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addType(a, A);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addType(a, TermFactory.or((ATermAppl)TermFactory.not((ATermAppl)A), (ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)B)));
        this.explainEntailment(this.kb.isType(b, B), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)A), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.not((ATermAppl)A), (ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)B))));
    }

    @Test
    public void testDomain() {
        this.classes(A, B);
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addDomain((ATerm)p, A);
        this.kb.addType(a, TermFactory.not((ATermAppl)A));
        this.kb.addPropertyValue(p, a, b);
        this.explainInconsistency(ATermUtils.makeDomain((ATerm)p, (ATerm)A), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)TermFactory.not((ATermAppl)A)), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b));
    }

    @Test
    public void testDomainRangeInverse() {
        this.classes(A);
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addDomain((ATerm)p, A);
        this.kb.addRange((ATerm)p, TermFactory.not((ATermAppl)A));
        this.kb.addInverseProperty(p, p);
        this.kb.addPropertyValue(p, a, b);
        this.explainInconsistency(ATermUtils.makeDomain((ATerm)p, (ATerm)A), ATermUtils.makeRange((ATerm)p, (ATerm)TermFactory.not((ATermAppl)A)), ATermUtils.makeInvProp((ATerm)p, (ATerm)p), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b));
    }

    @Test
    public void testDomainRangeSymmetric() {
        this.classes(A);
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addDomain((ATerm)p, A);
        this.kb.addRange((ATerm)p, TermFactory.not((ATermAppl)A));
        this.kb.addSymmetricProperty(p);
        this.kb.addPropertyValue(p, a, b);
        this.explainInconsistency(ATermUtils.makeDomain((ATerm)p, (ATerm)A), ATermUtils.makeRange((ATerm)p, (ATerm)TermFactory.not((ATermAppl)A)), ATermUtils.makeSymmetric((ATerm)p), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b));
    }

    @Test
    public void testEquivalentClass() {
        this.classes(A, B);
        this.kb.addSubClass(A, B);
        this.kb.addSubClass(B, A);
        this.explainEntailment(this.kb.isEquivalentClass(A, B), ATermUtils.makeSub((ATerm)A, (ATerm)B), ATermUtils.makeSub((ATerm)B, (ATerm)A));
    }

    @Test
    public void testFunctionalDataProp2() {
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addFunctionalProperty(this.ssn);
        this.kb.addIndividual(this.robert);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral((String)"012345678");
        ATermAppl ssn2 = ATermUtils.makePlainLiteral((String)"123456789");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        this.kb.addPropertyValue(this.ssn, this.robert, ssn2);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn1), ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn2), ATermUtils.makeFunctional((ATerm)this.ssn));
        Assert.assertTrue((explanation.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testFunctionalDataProp1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = XSDInteger.getInstance().getName();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.literal((String)"012345678", (ATermAppl)Datatypes.INTEGER);
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addDatatypeProperty((ATerm)p);
        this.kb.addIndividual(a);
        this.kb.addEquivalentClass(C, TermFactory.all((ATermAppl)p, (ATermAppl)D));
        this.kb.addFunctionalProperty(p);
        this.kb.addPropertyValue(p, a, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeEqClasses((ATerm)C, (ATerm)TermFactory.all((ATermAppl)p, (ATermAppl)D)), ATermUtils.makeFunctional((ATerm)p), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b));
    }

    @Test
    public void testFunctionalObjectProp1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addEquivalentClass(C, TermFactory.all((ATermAppl)p, (ATermAppl)D));
        this.kb.addFunctionalProperty(p);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addType(b, D);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeEqClasses((ATerm)C, (ATerm)TermFactory.all((ATermAppl)p, (ATermAppl)D)), ATermUtils.makeFunctional((ATerm)p), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b), ATermUtils.makeTypeAtom((ATermAppl)b, (ATermAppl)D));
    }

    @Test
    public void testInverseFunctionalDataProp() {
        ATermList different = ATermUtils.makeList((ATerm)this.robert).insert((ATerm)this.mary);
        System.out.println("Different: " + different);
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addInverseFunctionalProperty((ATerm)this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.email);
        this.kb.addAllDifferent(different);
        this.kb.addPropertyValue(this.mbox, this.robert, this.email);
        this.kb.addPropertyValue(this.mbox, this.mary, this.email);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makePropAtom((ATermAppl)this.mbox, (ATermAppl)this.robert, (ATermAppl)this.email), ATermUtils.makePropAtom((ATermAppl)this.mbox, (ATermAppl)this.mary, (ATermAppl)this.email), ATermUtils.makeInverseFunctional((ATerm)this.mbox), ATermUtils.makeAllDifferent((ATermList)different));
    }

    @Test
    public void testIrreflexive() {
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addIrreflexiveProperty(this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addPropertyValue(this.mbox, this.robert, this.robert);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeIrreflexive((ATerm)this.mbox), ATermUtils.makePropAtom((ATermAppl)this.mbox, (ATermAppl)this.robert, (ATermAppl)this.robert));
    }

    @Test
    public void testMaxOneDataProp() {
        this.kb.addClass(this.person);
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        ATermAppl max1ssn = ATermUtils.makeMax((ATerm)this.ssn, (int)1, (ATerm)ATermUtils.TOP_LIT);
        this.kb.addSubClass(this.person, max1ssn);
        this.kb.addSubClass(this.person, ATermUtils.makeMin((ATerm)this.ssn, (int)1, (ATerm)ATermUtils.TOP_LIT));
        this.kb.addIndividual(this.robert);
        this.kb.addType(this.robert, this.person);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral((String)"012345678");
        ATermAppl ssn2 = ATermUtils.makePlainLiteral((String)"123456789");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        this.kb.addPropertyValue(this.ssn, this.robert, ssn2);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn1), ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn2), ATermUtils.makeSub((ATerm)this.person, (ATerm)max1ssn), ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)this.person));
    }

    @Test
    public void testRange() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addRange((ATerm)this.sibling, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.victor, notPerson);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeRange((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeTypeAtom((ATermAppl)this.victor, (ATermAppl)notPerson), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.robert, (ATermAppl)this.victor));
    }

    @Test
    public void testReflexive() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        ATermAppl bobsType = ATermUtils.makeAllValues((ATerm)this.relative, (ATerm)notPerson);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addReflexiveProperty(this.relative);
        this.kb.addIndividual(this.robert);
        this.kb.addType(this.robert, this.person);
        this.kb.addType(this.robert, bobsType);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.victor, notPerson);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeReflexive((ATerm)this.relative), ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)this.person), ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)bobsType));
    }

    @Test
    public void testSameAllDifferent() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.bob);
        this.kb.addIndividual(this.mary);
        ATermList list = ATermUtils.makeList((ATerm)this.robert);
        list = ATermUtils.makeList((ATerm)this.bob, (ATermList)list);
        list = ATermUtils.makeList((ATerm)this.mary, (ATermList)list);
        this.kb.addAllDifferent(list);
        this.kb.addSame(this.robert, this.bob);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeSameAs((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeAllDifferent((ATermList)list)));
        Assert.assertTrue((explanation.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSameDifferent() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.bob);
        this.kb.addSame(this.robert, this.bob);
        this.kb.addDifferent(this.robert, this.bob);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeSameAs((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeDifferent((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((explanation.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSubProp1() {
        ATermAppl noRelatives = ATermUtils.makeMax((ATerm)this.relative, (int)0, (ATerm)ATermUtils.TOP);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.bob);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addSubProperty((ATerm)this.sibling, this.relative);
        this.kb.addType(this.bob, noRelatives);
        this.kb.addPropertyValue(this.sibling, this.bob, this.mary);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeSubProp((ATerm)this.sibling, (ATerm)this.relative), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.bob, (ATermAppl)this.mary), ATermUtils.makeTypeAtom((ATermAppl)this.bob, (ATermAppl)noRelatives));
    }

    @Test
    public void testSubProp2() {
        ATermAppl nonHumanRelatives = ATermUtils.makeAllValues((ATerm)this.relative, (ATerm)ATermUtils.makeNot((ATerm)this.person));
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.bob);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addSubProperty((ATerm)this.sibling, this.relative);
        this.kb.addType(this.bob, nonHumanRelatives);
        this.kb.addType(this.mary, this.person);
        this.kb.addPropertyValue(this.sibling, this.bob, this.mary);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeSubProp((ATerm)this.sibling, (ATerm)this.relative), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.bob, (ATermAppl)this.mary), ATermUtils.makeTypeAtom((ATermAppl)this.bob, (ATermAppl)nonHumanRelatives), ATermUtils.makeTypeAtom((ATermAppl)this.mary, (ATermAppl)this.person));
    }

    @Test
    public void testTopBottom() {
        this.kb = new KnowledgeBase();
        this.kb.addSubClass(ATermUtils.TOP, ATermUtils.BOTTOM);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeSub((ATerm)ATermUtils.TOP, (ATerm)ATermUtils.BOTTOM));
    }

    @Test
    public void testTransitive() {
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addTransitiveProperty(this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        ATermAppl notVictorsSibling = ATermUtils.makeNot((ATerm)ATermUtils.makeHasValue((ATerm)this.sibling, (ATerm)this.victor));
        this.kb.addType(this.robert, notVictorsSibling);
        this.kb.addPropertyValue(this.sibling, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.mary, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)notVictorsSibling), ATermUtils.makeTransitive((ATerm)this.sibling), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.robert, (ATermAppl)this.mary), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.mary, (ATermAppl)this.victor));
    }

    @Test
    public void testRuleExplanation() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl i = ATermUtils.makeTermAppl((String)"i");
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList<ClassAtom> head = new ArrayList<ClassAtom>();
        body.add(new ClassAtom(C, (AtomIObject)new AtomIVariable("x")));
        head.add(new ClassAtom(D, (AtomIObject)new AtomIVariable("x")));
        Rule rule = new Rule(head, body);
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addType(i, C);
        kb.addRule(rule);
        kb.setDoExplanation(true);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(i, D));
        Set actual = kb.getExplanationSet();
        kb.setDoExplanation(false);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl[] b = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl[] h = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        expected.add(ATermUtils.makeTypeAtom((ATermAppl)i, (ATermAppl)C));
        expected.add(ATermUtils.makeRule((ATermAppl[])h, (ATermAppl[])b));
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testInverseCardinality1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addSubClass(C, TermFactory.max((ATermAppl)invP, (int)0, (ATermAppl)TermFactory.TOP));
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addType(a, C);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.max((ATermAppl)invP, (int)0, (ATermAppl)TermFactory.TOP)), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)C));
    }

    @Test
    public void testInverseCardinality2() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermList inds = ATermUtils.makeList((ATerm[])new ATerm[]{a, b, c});
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addSubClass(C, TermFactory.max((ATermAppl)invP, (int)1, (ATermAppl)TermFactory.TOP));
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addPropertyValue(p, c, a);
        this.kb.addType(a, C);
        this.kb.addAllDifferent(inds);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.max((ATermAppl)invP, (int)1, (ATermAppl)TermFactory.TOP)), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makeAllDifferent((ATermList)inds), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)c, (ATermAppl)a), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)C));
    }

    @Test
    public void testInverseCardinality3() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermList inds = ATermUtils.makeList((ATerm[])new ATerm[]{a, b, c, d});
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addIndividual(d);
        this.kb.addSubClass(C, TermFactory.max((ATermAppl)invP, (int)2, (ATermAppl)TermFactory.TOP));
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addPropertyValue(p, c, a);
        this.kb.addPropertyValue(p, d, a);
        this.kb.addType(a, C);
        this.kb.addAllDifferent(inds);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.max((ATermAppl)invP, (int)2, (ATermAppl)TermFactory.TOP)), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makeAllDifferent((ATermList)inds), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)c, (ATermAppl)a), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)d, (ATermAppl)a), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)C));
    }

    @Test
    public void testInverseAllValues1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)invP, (ATermAppl)D));
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addType(a, C);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(b, D));
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.all((ATermAppl)invP, (ATermAppl)D)), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)C));
    }

    @Test
    public void testInverseAllValues2() {
        this.classes(C, D);
        this.objectProperties(p, q);
        this.individuals(a, b, c);
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)q, (ATermAppl)D));
        this.kb.addTransitiveProperty(p);
        this.kb.addInverseProperty(p, q);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, b, c);
        this.kb.addType(c, C);
        this.kb.addType(a, TermFactory.not((ATermAppl)D));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.all((ATermAppl)q, (ATermAppl)D)), ATermUtils.makeTransitive((ATerm)p), ATermUtils.makeInvProp((ATerm)p, (ATerm)q), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)c), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)TermFactory.not((ATermAppl)D)), ATermUtils.makeTypeAtom((ATermAppl)c, (ATermAppl)C));
    }

    @Test
    public void testRestrictedDatatypeRange() {
        this.classes(C, D);
        this.dataProperties(p);
        this.individuals(a, b, c);
        this.kb.addRange((ATerm)p, TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)10))}));
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)5));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), ATermUtils.makeRange((ATerm)p, (ATerm)TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)10))})), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)TermFactory.literal((int)5)));
    }

    @Test
    public void testDatatypeDefinitionInconsistency() {
        this.classes(C);
        this.dataProperties(p);
        this.individuals(a, b, c);
        this.kb.addRange((ATerm)p, D);
        this.kb.addDatatypeDefinition(D, TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)10))}));
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)5));
        this.explainInconsistency(ATermUtils.makeRange((ATerm)p, (ATerm)D), ATermUtils.makeDatatypeDefinition((ATermAppl)D, (ATermAppl)TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)10))})), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)TermFactory.literal((int)5)));
    }

    @Test
    public void testDatatypeDefinition() {
        this.classes(A);
        this.dataProperties(p);
        this.individuals(a);
        this.kb.addDatatypeDefinition(D, TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)10))}));
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)15));
        this.kb.addEquivalentClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        this.explainEntailment(this.kb.isType(a, A), ATermUtils.makeEqClasses((ATerm)A, (ATerm)TermFactory.some((ATermAppl)p, (ATermAppl)D)), ATermUtils.makeDatatypeDefinition((ATermAppl)D, (ATermAppl)TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)10))})), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)TermFactory.literal((int)15)));
    }

    @Test
    public void testDatatypeEnumeration() {
        this.classes(A);
        this.objectProperties(q);
        this.dataProperties(p);
        this.individuals(a, b);
        this.kb.addDatatypeDefinition(D, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((int)1), TermFactory.literal((int)2)}));
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)1));
        this.kb.addPropertyValue(p, b, TermFactory.literal((int)2));
        this.kb.addPropertyValue(p, b, TermFactory.literal((int)3));
        this.kb.addPropertyValue(q, a, b);
        this.kb.addEquivalentClass(A, TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)D), (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)D)))));
        this.explainEntailment(this.kb.isType(a, A), ATermUtils.makeEqClasses((ATerm)A, (ATerm)TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)D), (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)D))))), ATermUtils.makeDatatypeDefinition((ATermAppl)D, (ATermAppl)TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((int)1), TermFactory.literal((int)2)})), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)TermFactory.literal((int)1)), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)TermFactory.literal((int)3)), ATermUtils.makePropAtom((ATermAppl)q, (ATermAppl)a, (ATermAppl)b));
    }

    @Test
    public void ruleInteractionWithInverses() {
        this.classes(A);
        this.objectProperties(p, q, r, f);
        this.dataProperties(p);
        this.individuals(a, b, c);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomIVariable z = new AtomIVariable("z");
        this.kb.addSymmetricProperty(p);
        this.kb.addInverseProperty(q, r);
        this.kb.addPropertyValue(p, c, a);
        this.kb.addPropertyValue(f, a, b);
        List<RuleAtom> body = Arrays.asList(new IndividualPropertyAtom(f, (AtomIObject)x, (AtomIObject)y), new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)z));
        List<RuleAtom> head = Arrays.asList(new IndividualPropertyAtom(r, (AtomIObject)z, (AtomIObject)y));
        Rule rule = new Rule(head, body);
        this.kb.addRule(rule);
        this.explainEntailment(this.kb.hasPropertyValue(b, q, c), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)c, (ATermAppl)a), ATermUtils.makePropAtom((ATermAppl)f, (ATermAppl)a, (ATermAppl)b), ATermUtils.makeSymmetric((ATerm)p), ATermUtils.makeInvProp((ATerm)q, (ATerm)r), new RulesToATermTranslator().translate(rule));
    }

    @Test
    public void propertyChainInstances() {
        this.objectProperties(p, q, r);
        this.individuals(a, b, c);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(q, b, c);
        this.explainEntailment(this.kb.hasPropertyValue(a, r, c), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b), ATermUtils.makePropAtom((ATermAppl)q, (ATermAppl)b, (ATermAppl)c), ATermUtils.makeSubProp((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), (ATerm)r));
    }

    @Test
    public void propertyChainClasses() {
        this.classes(A, B, C);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)B)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)r, (ATermAppl)B), C);
        this.explainEntailment(this.kb.isSubClassOf(A, C), ATermUtils.makeSub((ATerm)A, (ATerm)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)B))), ATermUtils.makeSub((ATerm)TermFactory.some((ATermAppl)r, (ATermAppl)B), (ATerm)C), ATermUtils.makeSubProp((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), (ATerm)r));
    }

    @Ignore(value="Fails due to #294")
    @Test
    public void propertyChainNested() {
        this.classes(A, B, C);
        this.objectProperties(p, q, r, f);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), p);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, r}), f);
        this.kb.addSubProperty((ATerm)r, q);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)B))));
        this.kb.addSubClass(TermFactory.some((ATermAppl)f, (ATermAppl)B), C);
        this.explainEntailment(this.kb.isSubClassOf(A, C), ATermUtils.makeSub((ATerm)A, (ATerm)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)B))), ATermUtils.makeSub((ATerm)TermFactory.some((ATermAppl)r, (ATermAppl)B), (ATerm)C), ATermUtils.makeSubProp((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), (ATerm)r), ATermUtils.makeSubProp((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{r, p}), (ATerm)f));
    }

    @Test
    public void testDomainExpression() {
        this.classes(A, B);
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addDomain((ATerm)p, TermFactory.or((ATermAppl)A, (ATermAppl)B));
        this.kb.addType(a, TermFactory.not((ATermAppl)TermFactory.or((ATermAppl)A, (ATermAppl)B)));
        this.kb.addPropertyValue(p, a, b);
        this.explainInconsistency(ATermUtils.makeDomain((ATerm)p, (ATerm)TermFactory.or((ATermAppl)A, (ATermAppl)B)), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.or((ATermAppl)A, (ATermAppl)B))), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b));
    }

    @Test
    public void testRangeExpression() {
        this.classes(A, B);
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addRange((ATerm)p, TermFactory.or((ATermAppl)A, (ATermAppl)B));
        this.kb.addType(b, TermFactory.not((ATermAppl)TermFactory.or((ATermAppl)A, (ATermAppl)B)));
        this.kb.addPropertyValue(p, a, b);
        this.explainInconsistency(ATermUtils.makeRange((ATerm)p, (ATerm)TermFactory.or((ATermAppl)A, (ATermAppl)B)), ATermUtils.makeTypeAtom((ATermAppl)b, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.or((ATermAppl)A, (ATermAppl)B))), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b));
    }

    @Test
    public void testFunctionalSubDataProperty() {
        this.individuals(a);
        this.dataProperties(p, q);
        this.kb.addFunctionalProperty(q);
        this.kb.addSubProperty((ATerm)p, q);
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)1));
        this.kb.addPropertyValue(q, a, TermFactory.literal((int)2));
        this.explainInconsistency(ATermUtils.makeFunctional((ATerm)q), ATermUtils.makeSubProp((ATerm)p, (ATerm)q), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)TermFactory.literal((int)1)), ATermUtils.makePropAtom((ATermAppl)q, (ATermAppl)a, (ATermAppl)TermFactory.literal((int)2)));
    }
}

