/*
 * Decompiled with CFR 0.152.
 */
package pellet.test;

import java.io.File;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import pellet.PelletClassify;
import pellet.PelletCmdApp;
import pellet.PelletConsistency;
import pellet.PelletEntailment;
import pellet.PelletExplain;
import pellet.PelletExtractInferences;
import pellet.PelletInfo;
import pellet.PelletModularity;
import pellet.PelletQuery;
import pellet.PelletRealize;
import pellet.PelletTransTree;
import pellet.PelletUnsatisfiable;
import pellet.Pellint;

public class CLITests {
    private static String[] copyOf(String[] arr, int len) {
        String[] ret = new String[len];
        for (int i = 0; i < len && i < arr.length; ++i) {
            ret[i] = arr[i];
        }
        return ret;
    }

    private static String[] prepend(String[] strs, String ... prefix) {
        String[] value = CLITests.copyOf(prefix, strs.length + prefix.length);
        for (int i = prefix.length; i < value.length; ++i) {
            value[i] = strs[i - prefix.length];
        }
        return value;
    }

    private static void runAppSimple(CLIMaker app, String ... args) {
        app.run(args);
    }

    private static void runAppVerbose(CLIMaker app, String ... args) {
        app.run(args);
        app.run(CLITests.prepend(args, "-v"));
        app.run(CLITests.prepend(args, "--verbose"));
    }

    private static void runWithLoaders(CLIMaker app, String ... args) {
        CLITests.runAppVerbose(app, args);
        app.run(CLITests.prepend(args, "-l", "OWLAPI"));
        app.run(CLITests.prepend(args, "-l", "OWLAPIv3"));
        app.run(CLITests.prepend(args, "-l", "Jena"));
    }

    private static void runWithIgnore(CLIMaker app, String ... args) {
        CLITests.runWithLoaders(app, args);
        CLITests.runWithLoaders(app, CLITests.prepend(args, "--ignore-imports"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(CLITests.class);
    }

    @org.junit.Test
    public void classify() {
        CLITests.runWithIgnore(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletClassify();
            }
        }, "test/data/misc/family.owl");
    }

    @org.junit.Test
    public void classifyWithPersist() {
        CLITests.runWithIgnore(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletClassify();
            }
        }, "--persist", "test/data/misc/family.owl");
        File file = new File("persisted-state-aga5g99yq71la6a89exp75qfu.zip");
        Assert.assertTrue((boolean)file.exists());
        CLITests.runWithIgnore(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletClassify();
            }
        }, "--persist", "test/data/misc/family.owl");
        file.delete();
    }

    @org.junit.Test
    public void consistency() {
        CLITests.runWithIgnore(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletConsistency();
            }
        }, "test/data/misc/family.owl");
    }

    @org.junit.Test
    public void entailment() {
        CLITests.runAppVerbose(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletEntailment();
            }
        }, "-e", "test/data/modularity/koala-conclusions.owl", "test/data/modularity/koala.owl");
    }

    @org.junit.Test
    public void explain() {
        CLITests.runAppVerbose(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletExplain();
            }
        }, "test/data/modularity/koala.owl");
    }

    @org.junit.Test
    public void extract() {
        CLITests.runWithIgnore(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletExtractInferences();
            }
        }, "test/data/misc/family.owl");
    }

    @org.junit.Test
    public void info() {
        CLITests.runAppSimple(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletInfo();
            }
        }, "test/data/modularity/koala.owl", "test/data/modularity/galen.owl", "test/data/modularity/miniTambis.owl", "test/data/modularity/SUMO.owl", "test/data/modularity/SWEET.owl", "test/data/modularity/wine.owl");
    }

    @org.junit.Test
    public void modularity() {
        CLITests.runAppVerbose(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletModularity();
            }
        }, "-s", "Koala", "test/data/modularity/koala.owl");
    }

    @org.junit.Test
    public void pellint() {
        CLITests.runAppVerbose(new CLIMaker(){

            protected PelletCmdApp create() {
                return new Pellint();
            }
        }, "test/data/misc/family.owl");
    }

    @org.junit.Test
    public void query() {
        CLITests.runAppVerbose(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletQuery();
            }
        }, "-q", "test/data/query/sameAs/sameAs-01.rq", "test/data/query/sameAs/data-01.ttl");
    }

    @org.junit.Test
    public void realize() {
        CLITests.runWithIgnore(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletRealize();
            }
        }, "test/data/misc/family.owl");
    }

    @org.junit.Test
    public void transTree() {
        CLITests.runAppVerbose(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletTransTree();
            }
        }, "-p", "http://www.co-ode.org/ontologies/test/pellet/transitive.owl#p", "test/data/misc/transitiveSub.owl");
    }

    @org.junit.Test
    public void transTree2() {
        CLITests.runAppVerbose(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletTransTree();
            }
        }, "-p", "http://www.co-ode.org/ontologies/test/pellet/transitive.owl#p", "-f", "http://www.co-ode.org/ontologies/test/pellet/transitive.owl#A", "--individuals", "test/data/misc/transitiveSub.owl");
    }

    @org.junit.Test
    public void unsatisfiable() {
        CLITests.runWithLoaders(new CLIMaker(){

            protected PelletCmdApp create() {
                return new PelletUnsatisfiable();
            }
        }, "test/data/modularity/koala.owl");
    }

    private abstract class CLIMaker {
        private CLIMaker() {
        }

        protected abstract PelletCmdApp create();

        public void run(String ... args) {
            PelletCmdApp app = this.create();
            app.parseArgs(CLITests.prepend(args, new String[]{app.getAppCmd()}));
            app.run();
        }
    }
}

