/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.DNF;
import com.clarkparsia.pellet.datatypes.DataRange;
import com.clarkparsia.pellet.datatypes.DataValueEnumeration;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.EmptyDataRange;
import com.clarkparsia.pellet.datatypes.InfiniteNamedDatatype;
import com.clarkparsia.pellet.datatypes.NamedDataRangeExpander;
import com.clarkparsia.pellet.datatypes.NamedDatatype;
import com.clarkparsia.pellet.datatypes.NegatedDataRange;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.UnionDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.datatypes.types.bool.XSDBoolean;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDate;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTime;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTimeStamp;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGDay;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGMonth;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGMonthDay;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGYear;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGYearMonth;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDTime;
import com.clarkparsia.pellet.datatypes.types.duration.XSDDuration;
import com.clarkparsia.pellet.datatypes.types.floating.XSDDouble;
import com.clarkparsia.pellet.datatypes.types.floating.XSDFloat;
import com.clarkparsia.pellet.datatypes.types.real.OWLRational;
import com.clarkparsia.pellet.datatypes.types.real.OWLReal;
import com.clarkparsia.pellet.datatypes.types.real.XSDByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import com.clarkparsia.pellet.datatypes.types.real.XSDInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDNegativeInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDNonNegativeInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDNonPositiveInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDPositiveInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDShort;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedShort;
import com.clarkparsia.pellet.datatypes.types.text.RDFPlainLiteral;
import com.clarkparsia.pellet.datatypes.types.text.XSDLanguage;
import com.clarkparsia.pellet.datatypes.types.text.XSDNCName;
import com.clarkparsia.pellet.datatypes.types.text.XSDNMToken;
import com.clarkparsia.pellet.datatypes.types.text.XSDName;
import com.clarkparsia.pellet.datatypes.types.text.XSDNormalizedString;
import com.clarkparsia.pellet.datatypes.types.text.XSDString;
import com.clarkparsia.pellet.datatypes.types.text.XSDToken;
import com.clarkparsia.pellet.datatypes.types.uri.XSDAnyURI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeReasonerImpl
implements DatatypeReasoner {
    private static final Map<ATermAppl, Datatype<?>> coreDatatypes;
    private static final DataRange<?> EMPTY_RANGE;
    private static final Logger log;
    private static final DataRange<?> TRIVIALLY_SATISFIABLE;
    private final Set<ATermAppl> declaredUndefined = new HashSet<ATermAppl>();
    private final NamedDataRangeExpander expander = new NamedDataRangeExpander();
    private final Map<ATermAppl, ATermAppl> namedDataRanges = new HashMap<ATermAppl, ATermAppl>();

    private static <T> DataValueEnumeration<? extends T> findSmallestEnumeration(Collection<DataValueEnumeration<? extends T>> ranges) {
        DataValueEnumeration<T> ret = null;
        int best = Integer.MAX_VALUE;
        for (DataValueEnumeration<T> r : ranges) {
            DataValueEnumeration<T> e = r;
            int s = e.size();
            if (s >= best) continue;
            ret = e;
            best = s;
        }
        return ret;
    }

    private static final ATermAppl getDatatypeName(ATermAppl literal) {
        if (!ATermUtils.isLiteral((ATermAppl)literal)) {
            String msg = "Method expected an ATermAppl literal as an argument";
            log.severe("Method expected an ATermAppl literal as an argument");
            throw new IllegalArgumentException("Method expected an ATermAppl literal as an argument");
        }
        ATermAppl dtName = (ATermAppl)literal.getArgument(2);
        if (ATermUtils.EMPTY.equals(dtName)) {
            String msg = "Untyped literals not supported by this datatype reasoner";
            log.severe("Untyped literals not supported by this datatype reasoner");
            throw new IllegalArgumentException("Untyped literals not supported by this datatype reasoner");
        }
        return dtName;
    }

    private static int inequalityCount(Set<Integer>[] nes, int xIndex) {
        Set<Integer> others = nes[xIndex];
        return others == null ? 0 : others.size();
    }

    private static <T> void partitionDConjunction(Collection<DataRange<? extends T>> dconjunction, Set<DataValueEnumeration<? extends T>> positiveEnumerations, Set<DataValueEnumeration<? extends T>> negativeEnumerations, Set<RestrictedDatatype<? extends T>> positiveRestrictions, Set<RestrictedDatatype<? extends T>> negativeRestrictions) {
        for (DataRange<T> dataRange : dconjunction) {
            if (dataRange instanceof DataValueEnumeration) {
                positiveEnumerations.add((DataValueEnumeration)dataRange);
                continue;
            }
            if (dataRange instanceof RestrictedDatatype) {
                positiveRestrictions.add((RestrictedDatatype)dataRange);
                continue;
            }
            if (dataRange instanceof NegatedDataRange) {
                DataRange ndr = ((NegatedDataRange)dataRange).getDataRange();
                if (ndr instanceof DataValueEnumeration) {
                    negativeEnumerations.add((DataValueEnumeration)ndr);
                    continue;
                }
                if (ndr instanceof RestrictedDatatype) {
                    negativeRestrictions.add((RestrictedDatatype)ndr);
                    continue;
                }
                if (dataRange == TRIVIALLY_SATISFIABLE) continue;
                log.warning("Unknown datatype: " + dataRange);
                continue;
            }
            if (dataRange == TRIVIALLY_SATISFIABLE) continue;
            log.warning("Unknown datatype: " + dataRange);
        }
    }

    private static boolean removeInequalities(Set<Integer>[] nes, int xIndex) {
        Set<Integer> others = nes[xIndex];
        if (others == null) {
            return false;
        }
        for (Integer yIndex : others) {
            Set<Integer> s = nes[yIndex];
            if (s == null) {
                throw new IllegalStateException();
            }
            if (s.remove(xIndex)) continue;
            throw new IllegalStateException();
        }
        return true;
    }

    private boolean containedIn(Object value, ATermAppl dconjunction) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (ATermUtils.isAnd((ATermAppl)dconjunction)) {
            ATermList l = (ATermList)dconjunction.getArgument(0);
            while (!l.isEmpty()) {
                if (!this.getDataRange((ATermAppl)l.getFirst()).contains(value)) {
                    return false;
                }
                l = l.getNext();
            }
            return true;
        }
        return this.getDataRange(dconjunction).contains(value);
    }

    @Override
    public boolean containsAtLeast(int n, Collection<ATermAppl> ranges) throws UnrecognizedDatatypeException, InvalidConstrainingFacetException, InvalidLiteralException {
        ATermAppl and = ATermUtils.makeAnd((ATermList)ATermUtils.makeList(ranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr((ATermAppl)dnf)) {
            ArrayList disjuncts = new ArrayList();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                DataRange<?> dr = this.normalizeVarRanges((ATermAppl)l.getFirst());
                if (!dr.isEmpty()) {
                    disjuncts.add(dr);
                }
                l = l.getNext();
            }
            DataRange<?> disjunction = this.getDisjunction(disjuncts);
            return disjunction.containsAtLeast(n);
        }
        DataRange<?> dr = this.normalizeVarRanges(dnf);
        return dr.containsAtLeast(n);
    }

    @Override
    public boolean declare(ATermAppl name) {
        if (this.isDeclared(name)) {
            return false;
        }
        this.declaredUndefined.add(name);
        return true;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl literal) throws InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl dtName = DatatypeReasonerImpl.getDatatypeName(literal);
        Datatype<?> dt = this.getDatatype(dtName);
        if (dt == null) {
            switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return literal;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(dtName, ATermUtils.getLiteralValue((ATermAppl)literal));
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(dtName);
                }
            }
            throw new IllegalStateException();
        }
        return dt.getCanonicalRepresentation(literal);
    }

    private DataRange<?> getDataRange(ATermAppl a) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (a.equals(ATermUtils.TOP_LIT)) {
            return TRIVIALLY_SATISFIABLE;
        }
        if (a.equals(ATermUtils.BOTTOM_LIT)) {
            return EMPTY_RANGE;
        }
        if (ATermUtils.isPrimitive((ATermAppl)a)) {
            InfiniteNamedDatatype dt = this.getDatatype(a);
            if (dt == null) {
                switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                    case INFINITE_STRING: {
                        dt = InfiniteNamedDatatype.get(a);
                        break;
                    }
                    case EMPTY: {
                        return EMPTY_RANGE;
                    }
                    case EXCEPTION: {
                        throw new UnrecognizedDatatypeException(a);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return dt.asDataRange();
        }
        if (ATermUtils.isRestrictedDatatype((ATermAppl)a)) {
            ATermList facetValues;
            ATermAppl dtTerm = (ATermAppl)a.getArgument(0);
            DataRange<?> dt = this.getDataRange(dtTerm);
            if (!(dt instanceof RestrictedDatatype)) {
                throw new InvalidConstrainingFacetException(dtTerm, dt);
            }
            RestrictedDatatype dr = (RestrictedDatatype)dt;
            ATermList l = facetValues = (ATermList)a.getArgument(1);
            while (!l.isEmpty()) {
                Object value;
                ATermAppl fv = (ATermAppl)l.getFirst();
                ATermAppl facet = (ATermAppl)fv.getArgument(0);
                ATermAppl valueTerm = (ATermAppl)fv.getArgument(1);
                try {
                    value = this.getValue(valueTerm);
                }
                catch (InvalidLiteralException e) {
                    throw new InvalidConstrainingFacetException(facet, (Object)valueTerm, e);
                }
                dr = dr.applyConstrainingFacet(facet, value);
                l = l.getNext();
            }
            return dr;
        }
        if (ATermUtils.isNot((ATermAppl)a)) {
            ATermAppl n = (ATermAppl)a.getArgument(0);
            DataRange<?> ndr = this.getDataRange(n);
            NegatedDataRange dr = new NegatedDataRange(ndr);
            return dr;
        }
        if (ATermUtils.isNominal((ATermAppl)a)) {
            ATermAppl literal = (ATermAppl)a.getArgument(0);
            DataValueEnumeration<Object> dr = new DataValueEnumeration<Object>(Collections.singleton(this.getValue(literal)));
            return dr;
        }
        String msg = String.format("Unrecognized input term (%s) for datarange conversion", a);
        log.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Datatype<?> getDatatype(ATermAppl uri) {
        try {
            ATermAppl definition;
            Datatype<?> dt = coreDatatypes.get(uri);
            if (dt == null && (definition = this.namedDataRanges.get(uri)) != null && ATermUtils.isRestrictedDatatype((ATermAppl)definition)) {
                RestrictedDatatype dataRange = (RestrictedDatatype)this.getDataRange(definition);
                NamedDatatype namedDatatype = new NamedDatatype(uri, dataRange);
                dt = namedDatatype;
            }
            return dt;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private DataRange<?> getDisjunction(Collection<DataRange<?>> ranges) {
        Iterator<Object> it;
        if (ranges.size() == 1) {
            return ranges.iterator().next();
        }
        for (DataRange<?> r : ranges) {
            if (r != TRIVIALLY_SATISFIABLE) continue;
            return r;
        }
        Set oneOf = Collections.emptySet();
        HashMap byPrimitive = new HashMap();
        for (DataRange<?> dr : ranges) {
            if (dr instanceof RestrictedDatatype) {
                void var8_8;
                RestrictedDatatype rd = (RestrictedDatatype)dr;
                Datatype<?> pd = rd.getDatatype().getPrimitiveDatatype();
                Set set = (Set)byPrimitive.get(pd);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    byPrimitive.put(pd, hashSet);
                }
                var8_8.add(rd);
                continue;
            }
            if (!(dr instanceof DataValueEnumeration)) continue;
            DataValueEnumeration enm = (DataValueEnumeration)dr;
            if (oneOf.isEmpty()) {
                oneOf = new HashSet();
            }
            it = enm.valueIterator();
            while (it.hasNext()) {
                oneOf.add(it.next());
            }
        }
        HashSet disjointRanges = new HashSet();
        for (Set s : byPrimitive.values()) {
            void var8_13;
            it = s.iterator();
            RestrictedDatatype restrictedDatatype = (RestrictedDatatype)it.next();
            while (it.hasNext()) {
                RestrictedDatatype restrictedDatatype2 = var8_13.union((RestrictedDatatype)it.next());
            }
            disjointRanges.add(var8_13);
        }
        Iterator it2 = oneOf.iterator();
        while (it2.hasNext()) {
            Object o = it2.next();
            for (RestrictedDatatype restrictedDatatype : disjointRanges) {
                if (!restrictedDatatype.contains(o)) continue;
                it2.remove();
            }
        }
        return new UnionDataRange(disjointRanges, oneOf);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        for (Datatype<?> dt : coreDatatypes.values()) {
            if (!dt.isPrimitive() || !dt.asDataRange().contains(value)) continue;
            return dt.getLiteral(value);
        }
        String msg = "Value is not in the value space of any recognized datatypes: " + value.toString();
        log.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Object getValue(ATermAppl literal) throws InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl dtName = DatatypeReasonerImpl.getDatatypeName(literal);
        Datatype<?> dt = this.getDatatype(dtName);
        if (dt == null) {
            switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return literal;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(dtName, ATermUtils.getLiteralValue((ATermAppl)literal));
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(dtName);
                }
            }
            throw new IllegalStateException();
        }
        return dt.getValue(literal);
    }

    @Override
    public boolean isDeclared(ATermAppl name) {
        return ATermUtils.TOP_LIT.equals(name) || coreDatatypes.containsKey(name) || this.namedDataRanges.containsKey(name) || this.declaredUndefined.contains(name);
    }

    @Override
    public boolean isDefined(ATermAppl name) {
        if (ATermUtils.TOP_LIT.equals(name)) {
            return true;
        }
        if (coreDatatypes.containsKey(name)) {
            return true;
        }
        return this.namedDataRanges.containsKey(name);
    }

    @Override
    public ATermAppl getDefinition(ATermAppl name) {
        return this.namedDataRanges.get(name);
    }

    @Override
    public boolean isSatisfiable(Collection<ATermAppl> dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        return this.isSatisfiable(dataranges, null);
    }

    @Override
    public boolean isSatisfiable(Collection<ATermAppl> dataranges, Object value) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Collection<ATermAppl> dnfDisjuncts;
        Set<Integer> vars;
        HashSet<Integer> consts;
        if (value == null) {
            consts = new HashSet();
            vars = new HashSet<Integer>(Collections.singleton(0));
        } else {
            consts = Collections.singleton(0);
            vars = Collections.emptySet();
        }
        ATermAppl and = ATermUtils.makeAnd((ATermList)ATermUtils.makeList(dataranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr((ATermAppl)dnf)) {
            ArrayList<ATermAppl> disjuncts = new ArrayList<ATermAppl>();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                disjuncts.add((ATermAppl)l.getFirst());
                l = l.getNext();
            }
            dnfDisjuncts = disjuncts;
        } else {
            dnfDisjuncts = Collections.singleton(dnf);
        }
        Collection[] dnfTypes = new Collection[]{dnfDisjuncts};
        Set[] ne = new Set[]{Collections.emptySet()};
        return this.isSatisfiable(consts, vars, dnfTypes, new Object[]{value}, ne);
    }

    private boolean isSatisfiable(Set<Integer> consts, Set<Integer> vars, Collection<ATermAppl>[] dnfTypes, Object[] constValues, Set<Integer>[] ne) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Object dr;
        int n = dnfTypes.length;
        for (int i = 0; i < n; ++i) {
            Collection<ATermAppl> drs = dnfTypes[i];
            Iterator<ATermAppl> it2 = drs.iterator();
            while (it2.hasNext()) {
                dr = it2.next();
                if (!ATermUtils.BOTTOM_LIT.equals(dr)) continue;
                it2.remove();
            }
            if (!drs.isEmpty()) continue;
            return false;
        }
        DataRange[] normalized = new DataRange[n];
        for (int i = 0; i < n; ++i) {
            if (consts.contains(i)) {
                boolean satisfied = false;
                for (ATermAppl aTermAppl : dnfTypes[i]) {
                    if (!this.containedIn(constValues[i], aTermAppl)) continue;
                    satisfied = true;
                    break;
                }
                if (satisfied) {
                    normalized[i] = TRIVIALLY_SATISFIABLE;
                    continue;
                }
                return false;
            }
            List<DataRange<?>> drs = new ArrayList();
            for (ATermAppl aTermAppl : dnfTypes[i]) {
                DataRange<?> dr2 = this.normalizeVarRanges(aTermAppl);
                if (dr2 == TRIVIALLY_SATISFIABLE) {
                    drs = Collections.singletonList(TRIVIALLY_SATISFIABLE);
                    break;
                }
                if (dr2.isEmpty()) continue;
                drs.add(dr2);
            }
            if (drs.isEmpty()) {
                return false;
            }
            normalized[i] = this.getDisjunction(drs);
        }
        Iterator<Integer> it3 = vars.iterator();
        while (it3.hasNext()) {
            Integer i = it3.next();
            dr = normalized[i];
            if (TRIVIALLY_SATISFIABLE == dr) {
                it3.remove();
                DatatypeReasonerImpl.removeInequalities(ne, i);
                continue;
            }
            if (dr.isEmpty()) {
                return false;
            }
            if (dr.containsAtLeast(DatatypeReasonerImpl.inequalityCount(ne, i) + 1)) {
                it3.remove();
                DatatypeReasonerImpl.removeInequalities(ne, i);
                continue;
            }
            if (!dr.isFinite() || !dr.isEnumerable() || dr.containsAtLeast(2)) continue;
            Object t = dr.valueIterator().next();
            it3.remove();
            consts.add(i);
            constValues[i.intValue()] = t;
            normalized[i.intValue()] = TRIVIALLY_SATISFIABLE;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("After variable data range normalization %d variables and %d constants", vars.size(), consts.size()));
        }
        for (Integer i : consts) {
            Set<Integer> diffs = ne[i];
            if (diffs == null) continue;
            Iterator<Integer> iterator = diffs.iterator();
            while (iterator.hasNext()) {
                int j = iterator.next();
                if (!consts.contains(j)) continue;
                if (constValues[i].equals(constValues[j])) {
                    return false;
                }
                iterator.remove();
                ne[j].remove(i);
            }
        }
        Iterator<Integer> it = vars.iterator();
        while (it.hasNext()) {
            Set<Integer> set;
            int min;
            int i = it.next();
            dr = normalized[i];
            if (!dr.containsAtLeast(min = (set = ne[i]) == null ? 1 : set.size() + 1)) continue;
            it.remove();
            for (int j : set) {
                if (ne[j] == null) continue;
                ne[j].remove(i);
            }
            ne[i] = null;
            vars.remove(i);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("After size check on variable data ranges %d variables", vars.size()));
        }
        if (vars.isEmpty()) {
            return true;
        }
        HashSet<Integer> remaining = new HashSet<Integer>(vars);
        ArrayList partitions = new ArrayList();
        while (!remaining.isEmpty()) {
            HashSet<Integer> p = new HashSet<Integer>();
            Iterator iterator = remaining.iterator();
            int i = (Integer)iterator.next();
            iterator.remove();
            p.add(i);
            if (ne[i] != null) {
                HashSet<Integer> others = new HashSet<Integer>();
                others.addAll(ne[i]);
                while (!others.isEmpty()) {
                    Iterator jt = others.iterator();
                    int j = (Integer)jt.next();
                    jt.remove();
                    if (!remaining.contains(j)) continue;
                    p.add(j);
                    remaining.remove(j);
                    if (ne[j] == null) continue;
                    others.addAll(ne[j]);
                }
            }
            partitions.add(p);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Enumerating to find solutions for %d partitions", partitions.size()));
        }
        for (Set set : partitions) {
            int nPart = set.size();
            int[] indices = new int[nPart];
            HashMap<Integer, Integer> revInd = new HashMap<Integer, Integer>();
            DataRange[] drs = new DataRange[nPart];
            int i = 0;
            Iterator i$ = set.iterator();
            while (i$.hasNext()) {
                int j = (Integer)i$.next();
                drs[i] = normalized[j];
                indices[i] = j;
                revInd.put(j, i);
                ++i;
            }
            Iterator[] its = new Iterator[nPart];
            for (i = 0; i < nPart; ++i) {
                its[i] = drs[i].valueIterator();
            }
            Object[] values = new Object[nPart];
            for (i = 0; i < nPart; ++i) {
                values[i] = its[i].next();
            }
            boolean solutionFound = false;
            while (!solutionFound) {
                solutionFound = true;
                block17: for (i = 0; i < nPart && solutionFound; ++i) {
                    Set<Integer> diffs = ne[indices[i]];
                    if (diffs == null) continue;
                    Object a = values[i];
                    for (int j : diffs) {
                        Object b = set.contains(j) ? values[(Integer)revInd.get(j)] : constValues[j];
                        if (!a.equals(b)) continue;
                        solutionFound = false;
                        continue block17;
                    }
                }
                if (solutionFound) continue;
                i = nPart - 1;
                while (!its[i].hasNext()) {
                    if (i == 0) {
                        return false;
                    }
                    its[i] = drs[i].valueIterator();
                    values[i] = its[i].next();
                    --i;
                }
                values[i] = its[i].next();
            }
        }
        return true;
    }

    @Override
    public boolean isSatisfiable(Set<Literal> nodes, Map<Literal, Set<Literal>> neqs) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Literal[] literals = nodes.toArray(new Literal[0]);
        HashSet<Integer> vars = new HashSet<Integer>();
        HashSet<Integer> consts = new HashSet<Integer>();
        Object[] constValues = new Object[literals.length];
        HashMap<Literal, Integer> rev = new HashMap<Literal, Integer>();
        for (int i = 0; i < literals.length; ++i) {
            rev.put(literals[i], i);
            if (literals[i].isNominal()) {
                consts.add(i);
                constValues[i] = literals[i].getValue();
                continue;
            }
            vars.add(i);
        }
        Set[] ne = new Set[literals.length];
        for (Map.Entry<Literal, Set<Literal>> e : neqs.entrySet()) {
            int index = (Integer)rev.get(e.getKey());
            ne[index] = new HashSet();
            for (Literal l : e.getValue()) {
                ne[index].add(rev.get(l));
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Checking satisfiability for %d variables and %d constants", vars.size(), consts.size()));
        }
        Collection[] dnfs = new Collection[literals.length];
        for (int i = 0; i < literals.length; ++i) {
            ATermAppl and = ATermUtils.makeAnd((ATermList)ATermUtils.makeList((Collection)literals[i].getTypes()));
            ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
            if (ATermUtils.isOr((ATermAppl)dnf)) {
                ArrayList<ATermAppl> disjuncts = new ArrayList<ATermAppl>();
                ATermList l = (ATermList)dnf.getArgument(0);
                while (!l.isEmpty()) {
                    disjuncts.add((ATermAppl)l.getFirst());
                    l = l.getNext();
                }
                dnfs[i] = disjuncts;
                continue;
            }
            dnfs[i] = Collections.singleton(dnf);
        }
        return this.isSatisfiable(consts, vars, dnfs, constValues, ne);
    }

    @Override
    public boolean define(ATermAppl name, ATermAppl datarange) {
        if (name.equals(datarange)) {
            throw new IllegalArgumentException();
        }
        if (this.namedDataRanges.containsKey(name)) {
            return false;
        }
        this.namedDataRanges.put(name, datarange);
        this.declaredUndefined.remove(name);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private DataRange<?> normalizeVarRanges(ATermAppl dconjunction) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        DataRange<?> ret;
        if (ATermUtils.isAnd((ATermAppl)dconjunction)) {
            void var10_19;
            void var10_16;
            LinkedHashSet ranges = new LinkedHashSet();
            ATermList l = (ATermList)dconjunction.getArgument(0);
            while (!l.isEmpty()) {
                DataRange<?> dr = this.getDataRange((ATermAppl)l.getFirst());
                if (dr.isEmpty()) {
                    return EMPTY_RANGE;
                }
                ranges.add(dr);
                l = l.getNext();
            }
            HashSet positiveEnumerations = new HashSet();
            HashSet negativeEnumerations = new HashSet();
            HashSet positiveRestrictions = new HashSet();
            HashSet negativeRestrictions = new HashSet();
            DatatypeReasonerImpl.partitionDConjunction(ranges, positiveEnumerations, negativeEnumerations, positiveRestrictions, negativeRestrictions);
            if (!positiveEnumerations.isEmpty()) {
                DataValueEnumeration enumeration = DatatypeReasonerImpl.findSmallestEnumeration(positiveEnumerations);
                HashSet remainingValues = new HashSet();
                Iterator iterator = enumeration.valueIterator();
                boolean same = true;
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    boolean bl = true;
                    for (DataRange dataRange : ranges) {
                        if (dataRange == enumeration || dataRange.contains(t)) continue;
                        bl = false;
                        same = false;
                        break;
                    }
                    if (!bl) continue;
                    remainingValues.add(t);
                }
                if (same) {
                    return enumeration;
                }
                if (remainingValues.isEmpty()) {
                    return EMPTY_RANGE;
                }
                return new DataValueEnumeration(remainingValues);
            }
            if (positiveRestrictions.isEmpty()) {
                return TRIVIALLY_SATISFIABLE;
            }
            Datatype<?> rootDt = null;
            for (RestrictedDatatype restrictedDatatype : positiveRestrictions) {
                Datatype<?> dt = restrictedDatatype.getDatatype().getPrimitiveDatatype();
                if (rootDt == null) {
                    rootDt = dt;
                    continue;
                }
                if (rootDt.equals(dt)) continue;
                return EMPTY_RANGE;
            }
            Iterator it = positiveRestrictions.iterator();
            RestrictedDatatype restrictedDatatype = (RestrictedDatatype)it.next();
            while (it.hasNext()) {
                void var10_14;
                RestrictedDatatype other = (RestrictedDatatype)it.next();
                RestrictedDatatype restrictedDatatype2 = var10_14.intersect(other, false);
            }
            for (RestrictedDatatype restrictedDatatype3 : negativeRestrictions) {
                Datatype<?> datatype;
                if (restrictedDatatype3.isEmpty() || !rootDt.equals(datatype = restrictedDatatype3.getDatatype().getPrimitiveDatatype())) continue;
                RestrictedDatatype restrictedDatatype4 = var10_16.intersect(restrictedDatatype3, true);
            }
            if (!negativeEnumerations.isEmpty()) {
                HashSet notOneOf = new HashSet();
                for (DataValueEnumeration dataValueEnumeration : negativeEnumerations) {
                    Iterator oi = dataValueEnumeration.valueIterator();
                    while (oi.hasNext()) {
                        notOneOf.add(oi.next());
                    }
                }
                RestrictedDatatype restrictedDatatype5 = var10_16.exclude(notOneOf);
            }
            ret = var10_19;
        } else {
            ret = this.getDataRange(dconjunction);
        }
        if (!ret.isFinite()) {
            return TRIVIALLY_SATISFIABLE;
        }
        return ret;
    }

    @Override
    public Collection<ATermAppl> listDataRanges() {
        HashSet<ATermAppl> dataRanges = new HashSet<ATermAppl>(coreDatatypes.keySet());
        dataRanges.addAll(this.declaredUndefined);
        dataRanges.addAll(this.namedDataRanges.keySet());
        return dataRanges;
    }

    @Override
    public boolean validLiteral(ATermAppl typedLiteral) throws UnrecognizedDatatypeException {
        if (!ATermUtils.isLiteral((ATermAppl)typedLiteral)) {
            throw new IllegalArgumentException();
        }
        ATermAppl dtTerm = (ATermAppl)typedLiteral.getArgument(2);
        if (dtTerm == null) {
            throw new IllegalArgumentException();
        }
        Datatype<?> dt = this.getDatatype(dtTerm);
        if (dt == null) {
            throw new UnrecognizedDatatypeException(dtTerm);
        }
        try {
            dt.getValue(typedLiteral);
        }
        catch (InvalidLiteralException e) {
            return false;
        }
        return true;
    }

    @Override
    public Iterator<?> valueIterator(Collection<ATermAppl> dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl and = ATermUtils.makeAnd((ATermList)ATermUtils.makeList(dataranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr((ATermAppl)dnf)) {
            ArrayList disjuncts = new ArrayList();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                DataRange<?> dr = this.normalizeVarRanges((ATermAppl)l.getFirst());
                disjuncts.add(dr);
                l = l.getNext();
            }
            DataRange<?> disjunction = this.getDisjunction(disjuncts);
            if (!disjunction.isEnumerable()) {
                throw new IllegalArgumentException();
            }
            return disjunction.valueIterator();
        }
        DataRange<?> dr = this.normalizeVarRanges(dnf);
        if (!dr.isEnumerable()) {
            throw new IllegalArgumentException();
        }
        return dr.valueIterator();
    }

    static {
        log = Logger.getLogger(DatatypeReasonerImpl.class.getCanonicalName());
        coreDatatypes = new HashMap();
        coreDatatypes.put(RDFPlainLiteral.getInstance().getName(), RDFPlainLiteral.getInstance());
        coreDatatypes.put(XSDString.getInstance().getName(), XSDString.getInstance());
        coreDatatypes.put(XSDNormalizedString.getInstance().getName(), XSDNormalizedString.getInstance());
        coreDatatypes.put(XSDToken.getInstance().getName(), XSDToken.getInstance());
        coreDatatypes.put(XSDLanguage.getInstance().getName(), XSDLanguage.getInstance());
        coreDatatypes.put(XSDNMToken.getInstance().getName(), XSDNMToken.getInstance());
        coreDatatypes.put(XSDName.getInstance().getName(), XSDName.getInstance());
        coreDatatypes.put(XSDNCName.getInstance().getName(), XSDNCName.getInstance());
        coreDatatypes.put(XSDBoolean.getInstance().getName(), XSDBoolean.getInstance());
        coreDatatypes.put(OWLReal.getInstance().getName(), OWLReal.getInstance());
        coreDatatypes.put(OWLRational.getInstance().getName(), OWLRational.getInstance());
        coreDatatypes.put(XSDDecimal.getInstance().getName(), XSDDecimal.getInstance());
        coreDatatypes.put(XSDInteger.getInstance().getName(), XSDInteger.getInstance());
        coreDatatypes.put(XSDLong.getInstance().getName(), XSDLong.getInstance());
        coreDatatypes.put(XSDInt.getInstance().getName(), XSDInt.getInstance());
        coreDatatypes.put(XSDShort.getInstance().getName(), XSDShort.getInstance());
        coreDatatypes.put(XSDByte.getInstance().getName(), XSDByte.getInstance());
        coreDatatypes.put(XSDNonNegativeInteger.getInstance().getName(), XSDNonNegativeInteger.getInstance());
        coreDatatypes.put(XSDNonPositiveInteger.getInstance().getName(), XSDNonPositiveInteger.getInstance());
        coreDatatypes.put(XSDNegativeInteger.getInstance().getName(), XSDNegativeInteger.getInstance());
        coreDatatypes.put(XSDPositiveInteger.getInstance().getName(), XSDPositiveInteger.getInstance());
        coreDatatypes.put(XSDUnsignedLong.getInstance().getName(), XSDUnsignedLong.getInstance());
        coreDatatypes.put(XSDUnsignedInt.getInstance().getName(), XSDUnsignedInt.getInstance());
        coreDatatypes.put(XSDUnsignedShort.getInstance().getName(), XSDUnsignedShort.getInstance());
        coreDatatypes.put(XSDUnsignedByte.getInstance().getName(), XSDUnsignedByte.getInstance());
        coreDatatypes.put(XSDDouble.getInstance().getName(), XSDDouble.getInstance());
        coreDatatypes.put(XSDFloat.getInstance().getName(), XSDFloat.getInstance());
        coreDatatypes.put(XSDDateTime.getInstance().getName(), XSDDateTime.getInstance());
        coreDatatypes.put(XSDDateTimeStamp.getInstance().getName(), XSDDateTimeStamp.getInstance());
        coreDatatypes.put(XSDDate.getInstance().getName(), XSDDate.getInstance());
        coreDatatypes.put(XSDGYearMonth.getInstance().getName(), XSDGYearMonth.getInstance());
        coreDatatypes.put(XSDGMonthDay.getInstance().getName(), XSDGMonthDay.getInstance());
        coreDatatypes.put(XSDGYear.getInstance().getName(), XSDGYear.getInstance());
        coreDatatypes.put(XSDGMonth.getInstance().getName(), XSDGMonth.getInstance());
        coreDatatypes.put(XSDGDay.getInstance().getName(), XSDGDay.getInstance());
        coreDatatypes.put(XSDTime.getInstance().getName(), XSDTime.getInstance());
        coreDatatypes.put(XSDDuration.getInstance().getName(), XSDDuration.getInstance());
        coreDatatypes.put(XSDAnyURI.getInstance().getName(), XSDAnyURI.getInstance());
        EMPTY_RANGE = new EmptyDataRange();
        TRIVIALLY_SATISFIABLE = new DataRange<Object>(){

            @Override
            public boolean contains(Object value) {
                return true;
            }

            @Override
            public boolean containsAtLeast(int n) {
                return true;
            }

            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public Object getValue(int i) {
                throw new UnsupportedOperationException();
            }

            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean isEnumerable() {
                return false;
            }

            @Override
            public boolean isFinite() {
                return false;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Object> valueIterator() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

