/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyRestrictedDatatype;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.IntervalRelations;
import com.clarkparsia.pellet.datatypes.OWLRealInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedRealDatatype
implements RestrictedDatatype<Number> {
    private static final Logger log = Logger.getLogger(RestrictedRealDatatype.class.getCanonicalName());
    private final Datatype<? extends Number> datatype;
    private final RestrictedDatatype<Number> empty;
    private final boolean enumerable;
    private final boolean finite;
    private final List<OWLRealInterval> intervals;

    public RestrictedRealDatatype(Datatype<? extends Number> datatype, OWLRealInterval interval) {
        this.datatype = datatype;
        this.empty = new EmptyRestrictedDatatype<Number>(datatype);
        this.intervals = Collections.singletonList(interval);
        this.finite = interval.isFinite();
        this.enumerable = interval.isPoint() || interval.getType().equals((Object)OWLRealInterval.LineType.INTEGER_ONLY);
    }

    private RestrictedRealDatatype(RestrictedRealDatatype other, List<OWLRealInterval> intervals) {
        this.datatype = other.datatype;
        this.empty = other.empty;
        this.intervals = Collections.unmodifiableList(intervals);
        if (other.finite) {
            this.finite = true;
        } else {
            boolean allFinite = true;
            for (OWLRealInterval i : intervals) {
                if (i.isFinite()) continue;
                allFinite = false;
                break;
            }
            this.finite = allFinite;
        }
        if (other.enumerable) {
            this.enumerable = true;
        } else {
            boolean allEnumerable = true;
            for (OWLRealInterval i : intervals) {
                if (i.isPoint() || i.getType().equals((Object)OWLRealInterval.LineType.INTEGER_ONLY)) continue;
                allEnumerable = false;
                break;
            }
            this.enumerable = allEnumerable;
        }
    }

    @Override
    public RestrictedDatatype<Number> applyConstrainingFacet(ATermAppl facet, Object value) {
        boolean inclusiveUpper;
        Number upper;
        boolean inclusiveLower;
        Number lower;
        Facet f = Facet.Registry.get(facet);
        if (f == null) {
            String msg = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        Number n = null;
        if (value instanceof Number && !OWLRealUtils.acceptable((n = (Number)value).getClass())) {
            n = null;
        }
        if (n == null) {
            String msg = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), f, value);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(f)) {
            lower = null;
            inclusiveLower = false;
            upper = n;
            inclusiveUpper = false;
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(f)) {
            lower = null;
            inclusiveLower = false;
            upper = n;
            inclusiveUpper = true;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(f)) {
            lower = n;
            inclusiveLower = false;
            upper = null;
            inclusiveUpper = false;
        } else if (Facet.XSD.MIN_INCLUSIVE.equals(f)) {
            lower = n;
            inclusiveLower = true;
            upper = null;
            inclusiveUpper = false;
        } else {
            throw new IllegalStateException();
        }
        OWLRealInterval restriction = new OWLRealInterval(lower, upper, inclusiveLower, inclusiveUpper, OWLRealInterval.LineType.CONTINUOUS);
        ArrayList<OWLRealInterval> revisedIntervals = new ArrayList<OWLRealInterval>();
        boolean changes = false;
        for (OWLRealInterval i : this.intervals) {
            OWLRealInterval j = i.intersection(restriction);
            if (j != null) {
                revisedIntervals.add(j);
                if (i == j) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        if (changes) {
            if (revisedIntervals.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, revisedIntervals);
        }
        return this;
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            if (OWLRealUtils.acceptable(n.getClass())) {
                for (OWLRealInterval i : this.intervals) {
                    if (!i.contains(n)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (!this.finite || n <= 0) {
            return true;
        }
        Number sum = 0;
        for (OWLRealInterval i : this.intervals) {
            sum = OWLRealUtils.integerSum(sum, i.size());
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<Number> exclude(Collection<?> values) {
        boolean changes = false;
        ArrayList<OWLRealInterval> revisedIntervals = new ArrayList<OWLRealInterval>(this.intervals);
        block0: for (Object o : values) {
            if (!(o instanceof Number)) continue;
            Number n = (Number)o;
            Iterator it = revisedIntervals.iterator();
            while (it.hasNext()) {
                OWLRealInterval greater;
                OWLRealInterval i = (OWLRealInterval)it.next();
                if (!i.contains(n)) continue;
                changes = true;
                it.remove();
                OWLRealInterval less = i.less(n);
                if (less != null) {
                    revisedIntervals.add(less);
                }
                if ((greater = i.greater(n)) == null) continue block0;
                revisedIntervals.add(greater);
                continue block0;
            }
        }
        if (changes) {
            if (revisedIntervals.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, revisedIntervals);
        }
        return this;
    }

    @Override
    public Datatype<? extends Number> getDatatype() {
        return this.datatype;
    }

    @Override
    public Number getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<Number> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedRealDatatype) {
            List<OWLRealInterval> intersectWith;
            RestrictedRealDatatype otherRRD = (RestrictedRealDatatype)other;
            ArrayList<OWLRealInterval> revisedIntervals = new ArrayList<OWLRealInterval>();
            if (negated) {
                intersectWith = new ArrayList<OWLRealInterval>(Arrays.asList(OWLRealInterval.allReals()));
                for (OWLRealInterval i : otherRRD.intervals) {
                    ArrayList<OWLRealInterval> tmp = new ArrayList<OWLRealInterval>();
                    for (OWLRealInterval j : intersectWith) {
                        tmp.addAll(j.remove(i));
                    }
                    intersectWith = tmp;
                }
            } else {
                intersectWith = otherRRD.intervals;
            }
            for (OWLRealInterval i : this.intervals) {
                for (OWLRealInterval j : intersectWith) {
                    OWLRealInterval k = i.intersection(j);
                    if (k == null) continue;
                    revisedIntervals.add(k);
                }
            }
            if (revisedIntervals.equals(this.intervals)) {
                return this;
            }
            if (revisedIntervals.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, revisedIntervals);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return this.enumerable;
    }

    @Override
    public boolean isFinite() {
        return this.finite;
    }

    @Override
    public int size() {
        if (!this.finite) {
            throw new IllegalStateException();
        }
        Number sum = 0;
        for (OWLRealInterval i : this.intervals) {
            sum = OWLRealUtils.integerSum(sum, i.size());
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        return sum;
    }

    @Override
    public RestrictedDatatype<Number> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedRealDatatype) {
            RestrictedRealDatatype otherRRD = (RestrictedRealDatatype)other;
            ArrayList<OWLRealInterval> revisedIntervals = new ArrayList<OWLRealInterval>(this.intervals);
            EnumSet<IntervalRelations> connected = EnumSet.complementOf(EnumSet.of(IntervalRelations.PRECEDED_BY, IntervalRelations.PRECEDES));
            for (OWLRealInterval i : otherRRD.intervals) {
                ArrayList<OWLRealInterval> unionWith = new ArrayList<OWLRealInterval>();
                Iterator jt = revisedIntervals.iterator();
                while (jt.hasNext()) {
                    OWLRealInterval j = (OWLRealInterval)jt.next();
                    IntervalRelations rel = i.compare(j);
                    if (!connected.contains((Object)rel)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedIntervals.add(i);
                    continue;
                }
                HashSet<OWLRealInterval> tmp = new HashSet<OWLRealInterval>();
                for (OWLRealInterval j : unionWith) {
                    tmp.addAll(i.union(j));
                }
                revisedIntervals.addAll(tmp);
            }
            return new RestrictedRealDatatype(this, revisedIntervals);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Number> valueIterator() {
        if (!this.enumerable) {
            throw new IllegalStateException();
        }
        return new Iterator<Number>(){
            final Iterator<OWLRealInterval> iit;
            Iterator<Number> nit;
            {
                this.iit = RestrictedRealDatatype.this.intervals.iterator();
                this.nit = null;
            }

            @Override
            public boolean hasNext() {
                while (this.nit == null || !this.nit.hasNext()) {
                    if (this.iit.hasNext()) {
                        this.nit = this.iit.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Number next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.nit.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return String.format("{%s,%s}", this.datatype, this.intervals);
    }
}

