/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.math.BigDecimal;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDecimal
implements Datatype<Number> {
    private static final XSDDecimal instance;
    private static final Logger log;
    private final RestrictedRealDatatype dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl((String)"http://www.w3.org/2001/XMLSchema#decimal");

    public static XSDDecimal getInstance() {
        return instance;
    }

    private XSDDecimal() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedRealDatatype(this, OWLRealInterval.allReals());
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral((ATermAppl)input)) {
            throw new IllegalArgumentException();
        }
        if (!input.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue((ATermAppl)input);
        try {
            BigDecimal d = DatatypeConverter.parseDecimal((String)lexicalForm);
            String canonicalForm = DatatypeConverter.printDecimal((BigDecimal)d);
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return ATermUtils.makeTypedLiteral((String)canonicalForm, (ATermAppl)this.name);
        }
        catch (NumberFormatException e) {
            log.severe(String.format("Number format exception (%s) cause while parsing decimal %s", e.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (this.dataRange.contains(value)) {
            return ATermUtils.makeTypedLiteral((String)OWLRealUtils.print((Number)value), (ATermAppl)this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral((ATermAppl)literal)) {
            throw new IllegalArgumentException();
        }
        if (!literal.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue((ATermAppl)literal);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseDecimal((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        log = Logger.getLogger(XSDDecimal.class.getCanonicalName());
        instance = new XSDDecimal();
    }
}

