/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.XSDDecimal;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDLong
implements Datatype<Number> {
    private static final XSDLong instance;
    private static final Logger log;
    private final RestrictedDatatype<Number> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl((String)"http://www.w3.org/2001/XMLSchema#long");

    public static XSDLong getInstance() {
        return instance;
    }

    private XSDLong() {
        this.hashCode = this.name.hashCode();
        OWLRealInterval i = new OWLRealInterval(Long.MIN_VALUE, Long.MAX_VALUE, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        this.dataRange = new RestrictedRealDatatype(this, i);
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral((ATermAppl)input)) {
            throw new IllegalArgumentException();
        }
        if (!input.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue((ATermAppl)input);
        try {
            DatatypeConverter.parseLong((String)lexicalForm);
        }
        catch (NumberFormatException e) {
            log.severe(String.format("Number format exception (%s) cause while parsing long %s", e.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
        return XSDDecimal.getInstance().getCanonicalRepresentation(ATermUtils.makeTypedLiteral((String)lexicalForm, (ATermAppl)XSDDecimal.getInstance().getName()));
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDecimal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral((ATermAppl)literal)) {
            throw new IllegalArgumentException();
        }
        if (!literal.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue((ATermAppl)literal);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseLong((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        log = Logger.getLogger(XSDLong.class.getCanonicalName());
        instance = new XSDLong();
    }
}

